package gov.va.med.ccht.service.dmpreport.impl;

import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import javax.xml.datatype.DatatypeFactory;
import gov.va.med.ccht.service.common.impl.AbstractBusinessService;
import gov.va.med.ccht.service.dmpreport.DmpReportService;
import gov.va.med.ccht.model.dmpreport.DmpReportEntry;
import gov.va.med.cds.ars.ARService;
import gov.va.med.cds.ars.AggregateReportingServiceInterface;
import gov.va.med.cds.ars.DMPTitleReportFilterType;
import gov.va.med.cds.ars.DMPUniqueICNReportFilterType;
import gov.va.med.cds.ars.GeographicalAreaType;
import gov.va.med.cds.ars.HTReportFilterType;
import gov.va.med.cds.ars.HTReportType;
import gov.va.med.cds.ars.ObjectFactory;
import gov.va.med.cds.ars.ReportIDType;
import gov.va.med.cds.ars.DMPTitleType;
import gov.va.med.fw.service.ServiceException;

public class DmpReportServiceImpl extends AbstractBusinessService implements DmpReportService {
	
	private String hdrEndpoint;
	private ARService arService;
	private static String SURVEY_VERSION= "All Versions";
	private static String NATIONAL_LOCATION="National";
	AggregateReportingServiceInterface arServicePort;

		//ALL Standard DMPS available
		public List<String> findAllStandardDmpNames()throws ServiceException
		{
			ObjectFactory of = new ObjectFactory();
			List<String> dmpNames = new ArrayList<String>();
			//arServicePort=this.arService.getAggregateReportingServicePort();
			try
			{ 
				this.arService=new ARService(new URL(this.hdrEndpoint),new QName("http://cds.domain.ext/", "ARService"));

				arServicePort=this.arService.getAggregateReportingServicePort();
			}
			catch(Exception e)
			{
				logger.error(e.getMessage());
				throw new ServiceException("No arService");
				
			}
			boolean arServiceAvailable = arServicePort.isAlive();
			if(!arServiceAvailable)
			{
				logger.error("No arService");
				throw new ServiceException("No arService");
			}
			else
			{
				HTReportFilterType htReportFilterType =of.createHTReportFilterType();
				DMPTitleReportFilterType dmpTitleRportFilterType = of.createDMPTitleReportFilterType();
				dmpTitleRportFilterType.setReportID(ReportIDType.DMP_TITLE_REPORT);
				htReportFilterType.setDMPTitleReportFilter(dmpTitleRportFilterType);
				JAXBElement<HTReportFilterType> jaxbFilterElement = of.createHtReportFilter(htReportFilterType);
				JAXBContext context=null;
				StringWriter writer = new StringWriter();
				try 
				{
					context = JAXBContext.newInstance(HTReportFilterType.class);
					Marshaller marshaller=null;
					marshaller = context.createMarshaller();
					marshaller.marshal(jaxbFilterElement, writer);
					String result = arServicePort.readAggregateData(writer.toString(),ReportIDType.DMP_TITLE_REPORT.name(),"HTCE", "1001");
					StringReader resultReader = new StringReader(result);
					JAXBContext jaxbResult=JAXBContext.newInstance(HTReportType.class);
					Unmarshaller jaxbUnmarshaler = jaxbResult.createUnmarshaller();
					JAXBElement<HTReportType> dmpTitlesData=jaxbUnmarshaler.unmarshal(new StreamSource(resultReader),HTReportType.class);
					List<DMPTitleType> dmpTitleTypes = dmpTitlesData.getValue().getResponse().getDMPTitleReportData().getDmpTitles().getTitle();
					if (dmpTitleTypes==null){
						throw new ServiceException("arService JAXBException");
					}
					else if(dmpTitleTypes.size()<1)
					{
						throw new ServiceException("arService JAXBException");
					}
					else
					{
						for(DMPTitleType dmpTitleType:dmpTitleTypes)
						{	
							//String version = (dmpTitleType.getVersion()==null) ? "" : dmpTitleType.getVersion();
							dmpNames.add(dmpTitleType.getTitle());
						}
					}
					dmpNames = new ArrayList<String>(new HashSet<String>(dmpNames));
				} catch (Exception e) {
					throw new ServiceException("arService JAXBException");				}
			}
			return dmpNames;
		}
		//DMP
		
		public ArrayList<DmpReportEntry> findDmpReportsByDmp(List<DmpReportEntry> dmpReportEntries)throws ServiceException
		{
			ArrayList<DmpReportEntry> results = new ArrayList<DmpReportEntry>();
			ObjectFactory of = new ObjectFactory();
			Integer recordNum = new Integer(0);
			try
			{ 
				arService=new ARService(new URL(this.hdrEndpoint),new QName("http://cds.domain.ext/", "ARService"));
				arServicePort=this.arService.getAggregateReportingServicePort();
			
				arServicePort=this.arService.getAggregateReportingServicePort();
			}
			catch(Exception e)
			{
				logger.error(e.getMessage());
				throw new ServiceException("No arService");
				
			}
			boolean arServiceAvailable = arServicePort.isAlive();
			if(!arServiceAvailable)
			{
				throw new ServiceException("No arService");
			}
			else
			{
				for(DmpReportEntry dmpReportEntry: dmpReportEntries)
				{
				HTReportFilterType htReportFilterType =of.createHTReportFilterType();
				DMPUniqueICNReportFilterType dmpFilterType = of.createDMPUniqueICNReportFilterType();				
				dmpFilterType.setReportID(ReportIDType.DMP_UNIQUE_ICN_REPORT);
				dmpFilterType.setSurveyType(dmpReportEntry.getDmp());
				dmpFilterType.setSurveyVersion(DmpReportServiceImpl.SURVEY_VERSION);
				GeographicalAreaType geographicalAreaType = new GeographicalAreaType();
				geographicalAreaType.setLocation(DmpReportServiceImpl.NATIONAL_LOCATION);
				dmpFilterType.setGeographicalArea(geographicalAreaType);
				GregorianCalendar gcStartDate = new GregorianCalendar();
				gcStartDate.setTime(dmpReportEntry.getStartDate());
				dmpFilterType.setStartDate(this.getMarshalDate(gcStartDate.get(Calendar.YEAR),gcStartDate.get(Calendar.MONTH)+1, gcStartDate.get(Calendar.DAY_OF_MONTH)));
				GregorianCalendar gcEndDate = new GregorianCalendar();
				gcStartDate.setTime(dmpReportEntry.getEndDate());
				dmpFilterType.setEndDate(this.getMarshalDate(gcEndDate.get(Calendar.YEAR),gcEndDate.get(Calendar.MONTH)+1, gcEndDate.get(Calendar.DAY_OF_MONTH)));
				htReportFilterType.setDMPUniqueICNReportFilter(dmpFilterType);
				JAXBElement<HTReportFilterType> jaxbFilterElement = of.createHtReportFilter(htReportFilterType);
				JAXBContext context=null;
				StringWriter writer = new StringWriter();
				
				try 
				{
					context = JAXBContext.newInstance(HTReportFilterType.class);
					Marshaller marshaller=null;
					marshaller = context.createMarshaller();
					marshaller.marshal(jaxbFilterElement, writer);
					String result = arServicePort.readAggregateData(writer.toString(),ReportIDType.DMP_UNIQUE_ICN_REPORT.name(),"HTCE", "1001");
					StringReader resultReader = new StringReader(result);
					JAXBContext jaxbResult=JAXBContext.newInstance(HTReportType.class);
					Unmarshaller jaxbUnmarshaler = jaxbResult.createUnmarshaller();
					JAXBElement<HTReportType> dmpReportData=jaxbUnmarshaler.unmarshal(new StreamSource(resultReader),HTReportType.class);
					recordNum = dmpReportData.getValue().getResponse().getDMPUniqueICNReportData().getNumberOfRecordsConsidered();
					dmpReportEntry.setNumberOfPatients(recordNum);
					results.add(dmpReportEntry);
				} catch (JAXBException e) {
					throw new ServiceException("arService JAXBException");				}
			}
			}
			return results;
		}
		//DMP AND FACILITY
		public ArrayList<DmpReportEntry> findDmpReportsByDmpAndFacility(List<DmpReportEntry> dmpReportEntries)throws ServiceException
		{
			ArrayList<DmpReportEntry> results = new ArrayList<DmpReportEntry>();
			ObjectFactory of = new ObjectFactory();
			Integer recordNum = new Integer(0);
			//arService=new ARService(new URL(this.hdrEndpoint),new QName("http://cds.domain.ext/", "ARService"));
			//arServicePort=this.arService.getAggregateReportingServicePort();
			HTReportFilterType htReportFilterType =of.createHTReportFilterType();
			DMPUniqueICNReportFilterType dmpFilterType = of.createDMPUniqueICNReportFilterType();				
			GeographicalAreaType geographicalAreaType = new GeographicalAreaType();
			GregorianCalendar gcStartDate = new GregorianCalendar();
			GregorianCalendar gcEndDate = new GregorianCalendar();
			JAXBContext context=null;
			Marshaller marshaller=null;
			try {
				context = JAXBContext.newInstance(HTReportFilterType.class);
				marshaller = context.createMarshaller();
				arService=new ARService(new URL(this.hdrEndpoint),new QName("http://cds.domain.ext/", "ARService"));
				arServicePort=this.arService.getAggregateReportingServicePort();
			}
			catch(Exception e)
			{
				logger.error(e.getMessage());
				throw new ServiceException("No arService");
				
			}
			boolean arServiceAvailable = arServicePort.isAlive();
			if(!arServiceAvailable)
			{
				throw new ServiceException("No arService");
			}
			else
			{
				for(DmpReportEntry dmpReportEntry: dmpReportEntries)
				{
				dmpFilterType.setReportID(ReportIDType.DMP_UNIQUE_ICN_REPORT);
				dmpFilterType.setSurveyType(dmpReportEntry.getDmp());
				dmpFilterType.setSurveyVersion(DmpReportServiceImpl.SURVEY_VERSION);
				geographicalAreaType.setLocation(dmpReportEntry.getFacilityStationNumber());
				dmpFilterType.setGeographicalArea(geographicalAreaType);
				gcStartDate.setTime(dmpReportEntry.getStartDate());
				dmpFilterType.setStartDate(this.getMarshalDate(gcStartDate.get(Calendar.YEAR),gcStartDate.get(Calendar.MONTH)+1, gcStartDate.get(Calendar.DAY_OF_MONTH)));
				gcStartDate.setTime(dmpReportEntry.getEndDate());
				dmpFilterType.setEndDate(this.getMarshalDate(gcEndDate.get(Calendar.YEAR),gcEndDate.get(Calendar.MONTH)+1, gcEndDate.get(Calendar.DAY_OF_MONTH)));
				htReportFilterType.setDMPUniqueICNReportFilter(dmpFilterType);
				JAXBElement<HTReportFilterType> jaxbFilterElement = of.createHtReportFilter(htReportFilterType);
				
				try 
				{
					StringWriter writer = new StringWriter();
					marshaller.marshal(jaxbFilterElement, writer);
					String result = arServicePort.readAggregateData(writer.toString(),ReportIDType.DMP_UNIQUE_ICN_REPORT.name(),"HTCE", "1001");
					StringReader resultReader = new StringReader(result);
					JAXBContext jaxbResult=JAXBContext.newInstance(HTReportType.class);
					Unmarshaller jaxbUnmarshaler = jaxbResult.createUnmarshaller();
					JAXBElement<HTReportType> dmpReportData=jaxbUnmarshaler.unmarshal(new StreamSource(resultReader),HTReportType.class);
					recordNum = dmpReportData.getValue().getResponse().getDMPUniqueICNReportData().getNumberOfRecordsConsidered();
					dmpReportEntry.setNumberOfPatients(recordNum);
					results.add(dmpReportEntry);
				} catch (JAXBException e) {
					throw new ServiceException("arService JAXBException");				
					}
			}
			}
			return results;
		}		
		//DMP AND VISN
		public ArrayList<DmpReportEntry> findDmpReportsByDmpAndVisn(List<DmpReportEntry> dmpReportEntries)throws ServiceException
		{
			ArrayList<DmpReportEntry> results = new ArrayList<DmpReportEntry>();
			ObjectFactory of = new ObjectFactory();
			Integer recordNum = new Integer(0);
			try
			{ 
			
				arService=new ARService(new URL(this.hdrEndpoint),new QName("http://cds.domain.ext/", "ARService"));
				arServicePort=this.arService.getAggregateReportingServicePort();
			}
			catch(Exception e)
			{
				logger.error(e.getMessage());
				throw new ServiceException("No arService");
				
			}
			boolean arServiceAvailable = arServicePort.isAlive();
			if(!arServiceAvailable)
			{
				throw new ServiceException("No arService");
			}
			else
			{
				for(DmpReportEntry dmpReportEntry: dmpReportEntries)
				{
				HTReportFilterType htReportFilterType =of.createHTReportFilterType();
				DMPUniqueICNReportFilterType dmpFilterType = of.createDMPUniqueICNReportFilterType();				
				dmpFilterType.setReportID(ReportIDType.DMP_UNIQUE_ICN_REPORT);
				dmpFilterType.setSurveyType(dmpReportEntry.getDmp());
				dmpFilterType.setSurveyVersion(DmpReportServiceImpl.SURVEY_VERSION);
				GeographicalAreaType geographicalAreaType = new GeographicalAreaType();
				geographicalAreaType.setLocation(dmpReportEntry.getVisn());
				dmpFilterType.setGeographicalArea(geographicalAreaType);
				GregorianCalendar gcStartDate = new GregorianCalendar();
				gcStartDate.setTime(dmpReportEntry.getStartDate());
				dmpFilterType.setStartDate(this.getMarshalDate(gcStartDate.get(Calendar.YEAR),gcStartDate.get(Calendar.MONTH)+1, gcStartDate.get(Calendar.DAY_OF_MONTH)));
				GregorianCalendar gcEndDate = new GregorianCalendar();
				gcStartDate.setTime(dmpReportEntry.getEndDate());
				dmpFilterType.setEndDate(this.getMarshalDate(gcEndDate.get(Calendar.YEAR),gcEndDate.get(Calendar.MONTH)+1, gcEndDate.get(Calendar.DAY_OF_MONTH)));
				htReportFilterType.setDMPUniqueICNReportFilter(dmpFilterType);
				JAXBElement<HTReportFilterType> jaxbFilterElement = of.createHtReportFilter(htReportFilterType);
				JAXBContext context=null;
				StringWriter writer = new StringWriter();
				
				try 
				{
					context = JAXBContext.newInstance(HTReportFilterType.class);
					Marshaller marshaller=null;
					marshaller = context.createMarshaller();
					marshaller.marshal(jaxbFilterElement, writer);
					String result = arServicePort.readAggregateData(writer.toString(),ReportIDType.DMP_UNIQUE_ICN_REPORT.name(),"HTCE", "1001");
					StringReader resultReader = new StringReader(result);
					JAXBContext jaxbResult=JAXBContext.newInstance(HTReportType.class);
					Unmarshaller jaxbUnmarshaler = jaxbResult.createUnmarshaller();
					JAXBElement<HTReportType> dmpReportData=jaxbUnmarshaler.unmarshal(new StreamSource(resultReader),HTReportType.class);
					recordNum = dmpReportData.getValue().getResponse().getDMPUniqueICNReportData().getNumberOfRecordsConsidered();
					dmpReportEntry.setNumberOfPatients(recordNum);
					results.add(dmpReportEntry);
				} catch (JAXBException e) {
					throw new ServiceException("arService JAXBException");				}
			}
			}
			return results;
		}		
		
		//DMP AND VENDOR
		public ArrayList<DmpReportEntry> findDmpReportsByDmpAndVendor(List<DmpReportEntry> dmpReportEntries)throws ServiceException
		{
			ArrayList<DmpReportEntry> results = new ArrayList<DmpReportEntry>();
			ObjectFactory of = new ObjectFactory();
			Integer recordNum = new Integer(0);
			try
			{ 
			
				arService=new ARService(new URL(this.hdrEndpoint),new QName("http://cds.domain.ext/", "ARService"));
				arServicePort=this.arService.getAggregateReportingServicePort();
			}
			catch(Exception e)
			{
				logger.error(e.getMessage());
				throw new ServiceException("No arService");
				
			}
			boolean arServiceAvailable = arServicePort.isAlive();
			if(!arServiceAvailable)
			{
				throw new ServiceException("No arService");
			}
			else
			{
				for(DmpReportEntry dmpReportEntry: dmpReportEntries)
				{
				HTReportFilterType htReportFilterType =of.createHTReportFilterType();
				DMPUniqueICNReportFilterType dmpFilterType = of.createDMPUniqueICNReportFilterType();				
				dmpFilterType.setReportID(ReportIDType.DMP_UNIQUE_ICN_REPORT);
				dmpFilterType.setSurveyType(dmpReportEntry.getDmp());
				dmpFilterType.setSurveyVersion(DmpReportServiceImpl.SURVEY_VERSION);
				dmpFilterType.setVendor(dmpReportEntry.getVendorNumber());
				GeographicalAreaType geographicalAreaType = new GeographicalAreaType();
				geographicalAreaType.setLocation(DmpReportServiceImpl.NATIONAL_LOCATION);
				dmpFilterType.setGeographicalArea(geographicalAreaType);
				GregorianCalendar gcStartDate = new GregorianCalendar();
				gcStartDate.setTime(dmpReportEntry.getStartDate());
				dmpFilterType.setStartDate(this.getMarshalDate(gcStartDate.get(Calendar.YEAR),gcStartDate.get(Calendar.MONTH)+1, gcStartDate.get(Calendar.DAY_OF_MONTH)));
				GregorianCalendar gcEndDate = new GregorianCalendar();
				gcStartDate.setTime(dmpReportEntry.getEndDate());
				dmpFilterType.setEndDate(this.getMarshalDate(gcEndDate.get(Calendar.YEAR),gcEndDate.get(Calendar.MONTH)+1, gcEndDate.get(Calendar.DAY_OF_MONTH)));
				htReportFilterType.setDMPUniqueICNReportFilter(dmpFilterType);
				JAXBElement<HTReportFilterType> jaxbFilterElement = of.createHtReportFilter(htReportFilterType);
				JAXBContext context=null;
				StringWriter writer = new StringWriter();
				
				try 
				{
					context = JAXBContext.newInstance(HTReportFilterType.class);
					Marshaller marshaller=null;
					marshaller = context.createMarshaller();
					marshaller.marshal(jaxbFilterElement, writer);
					String result = arServicePort.readAggregateData(writer.toString(),ReportIDType.DMP_UNIQUE_ICN_REPORT.name(),"HTCE", "1001");
					StringReader resultReader = new StringReader(result);
					JAXBContext jaxbResult=JAXBContext.newInstance(HTReportType.class);
					Unmarshaller jaxbUnmarshaler = jaxbResult.createUnmarshaller();
					JAXBElement<HTReportType> dmpReportData=jaxbUnmarshaler.unmarshal(new StreamSource(resultReader),HTReportType.class);
					recordNum = dmpReportData.getValue().getResponse().getDMPUniqueICNReportData().getNumberOfRecordsConsidered();
					dmpReportEntry.setNumberOfPatients(recordNum);
					results.add(dmpReportEntry);
				} catch (JAXBException e) {
					throw new ServiceException("arService JAXBException");				}
			}
			}
			return results;
		}		
		
		//DMP, FACILITY, VENDOR
		public ArrayList<DmpReportEntry> findDmpReportsByDmpFacilityAndVendor(List<DmpReportEntry> dmpReportEntries)throws ServiceException
		{
			ArrayList<DmpReportEntry> results = new ArrayList<DmpReportEntry>();
			ObjectFactory of = new ObjectFactory();
			Integer recordNum = new Integer(0);
			//arServicePort=this.arService.getAggregateReportingServicePort();
			HTReportFilterType htReportFilterType =of.createHTReportFilterType();
			DMPUniqueICNReportFilterType dmpFilterType = of.createDMPUniqueICNReportFilterType();				
			GeographicalAreaType geographicalAreaType = new GeographicalAreaType();
			GregorianCalendar gcStartDate = new GregorianCalendar();
			GregorianCalendar gcEndDate = new GregorianCalendar();
			JAXBContext context=null;
			Marshaller marshaller=null;
			try {
				context = JAXBContext.newInstance(HTReportFilterType.class);
				marshaller = context.createMarshaller();
				arService=new ARService(new URL(this.hdrEndpoint),new QName("http://cds.domain.ext/", "ARService"));
				arServicePort=this.arService.getAggregateReportingServicePort();
			}
			catch(Exception e)
			{
				logger.error(e.getMessage());
				throw new ServiceException("No arService");
				
			}
			boolean arServiceAvailable = arServicePort.isAlive();
			if(!arServiceAvailable)
			{
				throw new ServiceException("No arService");
			}
			else
			{
				for(DmpReportEntry dmpReportEntry: dmpReportEntries)
				{
				dmpFilterType.setReportID(ReportIDType.DMP_UNIQUE_ICN_REPORT);
				dmpFilterType.setSurveyType(dmpReportEntry.getDmp());
				dmpFilterType.setSurveyVersion(DmpReportServiceImpl.SURVEY_VERSION);
				dmpFilterType.setVendor(dmpReportEntry.getVendorNumber());
				geographicalAreaType.setLocation(dmpReportEntry.getFacilityStationNumber());
				dmpFilterType.setGeographicalArea(geographicalAreaType);
				gcStartDate.setTime(dmpReportEntry.getStartDate());
				dmpFilterType.setStartDate(this.getMarshalDate(gcStartDate.get(Calendar.YEAR),gcStartDate.get(Calendar.MONTH)+1, gcStartDate.get(Calendar.DAY_OF_MONTH)));
				gcStartDate.setTime(dmpReportEntry.getEndDate());
				dmpFilterType.setEndDate(this.getMarshalDate(gcEndDate.get(Calendar.YEAR),gcEndDate.get(Calendar.MONTH)+1, gcEndDate.get(Calendar.DAY_OF_MONTH)));
				htReportFilterType.setDMPUniqueICNReportFilter(dmpFilterType);
				JAXBElement<HTReportFilterType> jaxbFilterElement = of.createHtReportFilter(htReportFilterType);
				
				try 
				{
					StringWriter writer = new StringWriter();
					marshaller.marshal(jaxbFilterElement, writer);
					String result = arServicePort.readAggregateData(writer.toString(),ReportIDType.DMP_UNIQUE_ICN_REPORT.name(),"HTCE", "1001");
					StringReader resultReader = new StringReader(result);
					JAXBContext jaxbResult=JAXBContext.newInstance(HTReportType.class);
					Unmarshaller jaxbUnmarshaler = jaxbResult.createUnmarshaller();
					JAXBElement<HTReportType> dmpReportData=jaxbUnmarshaler.unmarshal(new StreamSource(resultReader),HTReportType.class);
					recordNum = dmpReportData.getValue().getResponse().getDMPUniqueICNReportData().getNumberOfRecordsConsidered();
					dmpReportEntry.setNumberOfPatients(recordNum);
					results.add(dmpReportEntry);
				} catch (JAXBException e) {
					throw new ServiceException("arService JAXBException");				
					}

			}
			}
			return results;
		}		
		
		//DMP, VISN, VENDOR
		public ArrayList<DmpReportEntry> findDmpReportsByDmpVisnAndVendor(List<DmpReportEntry> dmpReportEntries)throws ServiceException
		{
			ArrayList<DmpReportEntry> results = new ArrayList<DmpReportEntry>();
			ObjectFactory of = new ObjectFactory();
			Integer recordNum = new Integer(0);
			try
			{ 
			
				arService=new ARService(new URL(this.hdrEndpoint),new QName("http://cds.domain.ext/", "ARService"));
				arServicePort=this.arService.getAggregateReportingServicePort();
			}
			catch(Exception e)
			{
				logger.error(e.getMessage());
				throw new ServiceException("No arService");
				
			}
			boolean arServiceAvailable = arServicePort.isAlive();
			if(!arServiceAvailable)
			{
				throw new ServiceException("No arService");
			}
			else
			{
				for(DmpReportEntry dmpReportEntry: dmpReportEntries)
				{
				HTReportFilterType htReportFilterType =of.createHTReportFilterType();
				DMPUniqueICNReportFilterType dmpFilterType = of.createDMPUniqueICNReportFilterType();				
				dmpFilterType.setReportID(ReportIDType.DMP_UNIQUE_ICN_REPORT);
				dmpFilterType.setSurveyType(dmpReportEntry.getDmp());
				dmpFilterType.setSurveyVersion(DmpReportServiceImpl.SURVEY_VERSION);
				dmpFilterType.setVendor(dmpReportEntry.getVendorNumber());
				GeographicalAreaType geographicalAreaType = new GeographicalAreaType();
				geographicalAreaType.setLocation(dmpReportEntry.getVisn());
				dmpFilterType.setGeographicalArea(geographicalAreaType);
				GregorianCalendar gcStartDate = new GregorianCalendar();
				gcStartDate.setTime(dmpReportEntry.getStartDate());
				dmpFilterType.setStartDate(this.getMarshalDate(gcStartDate.get(Calendar.YEAR),gcStartDate.get(Calendar.MONTH)+1, gcStartDate.get(Calendar.DAY_OF_MONTH)));
				GregorianCalendar gcEndDate = new GregorianCalendar();
				gcStartDate.setTime(dmpReportEntry.getEndDate());
				dmpFilterType.setEndDate(this.getMarshalDate(gcEndDate.get(Calendar.YEAR),gcEndDate.get(Calendar.MONTH)+1, gcEndDate.get(Calendar.DAY_OF_MONTH)));
				htReportFilterType.setDMPUniqueICNReportFilter(dmpFilterType);
				JAXBElement<HTReportFilterType> jaxbFilterElement = of.createHtReportFilter(htReportFilterType);
				JAXBContext context=null;
				StringWriter writer = new StringWriter();
				
				try 
				{
					context = JAXBContext.newInstance(HTReportFilterType.class);
					Marshaller marshaller=null;
					marshaller = context.createMarshaller();
					marshaller.marshal(jaxbFilterElement, writer);
					String result = arServicePort.readAggregateData(writer.toString(),ReportIDType.DMP_UNIQUE_ICN_REPORT.name(),"HTCE", "1001");
					StringReader resultReader = new StringReader(result);
					JAXBContext jaxbResult=JAXBContext.newInstance(HTReportType.class);
					Unmarshaller jaxbUnmarshaler = jaxbResult.createUnmarshaller();
					JAXBElement<HTReportType> dmpReportData=jaxbUnmarshaler.unmarshal(new StreamSource(resultReader),HTReportType.class);
					recordNum = dmpReportData.getValue().getResponse().getDMPUniqueICNReportData().getNumberOfRecordsConsidered();
					dmpReportEntry.setNumberOfPatients(recordNum);
					results.add(dmpReportEntry);
				} catch (JAXBException e) {
					throw new ServiceException("arService JAXBException");				}
			}
			}
			return results;
		}

		public String getHdrEndpoint() {
			return hdrEndpoint;
		}

		public void setHdrEndpoint(String hdrEndpoint) {
			this.hdrEndpoint = hdrEndpoint;
		}

		public ARService getArService() {
			return arService;
		}

		public void setArService(ARService arService) {
			this.arService = arService;
/*			try
			{ 
			
				arServicePort=this.arService.getAggregateReportingServicePort();
			}
			catch(Exception e)
			{
				logger.error(e.getMessage());
				
			}
*/		}
private XMLGregorianCalendar getMarshalDate(int year, int month, int day) 
{
	
		XMLGregorianCalendar xmlGcDate=null;
		try {
			xmlGcDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar(year,month,day));
			xmlGcDate.setMillisecond(DatatypeConstants.FIELD_UNDEFINED);
			xmlGcDate.setTimezone(DatatypeConstants.FIELD_UNDEFINED);
			xmlGcDate.setMinute(DatatypeConstants.FIELD_UNDEFINED);
			xmlGcDate.setHour(DatatypeConstants.FIELD_UNDEFINED);
			xmlGcDate.setSecond(DatatypeConstants.FIELD_UNDEFINED);		
			} 
		catch (DatatypeConfigurationException e) {
			logger.error(e.getMessage());
		}

		return xmlGcDate;
}

}
