package gov.va.med.ccht.service.dmpreport.impl;

import gov.va.med.ccht.model.car.CensusActivityRecord;
import gov.va.med.ccht.model.car.CensusActivityReportParameters;
import gov.va.med.ccht.model.car.CensusActivitySubTotalRecord;
import gov.va.med.ccht.persistent.CensusActivityReportDAO;
import gov.va.med.ccht.service.common.impl.AbstractBusinessService;
import gov.va.med.ccht.service.dmpreport.CensusActivityReportService;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;

import java.util.Date;
import java.util.List;

public class CensusActivityReportServiceImpl extends AbstractBusinessService implements
		CensusActivityReportService {
	
	private CensusActivityReportDAO censusActivityReportDAO;
	
	public CensusActivityReportDAO getCensusActivityReportDAO() 
	{
		return censusActivityReportDAO;
	}

	public void setCensusActivityReportDAO(CensusActivityReportDAO censusActivityReportDAO) 
	{
		this.censusActivityReportDAO = censusActivityReportDAO;
	}
	
	@Override
	public void getFacilityReport(CensusActivityReportParameters reportParams)
			throws ServiceException {
		
		try 
		{
			censusActivityReportDAO.getFacilityReport(reportParams);
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}
	}

	@Override
	public  List<CensusActivityRecord> getNationalReport(CensusActivityReportParameters reportParams)
			throws ServiceException {
		try 
		{
			return censusActivityReportDAO.getNationalReport(reportParams);
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}
		
	}
	
	@Override
	public  List<CensusActivitySubTotalRecord> getSubTotaledNationalReport(CensusActivityReportParameters reportParams)
			throws ServiceException {
		try 
		{
			return censusActivityReportDAO.getSubTotaledNationalReport(reportParams);
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}		
	}

	@Override
	public  List<CensusActivityRecord> getNationalReportByVendor(CensusActivityReportParameters reportParams)
			throws ServiceException {
		try 
		{
			return censusActivityReportDAO.getNationalReportByVendor(reportParams);
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}
		
	}
	
	public List<CensusActivityRecord> getNationalReportByModality(CensusActivityReportParameters reportParams) throws ServiceException
	{
		try 
		{
			return censusActivityReportDAO.getNationalReportByModality(reportParams);
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}
	}
	
	@Override
	public  List<CensusActivitySubTotalRecord> getSubTotaledNationalReportByModality(CensusActivityReportParameters reportParams)
			throws ServiceException {
		try 
		{
			return censusActivityReportDAO.getSubTotaledNationalReportByModality(reportParams);
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}		
	}

	public List<CensusActivityRecord> getNationalReportByModalityAndVendor(CensusActivityReportParameters reportParams) throws ServiceException
	{
		try 
		{
			return censusActivityReportDAO.getNationalReportByModalityAndVendor(reportParams);
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}
	}
	@Override
	public void getVisnReport(CensusActivityReportParameters reportParams)
			throws ServiceException {
		try 
		{
			censusActivityReportDAO.getVisnReport(reportParams);
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}
		
	}
	
	public CensusActivityRecord getLastReportWeek() throws ServiceException
	{
		try 
		{
			CensusActivityRecord retVal = censusActivityReportDAO.getLastReportWeek(); 
			return retVal;
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}
	}

}
