package gov.va.med.ccht.service.dmp.impl;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.HashSet;

import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

import org.springframework.mail.SimpleMailMessage;

import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.dmp.DMP;
import gov.va.med.ccht.model.dmp.DMPFindReplaceCriteria;
import gov.va.med.ccht.model.dmp.DMPFindResults;
import gov.va.med.ccht.model.dmp.DMPSearch;
import gov.va.med.ccht.model.dmp.DMPSearchParameters;
import gov.va.med.ccht.model.dmp.DMPStandLibEntry;
import gov.va.med.ccht.model.dmp.DMPToolUser;
import gov.va.med.ccht.model.dmp.DMPQuestion;
import gov.va.med.ccht.model.dmp.DMPResponse;
import gov.va.med.ccht.model.dmp.DMPReview;
import gov.va.med.ccht.model.dmp.DMPVendorDeployment;
import gov.va.med.ccht.model.inventory.Vendor;
import gov.va.med.ccht.persistent.DMPDAO;
import gov.va.med.ccht.persistent.InventoryDAO;
import gov.va.med.ccht.persistent.SecurityDAO;
import gov.va.med.ccht.service.common.SecurityService;
import gov.va.med.ccht.service.common.impl.AbstractBusinessService;
import gov.va.med.ccht.service.dmp.DMPService;

import gov.va.med.ccht.util.DMPExport;
import gov.va.med.ccht.util.ValidatorUtil;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.builder.ValidatorException;

public class DMPServiceImpl extends AbstractBusinessService implements
		DMPService {
	private DMPDAO dmpDAO;
	private SecurityService securityService;
	private SecurityDAO securityDAO;
	private InventoryDAO inventoryDAO;
	private DMPExport dmpExport;
	private SimpleMailMessage dmpDeployToVendorMailMessage;
	

	
	public User getUserByLoginId(String username) throws ServiceException {
		try {

			return securityDAO.getUserByName(username);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	public DMP saveDMP(DMP dmp) throws ServiceException {
		try {
					
			new ValidatorUtil().validate(dmp);
			return dmpDAO.saveDMP(dmp);
		}
		catch(ConstraintViolationException ce){
			
			String errMsg = null;
			for (ConstraintViolation<?> constraintViolation : ce.getConstraintViolations()) {
				  	String propertyPath = constraintViolation.getPropertyPath().toString();
			        String message = constraintViolation.getMessage();
			        errMsg = propertyPath + " " + message;
			}						
			throw new ServiceException(errMsg,ce);					
		}
		catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
		
	}

	public DMPStandLibEntry saveDMPStandLibEntry(
			DMPStandLibEntry dmpStandLibEntry) throws ServiceException {
		try {

			return dmpDAO.saveDMPStandLibEntry(dmpStandLibEntry);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}

	}
	public DMPVendorDeployment saveDMPVendorDeployment(
			DMPVendorDeployment dmpVendorDeployment) throws ServiceException {
		try {

			return dmpDAO.saveDMPVendorDeployment(dmpVendorDeployment);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}

	}
	public DMPStandLibEntry findDMPStanLibEntryById(Long id)
			throws ServiceException {
		try {

			return dmpDAO.findDMPStanLibEntryById(id);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}

	}

	public Boolean isDmpStandLibEntryDuplicate(DMPStandLibEntry dmpStandLibEntry)
			throws ServiceException {
		try {

			return dmpDAO.isDMPStandLibEntryDuplicate(dmpStandLibEntry);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}

	}

	public DMPToolUser saveDMPToolUser(DMPToolUser assignee) throws ServiceException {
		return saveDMPToolUser(assignee, true);
	}
	
	public DMPToolUser saveDMPToolUser(DMPToolUser assignee, boolean isAssignDMP) throws ServiceException {
		try {
		
			return dmpDAO.saveDMPToolUser(assignee, isAssignDMP);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	public DMPQuestion saveDMPQuestion(DMPQuestion question)
			throws ServiceException {
		try {

			return dmpDAO.saveDMPQuestion(question);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	public DMPResponse saveDMPResponse(DMPResponse response)
			throws ServiceException {
		try {

			return dmpDAO.saveDMPResponse(response);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	public void deleteDMPToolUser(EntityKey<Object> identifier)
			throws ServiceException {
		try {

			dmpDAO.deleteDMPToolUser(identifier);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	public void deleteDMPQuestion(EntityKey<Object> identifier)
			throws ServiceException {
		try {
			DMPQuestion q = dmpDAO.findQuestionById(identifier
					.getKeyValueAsString());
			DMP dmp = q.getDmp();
			Set<DMPQuestion> questions = dmp.getQuestions();
			for (DMPQuestion aQ : questions) {
				Set<DMPResponse> reponses = aQ.getResponses();
				for (DMPResponse aResponse : reponses) {
					if (aResponse.getBranchId().longValue() == q.getId()
							.longValue()) {
						aResponse.setBranchId(new Long(-1));
						dmpDAO.saveDMPResponse(aResponse);
					}
				}
			}
			dmpDAO.deleteDMPQuestion(identifier);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	public void deleteDMPResponse(EntityKey<Object> identifier)
			throws ServiceException {
		try {

			dmpDAO.deleteDMPResponse(identifier);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	public void deleteDMPResponses(Collection<DMPResponse> responses)
			throws ServiceException {
		try {

			dmpDAO.deleteDMPResponses(responses);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	public DMPDAO getDmpDAO() {
		return dmpDAO;
	}

	public void setDmpDAO(DMPDAO dmpDAO) {
		this.dmpDAO = dmpDAO;
	}

	public List<DMP> findAllDmps() throws ServiceException {
		try {
			logger.debug("***VAKA***:  dmp service calling dmpDAO.findAllDmps");
			return dmpDAO.findAllDmps();
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	public List<DMP> findAssigedDmps(String userId) throws ServiceException {
		List<DMP> results = new ArrayList<DMP>();
		try {
			List<DMPToolUser> dmpToolUsers = dmpDAO.getAllMyAssigedDmps(userId);

			// List<DMPToolUser> dmpToolUsers = dmpDAO.findAssigedDmps(userId);
			for (DMPToolUser dmpToolUser : dmpToolUsers) {
				results.add(dmpToolUser.getDmp());
			}
			return results;
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	public List<DMP> findAdminViewMyDmps(String userId) throws ServiceException {
		Set<DMP> results = new HashSet<DMP>();
		try {
			List<DMPToolUser> dmpToolUsers = dmpDAO.getAllMyAssigedDmps(userId);

			// List<DMPToolUser> dmpToolUsers = dmpDAO.findAssigedDmps(userId);
			for (DMPToolUser dmpToolUser : dmpToolUsers) {
				results.add(dmpToolUser.getDmp());
			}
			List<DMP> createdDmps = dmpDAO.getAllMyCreatedDmps(userId);

			// List<DMP> createdDmps= dmpDAO.findCreatedDmps(userId);
			for (DMP dmp : createdDmps) {
				results.add(dmp);
			}
			return new ArrayList<DMP>(results);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	public DMP findDMPById(String id) throws ServiceException {
		try {
			DMP result = dmpDAO.findDMPById(id);
			return result;
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	@Override
	public DMP getDMP(EntityKey<DMP> entityKey) throws ServiceException {
		DMP result = new DMP();
		try {
			result = getDmpDAO().getByKey(entityKey);
			this.setDMPReviewers(result);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
		return result;

	}

	public DMPResponse getDMPResponse(EntityKey<DMPResponse> entityKey)
			throws ServiceException {
		DMPResponse result = new DMPResponse();
		try {
			result = getDmpDAO().getByKey(entityKey);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
		return result;

	}

	public DMPQuestion getDMPQuestion(EntityKey<DMPQuestion> entityKey)
			throws ServiceException {
		DMPQuestion result = new DMPQuestion();
		try {
			result = getDmpDAO().getByKey(entityKey);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
		return result;

	}

	public List<DMPToolUser> findDMPToolUsers(DMP dmp) throws ServiceException {
		List<DMPToolUser> result = new ArrayList<DMPToolUser>();
		try {
			result = getDmpDAO().findDMPToolUsers(dmp);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
		return result;
	}

	public List<DMPToolUser> findDMPToolUsers(String dmpId)
			throws ServiceException {
		List<DMPToolUser> result = new ArrayList<DMPToolUser>();
		try {
			result = getDmpDAO().findDMPToolUsers(dmpId);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
		return result;

	}

	public User findUserById(String userId) throws ServiceException {
		User user;
		try {
			user = getDmpDAO().findUserById(userId);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
		return user;

	}

	@Override
	public List<DMP> searchDMP(DMP dmp) throws ServiceException {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void updateDMP(DMP dmp) throws ServiceException {
		// TODO Auto-generated method stub

	}

	public SecurityService getSecurityService() {
		return securityService;
	}

	public void setSecurityService(SecurityService securityService) {
		this.securityService = securityService;
	}

	public User getUser(String userName) throws ServiceException {
		return securityService.getUser(userName);
	}

	public SecurityDAO getSecurityDAO() {
		return securityDAO;
	}

	public void setSecurityDAO(SecurityDAO securityDAO) {
		this.securityDAO = securityDAO;
	}

	public DMPExport createDmpExportContent(String id) throws ServiceException {

		try {
			DMPExport exportObject = getDmpDAO().exportDmp(id);

			logger.info(" Returning " + exportObject.dmpComponentList.size()
					+ " items. ");

			return exportObject;
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	public DMPExport getDmpExport() {
		return dmpExport;
	}

	public void setDmpExport(DMPExport dmpExport) {
		this.dmpExport = dmpExport;
	}

	public List<DMPToolUser> findAllDMPToolUsers() throws ServiceException {
		List<DMPToolUser> result = new ArrayList<DMPToolUser>();
		try {
			result = getDmpDAO().findAllDMPToolUsers();
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
		return result;

	}

	public List<DMPToolUser> findDmpFacilitators() throws ServiceException {
		try {
			return dmpDAO.findDmpFacilitators();
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	public List<DMPSearch> getAllDmps() throws ServiceException {
		try {
			return dmpDAO.getAllDmps();
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	public List<DMPStandLibEntry> getAllStandardLibs() throws ServiceException {
		try {
			return dmpDAO.getAllStandardLibs();
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	public List<DMPSearch> searchAllDmps(DMPSearchParameters dmpSearchParameters)
			throws ServiceException {
		try {
			logger.debug("******:  dmp service calling dmpDAO.searchDMPAll");
			return dmpDAO.searchAllDmps(dmpSearchParameters);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	public DMPFindReplaceCriteria findTermInDMP(DMPFindReplaceCriteria criteria)
			throws ServiceException {
		try {
			logger.debug("******:  dmp service calling dmpDAO.findTermInDMP");
			List<DMPFindResults> results = new ArrayList<DMPFindResults>();
			List<DMPFindResults> dmpAttrubuteResults = new ArrayList<DMPFindResults>();
			if (criteria.getDmpAttributeLocation()) {
				dmpAttrubuteResults = dmpDAO.findTermInDMPAttributes(criteria);
				if (dmpAttrubuteResults.size() > 0) {
					results.addAll(dmpAttrubuteResults);
				}
			}
			if (criteria.getDmpContentLocation()) {
				dmpAttrubuteResults = dmpDAO.findTermInDMPContent(criteria);
				if (dmpAttrubuteResults.size() > 0) {
					results.addAll(dmpAttrubuteResults);
				}
			}
			if (criteria.getDmpResponseLocation()) {
				dmpAttrubuteResults = dmpDAO.findTermInDMPResponses(criteria);
				if (dmpAttrubuteResults.size() > 0) {
					results.addAll(dmpAttrubuteResults);
				}
			}
			criteria.setResults(results);
			return criteria;
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}

	}

	public DMPFindReplaceCriteria updateDMPwithReplaceTerm(
			DMPFindReplaceCriteria criteria) throws ServiceException {
		try {
			logger
					.debug("******:  dmp service calling dmpDAO.replaceTermInDMP");
			List<DMPFindResults> dmpReplacedAttributeResults = new ArrayList<DMPFindResults>();
			List<DMPFindResults> dmpReplaceCandidateList = criteria
					.getResults();
			for (DMPFindResults aDmpFindResult : dmpReplaceCandidateList) {
				if (aDmpFindResult.getReplace()) {
					if (aDmpFindResult.getFindLocation().equalsIgnoreCase(
							"DMP Name")) {
						DMP aDMP = dmpDAO.findDMPById(aDmpFindResult.getId().toString());
						if (aDMP != null) {
							String contents = aDmpFindResult.getContents();
							contents = contents.replaceAll("(?i)"
									+ criteria.getFindTerm(), criteria
									.getReplaceTerm());
							aDMP.setName(contents);
						}
						aDMP = dmpDAO.saveDMP(aDMP);
						DMPFindResults aReplacedResult = new DMPFindResults();
						aReplacedResult.setDmpName(aDMP.getName());
						aReplacedResult.setDmpTag(aDMP.getTag());
						aReplacedResult.setFindLocation("DMP Name");
						aReplacedResult.setDmpFacilitator(aDmpFindResult
								.getDmpFacilitator());
						aReplacedResult.setLocked("No");
						aReplacedResult.setContents(aDMP.getName());
						dmpReplacedAttributeResults.add(aReplacedResult);
					}
					if (aDmpFindResult.getFindLocation().equalsIgnoreCase(
							"DMP Tag")) {
						DMP aDMP = dmpDAO.findDMPById(aDmpFindResult.getId()
								.toString());
						if (aDMP != null) {
							String contents = aDmpFindResult.getContents();
							contents = contents.replaceAll("(?i)"
									+ criteria.getFindTerm(), criteria
									.getReplaceTerm());
							aDMP.setTag(contents);
						}
						aDMP = dmpDAO.saveDMP(aDMP);
						DMPFindResults aReplacedResult = new DMPFindResults();
						aReplacedResult.setDmpName(aDMP.getName());
						aReplacedResult.setDmpTag(aDMP.getTag());
						aReplacedResult.setFindLocation("DMP Tag");
						aReplacedResult.setDmpFacilitator(aDmpFindResult
								.getDmpFacilitator());
						aReplacedResult.setLocked("No");
						aReplacedResult.setContents(aDMP.getTag());
						dmpReplacedAttributeResults.add(aReplacedResult);
					}
					if (aDmpFindResult.getFindLocation().equalsIgnoreCase(
							"DMP Description")) {
						DMP aDMP = dmpDAO.findDMPById(aDmpFindResult.getId()
								.toString());
						if (aDMP != null) {
							String contents = aDmpFindResult.getContents();
							contents = contents.replaceAll("(?i)"
									+ criteria.getFindTerm(), criteria
									.getReplaceTerm());
							aDMP.setDescription(contents);
						}
						aDMP = dmpDAO.saveDMP(aDMP);
						DMPFindResults aReplacedResult = new DMPFindResults();
						aReplacedResult.setDmpName(aDMP.getName());
						aReplacedResult.setDmpTag(aDMP.getTag());
						aReplacedResult.setFindLocation("DMP Description");
						aReplacedResult.setDmpFacilitator(aDmpFindResult
								.getDmpFacilitator());
						aReplacedResult.setLocked("No");
						aReplacedResult.setContents(aDMP.getDescription());
						dmpReplacedAttributeResults.add(aReplacedResult);
					}
					if (aDmpFindResult.getFindLocation().equalsIgnoreCase(
							"DMP Objective")) {
						DMP aDMP = dmpDAO.findDMPById(aDmpFindResult.getId()
								.toString());
						if (aDMP != null) {
							String contents = aDmpFindResult.getContents();
							contents = contents.replaceAll("(?i)"
									+ criteria.getFindTerm(), criteria
									.getReplaceTerm());
							aDMP.setObjective(contents);
						}
						aDMP = dmpDAO.saveDMP(aDMP);
						DMPFindResults aReplacedResult = new DMPFindResults();
						aReplacedResult.setDmpName(aDMP.getName());
						aReplacedResult.setDmpTag(aDMP.getTag());
						aReplacedResult.setFindLocation("DMP Objective");
						aReplacedResult.setDmpFacilitator(aDmpFindResult
								.getDmpFacilitator());
						aReplacedResult.setLocked("No");
						aReplacedResult.setContents(aDMP.getObjective());
						dmpReplacedAttributeResults.add(aReplacedResult);
					}
					if (aDmpFindResult.getFindLocation().equalsIgnoreCase(
							"DMP Content")) {
						EntityKey<DMPQuestion> entityKey = EntityKeyFactory
								.createEntityKey(aDmpFindResult.getId(),
										DMPQuestion.class);
						DMPQuestion aQuestion = getDMPQuestion(entityKey);

						if (aQuestion != null) {
							String contents = aDmpFindResult.getContents();
							contents = contents.replaceAll("(?i)"
									+ criteria.getFindTerm(), criteria
									.getReplaceTerm());
							aQuestion.setQuestionContent(contents);
						}
						aQuestion = dmpDAO.saveDMPQuestion(aQuestion);
						DMPFindResults aReplacedResult = new DMPFindResults();
						aReplacedResult
								.setDmpName(aQuestion.getDmp().getName());
						aReplacedResult.setDmpTag(aQuestion.getDmp().getTag());
						aReplacedResult.setFindLocation("DMP Content");
						aReplacedResult.setDmpFacilitator(aDmpFindResult
								.getDmpFacilitator());
						if (aQuestion.getLocked()) {
							aReplacedResult.setLocked("Yes");
						} else {
							aReplacedResult.setLocked("No");
						}
						aReplacedResult.setContents(aQuestion
								.getQuestionContent());
						dmpReplacedAttributeResults.add(aReplacedResult);
					}
					if (aDmpFindResult.getFindLocation().equalsIgnoreCase(
							"DMP Response Content")) {
						EntityKey<DMPResponse> entityKey = EntityKeyFactory
								.createEntityKey(aDmpFindResult.getId(),
										DMPResponse.class);
						DMPResponse aResponse = getDMPResponse(entityKey);

						if (aResponse != null) {
							String contents = aDmpFindResult.getContents();
							contents = contents.replaceAll("(?i)"
									+ criteria.getFindTerm(), criteria
									.getReplaceTerm());
							aResponse.setResponseContent(contents);
						}
						aResponse = dmpDAO.saveDMPResponse(aResponse);
						DMPFindResults aReplacedResult = new DMPFindResults();
						aReplacedResult.setDmpName(aResponse.getQuestion()
								.getDmp().getName());
						aReplacedResult.setDmpTag(aResponse.getQuestion()
								.getDmp().getTag());
						aReplacedResult.setFindLocation("DMP Response Content");
						aReplacedResult.setDmpFacilitator(aDmpFindResult
								.getDmpFacilitator());
						if (aResponse.getQuestion().getLocked()) {
							aReplacedResult.setLocked("Yes");
						} else {
							aReplacedResult.setLocked("No");
						}
						aReplacedResult.setContents(aResponse
								.getResponseContent());
						dmpReplacedAttributeResults.add(aReplacedResult);
					}
					if (aDmpFindResult.getFindLocation().equalsIgnoreCase(
							"DMP Response Educational Content")) {
						EntityKey<DMPResponse> entityKey = EntityKeyFactory
								.createEntityKey(aDmpFindResult.getId(),
										DMPResponse.class);
						DMPResponse aResponse = getDMPResponse(entityKey);

						if (aResponse != null) {
							String contents = aDmpFindResult.getContents();
							contents = contents.replaceAll("(?i)"
									+ criteria.getFindTerm(), criteria
									.getReplaceTerm());
							aResponse.setEduContent(contents);
						}
						aResponse = dmpDAO.saveDMPResponse(aResponse);
						DMPFindResults aReplacedResult = new DMPFindResults();
						aReplacedResult.setDmpName(aResponse.getQuestion()
								.getDmp().getName());
						aReplacedResult.setDmpTag(aResponse.getQuestion()
								.getDmp().getTag());
						aReplacedResult
								.setFindLocation("DMP Response Educational Content");
						aReplacedResult.setDmpFacilitator(aDmpFindResult
								.getDmpFacilitator());
						if (aResponse.getQuestion().getLocked()) {
							aReplacedResult.setLocked("Yes");
						} else {
							aReplacedResult.setLocked("No");
						}
						aReplacedResult.setContents(aResponse.getEduContent());
						dmpReplacedAttributeResults.add(aReplacedResult);
					}
					if (aDmpFindResult.getFindLocation().equalsIgnoreCase(
							"DMP Response Vendor Instruction")) {
						EntityKey<DMPResponse> entityKey = EntityKeyFactory
								.createEntityKey(aDmpFindResult.getId(),
										DMPResponse.class);
						DMPResponse aResponse = getDMPResponse(entityKey);

						if (aResponse != null) {
							String contents = aDmpFindResult.getContents();
							contents = contents.replaceAll("(?i)"
									+ criteria.getFindTerm(), criteria
									.getReplaceTerm());
							aResponse.setVendorInstrContent(contents);
						}
						aResponse = dmpDAO.saveDMPResponse(aResponse);
						DMPFindResults aReplacedResult = new DMPFindResults();
						aReplacedResult.setDmpName(aResponse.getQuestion()
								.getDmp().getName());
						aReplacedResult.setDmpTag(aResponse.getQuestion()
								.getDmp().getTag());
						aReplacedResult
								.setFindLocation("DMP Response Vendor Instruction");
						aReplacedResult.setDmpFacilitator(aDmpFindResult
								.getDmpFacilitator());
						if (aResponse.getQuestion().getLocked()) {
							aReplacedResult.setLocked("Yes");
						} else {
							aReplacedResult.setLocked("No");
						}
						aReplacedResult.setContents(aResponse
								.getVendorInstrContent());
						dmpReplacedAttributeResults.add(aReplacedResult);
					}
				}
			}
			criteria.setResults(dmpReplacedAttributeResults);
			criteria.setFindTerm("");
			criteria.setHighlightTerm(criteria.getReplaceTerm());
			criteria.setReplaceTerm("");
			criteria.setDmpAttributeLocation(false);
			criteria.setDmpContentLocation(false);
			criteria.setDmpResponseLocation(false);
			return criteria;
		} catch (DAOException e) {
			if (e.getCause() != null
					&& e.getCause().getCause().getCause() instanceof java.sql.SQLException) {
				java.sql.SQLException dEx = (java.sql.SQLException) e
						.getCause().getCause().getCause();
				if (dEx.getMessage().indexOf("truncated") > -1) {
					throw new ServiceException("Column size limit exceeded\n");
				}
			}

			throw new ServiceException(e.getMessage(), e);
		}

	}

	public DMPReview saveDMPReview(DMPReview dmpReview) throws ServiceException {
		try {

			return dmpDAO.saveDMPReview(dmpReview);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}

	public DMPReview deleteDMPReview(DMPReview dmpReview) throws ServiceException {
		try {

			return dmpDAO.deleteDMPReview(dmpReview);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
	}
	
	public void sendVendorMail(DMP deployedDMP, String vendorName, byte[] byteme, String name)
			throws ServiceException {
		// verify the existence of email addresses
		//BufferedImage chartImage = null;
		try {

		Vendor vendor = getInventoryDAO().getVendor(vendorName);
		if (vendor.getEmail_to().length() == 0) {
			return;
		}
		//Date replyDate = DateUtils.forwardBusinessDays(new Date(System.currentTimeMillis()), 20);
		//DateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
		//String replyDateString = formatter.format(replyDate);

		Map<String, Object> data = new HashMap<String, Object>();
		data.put("Deploy to vendor", "Deploy to Vendor");
		data.put("dmp", deployedDMP);
		//data.put("replyDate", replyDateString);
		SimpleMailMessage template = processMailTemplate(data, dmpDeployToVendorMailMessage);
		String[] vendorEmailAddresses = vendor.getEmail_to().split(",");
		if (vendorEmailAddresses.length<1 && vendor.getEmail_to().length()>0)
		{
			vendorEmailAddresses = new String [1];
			vendorEmailAddresses[0]=vendor.getEmail_to();
		}

		template.setTo(vendorEmailAddresses);
		//template.setFrom("donotReply@ihta");
		//template.setSubject("DMP Review");
		
		if(deployedDMP.getDmpStatusTermType().getLabel().equalsIgnoreCase("Nationally Released"))
		{
			template.setText(" ");
		}
		
		//template.setText(merge(template.getText(), data));
		Map<String, Object> attachments = new HashMap<String, Object>();
		attachments.put(name + ".xls",
				byteme);
		send(template, attachments);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}

	}

	public InventoryDAO getInventoryDAO() {
		return inventoryDAO;
	}

	public void setInventoryDAO(InventoryDAO inventoryDAO) {
		this.inventoryDAO = inventoryDAO;
	}

	public SimpleMailMessage getDmpDeployToVendorMailMessage() {
		return dmpDeployToVendorMailMessage;
	}

	public void setDmpDeployToVendorMailMessage(
			SimpleMailMessage dmpDeployToVendorMailMessage) {
		this.dmpDeployToVendorMailMessage = dmpDeployToVendorMailMessage;
	}
	public Boolean checkIfAlreadyDeployedToVendor(DMP deployedDMP, String vendorName) throws ServiceException
	{
		try {

		Vendor vendor = inventoryDAO.getVendor(vendorName);
		DMPVendorDeployment dmpVendorDeployment = dmpDAO.findDMPVendorDeployment(deployedDMP, vendor);
		if(dmpVendorDeployment!=null)
		{
		  return true;
		}
		else
		{
			return false;
		}
		}
		catch( DAOException e ) {
			throw new ServiceException(e.getMessage(), e);
		}
	}
	public List<DMPReview> getDMPQuestionComments(String dmpId, String dmpContentId) throws ServiceException
	{
		try {

			return dmpDAO.getDMPQuestionComments(dmpId, dmpContentId);
		}
		catch( DAOException e ) {
			throw new ServiceException(e.getMessage(), e);
		}
		
	}
	
	public List<DMPToolUser> findDMPReviewers(String dmpId) throws ServiceException {
		List<DMPToolUser> result = new ArrayList<DMPToolUser>();
		try {
			result = getDmpDAO().findDMPReviewers(dmpId);
		} catch (DAOException e) {
			throw new ServiceException(e.getMessage(), e);
		}
		return result;
	}
	
	public void updateDmpQuestionsLockStatus(List<Long> questionIds, Integer lockDmpContent) throws ServiceException
	{
		try 
		{
			getDmpDAO().updateDmpQuestionsLockStatus(questionIds, lockDmpContent);
		} 
		catch (DAOException e) 
		{
			throw new ServiceException(e.getMessage(), e);
		}
		
	}
	//build reviewer set in dmp
	private void setDMPReviewers(DMP dmp) {
		if (dmp != null) {
			HashSet reviewers = new HashSet();
			if (dmp.getAssignees().size() > 0) {
				for (DMPToolUser dmpToolUser : new ArrayList<DMPToolUser>(dmp.getAssignees())) {
					if (dmpToolUser.isReviewer()) {
						reviewers.add(dmpToolUser);
					}
				}
				dmp.setReviewers(reviewers);
			}
		}
	}
}
