package gov.va.med.ccht.service.dmp;

import java.util.Collection;
import java.util.List;

import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.dmp.DMP;
import gov.va.med.ccht.model.dmp.DMPFindReplaceCriteria;
import gov.va.med.ccht.model.dmp.DMPQuestion;
import gov.va.med.ccht.model.dmp.DMPResponse;
import gov.va.med.ccht.model.dmp.DMPReview;
import gov.va.med.ccht.model.dmp.DMPSearch;
import gov.va.med.ccht.model.dmp.DMPSearchParameters;
import gov.va.med.ccht.model.dmp.DMPStandLibEntry;
import gov.va.med.ccht.model.dmp.DMPToolUser;
import gov.va.med.ccht.model.dmp.DMPVendorDeployment;
import gov.va.med.ccht.model.inventory.Vendor;
import gov.va.med.ccht.model.qir.QIR;
import gov.va.med.ccht.model.qir.QIRSearchParameters;
import gov.va.med.ccht.persistent.InventoryDAO;
import gov.va.med.ccht.util.DMPExport;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;

public interface DMPService {
	public DMP saveDMP(DMP dmp) throws ServiceException;
	public void updateDMP(DMP dmp) throws ServiceException;
	public List<DMP> searchDMP(DMP dmp)	throws ServiceException;
	public DMP getDMP(EntityKey<DMP> entityKey) throws ServiceException;
	public List<DMP> findAllDmps() throws ServiceException;
	public User getUser(String userName) throws ServiceException;
	public DMPToolUser saveDMPToolUser(DMPToolUser assignee) throws ServiceException;
	public DMPToolUser saveDMPToolUser(DMPToolUser assignee, boolean isAssignDMP) throws ServiceException;
	public User getUserByLoginId(String username) throws ServiceException;
	public DMP findDMPById(String id) throws ServiceException;
	public List<DMPToolUser> findDMPToolUsers(DMP dmp) throws ServiceException;
	public List<DMPToolUser> findDMPToolUsers(String dmpId) throws ServiceException;
	public User findUserById(String userId) throws ServiceException;
	public void deleteDMPToolUser(EntityKey<Object> identifier) throws ServiceException;
	public List<DMP> findAssigedDmps(String userId) throws ServiceException;
	public void deleteDMPQuestion(EntityKey<Object> identifier) throws ServiceException;
	public DMPQuestion saveDMPQuestion(DMPQuestion question) throws ServiceException;
	public List<DMP> findAdminViewMyDmps(String userId) throws ServiceException;
	//public DMP findQuestionById(String id) throws ServiceException;
	public DMPQuestion getDMPQuestion(EntityKey<DMPQuestion> entityKey) throws ServiceException;
	public DMPResponse saveDMPResponse(DMPResponse response) throws ServiceException;
	public DMPResponse getDMPResponse(EntityKey<DMPResponse> entityKey) throws ServiceException;
	public void deleteDMPResponse(EntityKey<Object> identifier) throws ServiceException;
	public DMPExport createDmpExportContent(String id) throws ServiceException;
	public void deleteDMPResponses(Collection<DMPResponse> responses) throws ServiceException;
	public List<DMPToolUser> findDmpFacilitators() throws ServiceException;
	public List<DMPToolUser> findAllDMPToolUsers() throws ServiceException;
	public List<DMPSearch> getAllDmps() throws ServiceException;
	public List<DMPSearch> searchAllDmps(DMPSearchParameters dmpSearchParameters) throws ServiceException;
	public DMPFindReplaceCriteria findTermInDMP(DMPFindReplaceCriteria criteria) throws ServiceException;
	public DMPFindReplaceCriteria updateDMPwithReplaceTerm(DMPFindReplaceCriteria criteria) throws ServiceException;
	public DMPStandLibEntry saveDMPStandLibEntry(DMPStandLibEntry dmpStandLibEntry) throws ServiceException;
	public Boolean isDmpStandLibEntryDuplicate(DMPStandLibEntry dmpStandLibEntry) throws ServiceException;
	public List<DMPStandLibEntry> getAllStandardLibs() throws ServiceException;
	public DMPStandLibEntry findDMPStanLibEntryById(Long id) throws ServiceException;
	public DMPReview saveDMPReview(DMPReview dmpReview) throws ServiceException;
	public DMPReview deleteDMPReview(DMPReview dmpReview) throws ServiceException;
	public void sendVendorMail(DMP deployedDMP, String vendorName, byte[] byteme, String name) throws ServiceException;
	public Boolean checkIfAlreadyDeployedToVendor(DMP deployedDMP, String vendor) throws ServiceException;
	public List<DMPReview> getDMPQuestionComments(String dmpId, String dmpContentId) throws ServiceException;
	public InventoryDAO getInventoryDAO() throws ServiceException;
	public DMPVendorDeployment saveDMPVendorDeployment(DMPVendorDeployment dmpVendorDeployment) throws ServiceException;
	public List<DMPToolUser> findDMPReviewers(String dmpId) throws ServiceException;
	public void updateDmpQuestionsLockStatus(List<Long> questionIds, Integer lockDmpContent) throws ServiceException;
	
}
