/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.service.common.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.LogFactory;

import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.StopWatchLogger;

import gov.va.med.ccht.persistent.TerminologyDAO;
import gov.va.med.ccht.service.common.TerminologyException;
import gov.va.med.ccht.service.common.TerminologyService;

/**
 * IHTA IHTA_common Jun 26, 2010
 * 
 * @author VHAISWBOHMEG
 */
public class TerminologyServiceImpl extends AbstractComponent implements TerminologyService {

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.IHTA.service.common.TerminologyService#findAll(java.lang.Class
	 * )
	 */
	@SuppressWarnings("unchecked")
	public List findAll(String terminologyType) throws TerminologyException {
		/*
		 * First check to see if we are requesting an enum class that also
		 * implements Lookup - CPB
		 */
		Class<?> clazz;
		try {
			clazz = Class.forName(terminologyType);
			if (clazz.isEnum() && Lookup.class.isAssignableFrom(clazz))
				return Arrays.asList(clazz.getEnumConstants());
		} catch (ClassNotFoundException ignored) {
		}

		/* Otherwise, return values from the database */
		try {
			return terminologyDAO.findAll(terminologyType);
		} catch (Exception ex) {
			throw new TerminologyException("Error while looking up " + terminologyType, ex);
		}
	}

	public <T extends Lookup> List<T> findAll(Class<T> terminologyType) throws TerminologyException {
		/*
		 * First check to see if we are requesting an enum class that also
		 * implements Lookup - CPB
		 */
		if (terminologyType.isEnum() && Lookup.class.isAssignableFrom(terminologyType))
			return (List<T>) Arrays.asList(terminologyType.getEnumConstants());

		try {
			return terminologyDAO.findAll(terminologyType);
		} catch (Exception ex) {
			throw new TerminologyException("Error while looking up " + terminologyType, ex);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.IHTA.service.common.TerminologyService#findAll(java.lang.Class
	 * )
	 */
	public <T extends Lookup> List<T> findAllActive(Class<T> terminologyType)
			throws TerminologyException {
		/*
		 * First check to see if we are requesting an enum class that also
		 * implements Lookup - CPB
		 */
		if (terminologyType.isEnum() && Lookup.class.isAssignableFrom(terminologyType))
			return (List<T>) Arrays.asList(terminologyType.getEnumConstants());

		try {
			return terminologyDAO.findAllActive(terminologyType);
		} catch (Exception ex) {
			throw new TerminologyException("Error while looking up " + terminologyType.getName(),
					ex);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.IHTA.service.common.TerminologyService#getByCode(java.lang
	 * .Class, java.lang.String)
	 */
	public Lookup getByCode(String terminologyType, String code) throws TerminologyException {
		try {
			StopWatchLogger timer = new StopWatchLogger("TerminologyServiceImpl.getByCode for : "
					+ terminologyType + " " + code);
			timer.start();
			Lookup result = null;

			/*
			 * First check to see if we are requesting an enum class that also
			 * implements Lookup - CPB
			 */
			Class<?> clazz = null;

			try {
				clazz = Class.forName(terminologyType);
			} catch (ClassNotFoundException ignored) {
			}

			if (clazz != null && clazz.isEnum() && Lookup.class.isAssignableFrom(clazz)) {
				for (Object o : clazz.getEnumConstants()) {
					Lookup l = (Lookup) o;

					if (l.getCode().equals(code)) {
						result = l;
						break;
					}
				}
			} else {
				result = terminologyDAO.getByCode(terminologyType, code);
			}

			timer.stopAndLog("done", LogFactory.getLog(StopWatchLogger.class));
			return result;
		} catch (Exception ex) {
			throw new TerminologyException("Error while looking up " + terminologyType
					+ " for code = " + code, ex);
		}
	}

	public <T extends Lookup> Map<String, T> getByCodes(Class<T> terminologyType,
			Collection<String> codes) throws TerminologyException {
		Map<String, T> results = new HashMap<String, T>();
		if (terminologyType.isEnum() && Lookup.class.isAssignableFrom(terminologyType)) {
			for (T l : terminologyType.getEnumConstants()) {
				if (codes.contains(l.getCode()))
					results.put(l.getCode(), l);
			}
		} else {
			List<T> resultList = terminologyDAO.getByCodes(terminologyType, codes);
			for (T e : resultList)
				if (codes.contains(e.getCode()))
					results.put(e.getCode(), e);
		}

		return results;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.IHTA.service.common.TerminologyService#getByCode(java.lang
	 * .Class, java.lang.String)
	 */
	public <T extends Lookup> T getByCode(Class<T> terminologyType, String code)
			throws TerminologyException {
		try {
			StopWatchLogger timer = new StopWatchLogger("TerminologyServiceImpl.getByCode for : "
					+ terminologyType + " " + code);
			timer.start();
			T result = null;

			if (terminologyType.isEnum() && Lookup.class.isAssignableFrom(terminologyType)) {
				for (T l : terminologyType.getEnumConstants()) {
					if (l.getCode().equals(code)) {
						result = l;
						break;
					}
				}
			} else {
				result = terminologyDAO.getByCode(terminologyType, code);
			}

			timer.stopAndLog("done", LogFactory.getLog(StopWatchLogger.class));
			return result;
		} catch (Exception ex) {
			throw new TerminologyException("Error while looking up " + terminologyType.getName()
					+ " for code = " + code, ex);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.IHTA.service.common.TerminologyService#getByName(java.lang
	 * .Class, java.lang.String)
	 */
	public <T extends Lookup> T getByName(Class<T> terminologyType, String name)
			throws TerminologyException {
		try {
			T result = null;

			if (terminologyType.isEnum() && Lookup.class.isAssignableFrom(terminologyType)) {
				for (T l : terminologyType.getEnumConstants()) {
					if (l.getName().equals(name)) {
						result = l;
						break;
					}
				}
			} else {
				result = terminologyDAO.getByName(terminologyType, name);
			}

			return result;
		} catch (Exception ex) {
			throw new TerminologyException("Error while looking up " + terminologyType.getName()
					+ " for code = " + name, ex);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.IHTA.service.common.TerminologyService#getByName(java.lang
	 * .String, java.lang.String)
	 */
	public Lookup getByName(String terminologyType, String name) throws TerminologyException {
		try {
			Lookup result = null;

			/*
			 * First check to see if we are requesting an enum class that also
			 * implements Lookup - CPB
			 */
			Class<?> clazz = null;

			try {
				clazz = Class.forName(terminologyType);
			} catch (ClassNotFoundException ignored) {
			}

			if (clazz != null && clazz.isEnum() && Lookup.class.isAssignableFrom(clazz)) {
				for (Object o : clazz.getEnumConstants()) {
					Lookup l = (Lookup) o;

					if (l.getName().equals(name)) {
						result = l;
						break;
					}
				}
			} else {
				result = terminologyDAO.getByName(terminologyType, name);
			}

			return result;
		} catch (Exception ex) {
			throw new TerminologyException("Error while looking up " + terminologyType
					+ " for code = " + name, ex);
		}
	}

	public <T extends Lookup> T getById(Class<T> terminologyType, Long id)
			throws TerminologyException {
		try {
			return terminologyDAO.getById(terminologyType, id);
		} catch (Exception e) {
			throw new TerminologyException("Error while looking up " + terminologyType
					+ " for id = " + id, e);
		}
	}

	public Lookup getById(String terminologyType, Long id) throws TerminologyException {
		try {
			return terminologyDAO.getById(terminologyType, id);
		} catch (Exception e) {
			throw new TerminologyException("Error while looking up " + terminologyType
					+ " for id = " + id, e);
		}
	}
	public List<? extends Lookup> searchTerms(String terminologyType, String searchCriteria) throws TerminologyException
	{
		try {
			return terminologyDAO.searchTerms(terminologyType, searchCriteria);
		} catch (Exception e) {
			throw new TerminologyException("Error while looking up " + terminologyType
					+ " for name like = " + searchCriteria, e);
		}
	}
	public void save(AbstractLookup lookup) throws TerminologyException {
		try {
			terminologyDAO.save(lookup);
		} catch (Exception e) {
			throw new TerminologyException("Error while saving reference data",e);
		}

	}

	private TerminologyDAO terminologyDAO;

	public TerminologyDAO getTerminologyDAO() {
		return terminologyDAO;
	}

	public void setTerminologyDAO(TerminologyDAO terminologyDAO) {
		this.terminologyDAO = terminologyDAO;
	}

}
