/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.service.common.impl;

import java.util.List;
import org.apache.commons.lang.Validate;
import gov.va.med.fw.conversion.CopyService;
import gov.va.med.fw.rule.Match;
import gov.va.med.fw.rule.MatchRuleService;
import gov.va.med.fw.security.Role;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.ccht.model.AppUserGroup;
import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.UserPreference;
import gov.va.med.ccht.model.UserRole;
import gov.va.med.ccht.model.inventory.DeviceDetail;
import gov.va.med.ccht.model.inventory.DeviceStatus;
import gov.va.med.ccht.model.qir.QIR;
import gov.va.med.ccht.model.qir.QIRSimpleAttachment;
import gov.va.med.ccht.model.qir.QIRRemarks;
import gov.va.med.ccht.model.qir.QIRVendorAction;
import gov.va.med.ccht.service.common.MergeService;

/**
 * @author vhaisakatikm
 * 
 */
@SuppressWarnings("deprecation")
public class MergeServiceImpl extends AbstractComponent implements MergeService {

	private static final long serialVersionUID = 0302060928847324634L;
	private CopyService copyService = null;
	private MatchRuleService matchRuleService = null;

	@Override
	public QIR mergeQIR(QIR incoming, QIR onFile) throws ServiceException {
		// copy editable properties
		onFile.setQirType(incoming.getQirType());
		onFile.setQirStatusType(incoming.getQirStatusType());			
		onFile.setVisn(incoming.getVisn());
		onFile.setFacility(incoming.getFacility());			
		onFile.setDeviceType(incoming.getDeviceType());
		onFile.setVendor(incoming.getVendor());			
		onFile.setSerialNumber(incoming.getSerialNumber());
		onFile.setPurchaseOrderNumber(incoming.getPurchaseOrderNumber());
		onFile.setSubmittedDate(incoming.getSubmittedDate());
		onFile.setVendorResponseDueDate(incoming.getVendorResponseDueDate());
		onFile.setEmailReminderSentDate(incoming.getEmailReminderSentDate());
		onFile.setStatusChangeDate(incoming.getStatusChangeDate());
		onFile.setComplaint(incoming.getComplaint());
		onFile.setHeadline(incoming.getHeadline());
		onFile.setSubmittedBy(incoming.getSubmittedBy());
		onFile.setIsDmpIssue(incoming.getIsDmpIssue());
		onFile.setDmpQirType(incoming.getDmpQirType());
		//copy internal sets
		mergeQIRRemarks(incoming, onFile);
		mergeQIRVendorActions(incoming, onFile);
		mergeQIRAttachments(incoming, onFile);
		return null;
	}
	
	public DeviceDetail mergeDeviceDetail(DeviceDetail incoming, DeviceDetail onFile) throws ServiceException {
		//copyService.copy(incoming, onFile); only editable properties are merged
		onFile.setPurchaseOrderNumber(incoming.getPurchaseOrderNumber());
		onFile.setEeNumber(incoming.getEeNumber());
		onFile.setDateOfPurchase(incoming.getDateOfPurchase());
		onFile.setWarrantyFromDate(incoming.getWarrantyFromDate());
		onFile.setWarrantyToDate(incoming.getWarrantyToDate());
		onFile.setMultiPatientUsage(incoming.getMultiPatientUsage());
		mergeDeviceStatuses(incoming, onFile);
		return onFile;
	}
	
	public Role mergeRole(Role incoming, Role onFile) throws ServiceException {
		copyService.copy(incoming, onFile);
		//permissions implemented in Role class 
		//mergePermissions(incoming, onFile)
		return onFile;
	}

	public User mergeUser(User incoming, User onFile) throws ServiceException {
		copyService.copy(incoming, onFile);
		//groups
		mergeUserGroups(incoming, onFile);
		//roles
		mergeRoles(incoming, onFile);
		//preferences
		mergePreferences(incoming, onFile);
		return onFile;
	}

	private void mergeUserGroups(User incoming, User onFile) throws ServiceException {
		List<Match<AppUserGroup>> matchList = getMatchRuleService().match(
				incoming.getUserGroups(), onFile.getUserGroups());
		for (Match<AppUserGroup> match : matchList) {
			if (match.getTarget() == null) {
				onFile.addUserGroup(match.getSource());
			} else if (match.getSource() == null) {
				onFile.removeUserGroup(match.getTarget());
			} else {
				// merge or copy
				//getCopyService().copy(match.getSource(), match.getTarget());
			}
		}
	}
	
	private void mergePreferences(User incoming, User onFile) throws ServiceException {
		List<Match<UserPreference>> matchList = getMatchRuleService().match(
				incoming.getPreferencees(), onFile.getPreferencees());
		for (Match<UserPreference> match : matchList) {
			if (match.getTarget() == null) {
				onFile.addPreference(match.getSource());
			} else if (match.getSource() == null) {
				onFile.removePreference(match.getTarget());
			} else {
				// merge or copy
				match.getTarget().setValue(match.getSource().getValue());
				//getCopyService().copy(match.getSource(), match.getTarget());
			}
		}
	}
	
	private void mergeRoles(User incoming, User onFile) throws ServiceException {
		List<Match<UserRole>> matchList = getMatchRuleService().match(
				incoming.getRoles(), onFile.getRoles());
		for (Match<UserRole> match : matchList) {
			if (match.getTarget() == null) {
				onFile.addRole(match.getSource());
			} else if (match.getSource() == null) {
				logger.debug("Removing role");
				onFile.removeRole(match.getTarget());
			} else {
				// merge or copy
				//getCopyService().copy(match.getSource(), match.getTarget());
			}
		}
	}
	
	public DeviceDetail mergeDeviceStatuses(DeviceDetail incoming, DeviceDetail onFile) throws ServiceException {
		DeviceStatus source = incoming.getDeviceStatus();
		DeviceStatus target = onFile.getDeviceStatus();
		if (source == null || source.getDeviceStatusType() == null) {
			//nothing to do not removing the existing status
		}else {
			if (target == null) {
				target = new DeviceStatus();
				target.setDeviceStatusType(source.getDeviceStatusType());
				target.setStatusChangeDate(source.getStatusChangeDate());
				onFile.setDeviceStatus(target);
			}else {
				target.setDeviceStatusType(source.getDeviceStatusType());
				target.setStatusChangeDate(source.getStatusChangeDate());
			}
		}
		return onFile;
	}
	
	private void mergeQIRRemarks(QIR incoming, QIR onFile) throws ServiceException {		
		for (QIRRemarks remarks:incoming.getRemarks()) {
			if (remarks.getId() == null) {
				onFile.addRemarks(remarks);
			}
		}
	}
	private void mergeQIRVendorActions(QIR incoming, QIR onFile) throws ServiceException {		
		for (QIRVendorAction actions:incoming.getVendorActions()) {
			if (actions.getId() == null) {
				onFile.addVendorActions(actions);
			}
		}
	}
	private void mergeQIRAttachments(QIR incoming, QIR onFile) throws ServiceException {		
		for (QIRSimpleAttachment attachment:incoming.getAttachments()) {
			if (attachment.getId() == null) {
				onFile.addAttachment(attachment);
			}
		}
	}
	
	/**
	 * @return the copyService
	 */
	public CopyService getCopyService() {
		return copyService;
	}

	/**
	 * @param copyService
	 *            the copyService to set
	 */
	public void setCopyService(CopyService copyService) {
		this.copyService = copyService;
	}

	/**
	 * @return the matchRuleService
	 */
	public MatchRuleService getMatchRuleService() {
		return matchRuleService;
	}

	/**
	 * @param matchRuleService
	 *            the matchRuleService to set
	 */
	public void setMatchRuleService(MatchRuleService matchRuleService) {
		this.matchRuleService = matchRuleService;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.fw.service.AbstractComponent#afterPropertiesSet()
	 */
	@Override
	public void afterPropertiesSet() throws Exception {
		super.afterPropertiesSet();
		// validate for required services
		Validate.notNull(copyService, "CopyService required for MergeService");
		Validate.notNull(matchRuleService, "MatchRuleService required for MergeService");
	}


}
