/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.service.common.impl;

import gov.va.med.ccht.service.common.DeployedEnvironment;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.config.EnvironmentParamService;
import gov.va.med.fw.util.VersionInfo;

import java.util.TimeZone;

/**
 * used 
 * @author vhaisakatikm
 */
public class EnvironmentParamServiceImpl extends AbstractComponent implements
		EnvironmentParamService {

	private VersionInfo version = null;
	private TimeZone reportingTimeZone = null;
	private boolean isDataClean = false;
	private String env;
	private String ldapGroupsRoot = null;	

	public VersionInfo getVersion() {
		return version;
	}

	public void setVersion(VersionInfo version) {
		this.version = version;
	}

	public TimeZone getReportingTimeZone() {
		return reportingTimeZone;
	}

	public void setReportingTimeZone(TimeZone reportingTimeZone) {
		this.reportingTimeZone = reportingTimeZone;
	}

	public String getLdapGroupsRoot() {
		return ldapGroupsRoot;
	}

	public void setLdapGroupsRoot(String ldapGroupsRoot) {
		this.ldapGroupsRoot = ldapGroupsRoot;
	}

	public boolean isDataClean() {
		return isDataClean;
	}

	public boolean isDevIntEnv() {
		return DeployedEnvironment.DEVINT.getKey().equalsIgnoreCase(env);
	}

	public boolean isSqaEnv() {
		return DeployedEnvironment.SQA.getKey().equalsIgnoreCase(env);
	}

	public boolean isProdEnv() {
		return DeployedEnvironment.PROD.getKey().equalsIgnoreCase(env);
	}

	public boolean isLocalEnv() {
		return DeployedEnvironment.LOCAL.getKey().equalsIgnoreCase(env);
	}

	public String getDeployedEnvironment() {
		return env;
	}

	public void setIsDataClean(boolean isDataClean) {
		this.isDataClean = isDataClean;
	}

	public void setEnv(String env) {
		this.env = env;
	}

	public void afterPropertiesSet() throws Exception {
		super.afterPropertiesSet();
	}
}
