/**
 * 
 */
package gov.va.med.ccht.service.common.impl;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import javax.imageio.ImageIO;
import javax.mail.internet.MimeMessage;

import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.VelocityException;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.ui.velocity.VelocityEngineUtils;

import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;

import gov.va.med.ccht.model.User;
import gov.va.med.ccht.service.common.MergeService;

/**
 * @author vhaisakatikm
 *
 */
public class AbstractBusinessService extends AbstractComponent {
	
	public static enum Priority {
		HIGH(1), NORMAL(3), LOW(5);
		
		int priority=3;
		
		private Priority (int value) {
			this.priority = value;
		}
		public int getPriority() {
			return this.priority;
		}
	}
	
	public static final String IMAGE_TYPE = "png";
    /**
     * send mail
     * @param template
     */
	public final void send(SimpleMailMessage template) { 
		send(template, null);
	}
    public final void send(SimpleMailMessage template, Map<String,Object> attachments) {
    	this.send(template, attachments, AbstractBusinessService.Priority.NORMAL);
    }
    public final void send(SimpleMailMessage template, Map<String,Object> attachments, AbstractBusinessService.Priority priority) {
    	try {
    		MimeMessage message = javaMailSender.createMimeMessage();

    		// use the false flag to indicate it is not a multi-part message
    		boolean multiPart = (attachments != null && attachments.size() > 0) ? true : false;
    		MimeMessageHelper helper = new MimeMessageHelper(message, multiPart);
    		//When multiple e-mail address are specified by separating them with , in the spring configuration, they are not parsed.
    		List<String> toList = new ArrayList<String>();
    		for (String toAddress:template.getTo()) {
    			if (toAddress.indexOf(",") > 0) {
    				String[] list = toAddress.split(",");
    				for (String address:list) { 
    					toList.add(address);
    				}
    			}
    			else if (toAddress.indexOf(";") > 0){
    				String[] list = toAddress.split(";");
    				for (String address:list) { 
    					toList.add(address);
    				}
    			}
    			else {
    				toList.add(toAddress);
    			}
    		}
    		helper.setTo((String[])toList.toArray(new String[toList.size()]));    		
    		helper.setFrom(template.getFrom());
    		helper.setSubject(template.getSubject());
    		// use the true flag to indicate the text included is HTML
    		helper.setText(template.getText(), true);  

    		// Set priority
    		helper.setPriority( priority.getPriority() );
    		
    		//attach in line resources
    		if (multiPart) {
	    		for (Entry<String,Object> entry:attachments.entrySet()) {
	    			String attachmentName = entry.getKey();
	    			Object obj = entry.getValue();
	    			if (obj instanceof BufferedImage){	    			 
		    			ByteArrayOutputStream os = new ByteArrayOutputStream();
		    			ImageIO.write((BufferedImage)obj, IMAGE_TYPE, os); 			
		    			helper.addAttachment(attachmentName, new ByteArrayResource(os.toByteArray()));		    			
	    			}
	    			//add others as needed (excel, pdf etc)
	    			if(obj instanceof byte[])
	    			{
	    				helper.addAttachment(attachmentName, new ByteArrayResource((byte[]) obj));
	    			}
	    		}	    		
    		}
    		javaMailSender.send(message);
    	}catch (Exception e){
    		//ignore mail delivery errors
    		logger.error("Send Mail Failed", e);
    	}
    }
    /**
     * Process subject and body of mail template
     * @param data
     * @param messageTemplate
     * @return
     */
    public final SimpleMailMessage processMailTemplate(Map<String, Object> data, SimpleMailMessage messageTemplate) throws ServiceException{
    	SimpleMailMessage template = new SimpleMailMessage(messageTemplate);
     	//subject
    	template.setSubject(merge(template.getSubject(),data));
    	//body
    	template.setText(merge(template.getText(),data));
    	return template;
    }
    
    public final String merge(String template, Map<String,Object> data) throws ServiceException {
    	try {
    		return VelocityEngineUtils.mergeTemplateIntoString(velocityTemplateEngine, template, data);
    	}catch (VelocityException ve){
    		throw new ServiceException ("Velocity Template merge failed", ve);
    	}
    }
    
    public final List<String> getEmailList(List<User> users) {
    	List<String> emailList = new ArrayList<String> ();
    	for (User u:users) {
			if (u.isInactive() || StringUtils.isEmpty(u.getEmail())) {
				continue;
			}else {
				emailList.add(u.getEmail());
			}
		}
    	return emailList;
    }
    
	private JavaMailSender javaMailSender; 
	private VelocityEngine velocityTemplateEngine;
	private String webAppUrl;
	private MergeService mergeService = null;
	
	public JavaMailSender getJavaMailSender() {
		return javaMailSender;
	}
	public void setJavaMailSender(JavaMailSender javaMailSender) {
		this.javaMailSender = javaMailSender;
	}
	public VelocityEngine getVelocityTemplateEngine() {
		return velocityTemplateEngine;
	}
	public void setVelocityTemplateEngine(VelocityEngine velocityTemplateEngine) {
		this.velocityTemplateEngine = velocityTemplateEngine;
	}
	public String getWebAppUrl() {
		return webAppUrl;
	}
	public void setWebAppUrl(String webAppUrl) {
		this.webAppUrl = webAppUrl;
	}
	public MergeService getMergeService() {
		return mergeService;
	}
	public void setMergeService(MergeService mergeService) {
		this.mergeService = mergeService;
	}
	public UserPrincipal getCurrentUser() {
		SecurityContext securityContext = SecurityContextHelper.getSecurityContext();
		return securityContext.getUserPrincipal();
	}
}
