/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.service.common;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.model.lookup.Lookup;

/**
 * IHTA IHTA_common Jun 26, 2010
 * 
 * @author VHAISWBOHMEG
 */
public interface TerminologyService {
	/**
	 * Returns all the predefined coding system objects of a particular type.
	 * 
	 * @param terminologyType
	 *            The type of coding system to search for.
	 * @return All the predefined coding system objectsof a particular type.
	 * @throws UnknownTerminologyTypeException
	 *             if the <code>terminologyType</code> is unknown.
	 */
	public List<? extends Lookup> findAll(String terminologyType) throws TerminologyException;

	public <T extends Lookup> List<T> findAll(Class<T> terminologyType) throws TerminologyException;

	public <T extends Lookup> List<T> findAllActive(Class<T> terminologyType)
			throws TerminologyException;

	public Lookup getByCode(String terminologyType, String code) throws TerminologyException;

	/**
	 * Returns a mapping of codes to Lookups. If some code wasn't found, it
	 * won't be present in the returned map.
	 * 
	 * @param <T>
	 * @param terminologyType
	 * @param codes
	 * @return
	 * @throws TerminologyException
	 */
	public <T extends Lookup> Map<String, T> getByCodes(Class<T> terminologyType,
			Collection<String> codes) throws TerminologyException;

	public <T extends Lookup> T getByCode(Class<T> terminologyType, String code)
			throws TerminologyException;

	public Lookup getByName(String terminologyType, String name) throws TerminologyException;

	public <T extends Lookup> T getByName(Class<T> terminologyType, String name)
			throws TerminologyException;

	public Lookup getById(String terminologyType, Long id) throws TerminologyException;

	public <T extends Lookup> T getById(Class<T> terminologyType, Long id)
			throws TerminologyException;

	public List<? extends Lookup> searchTerms(String lookupName, String searchCriteria) throws TerminologyException;
	
	/* typed services below - for convenience */	
	
	public void save(AbstractLookup lookup) throws TerminologyException;
}
