package gov.va.med.ccht.service.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.util.StringUtils;

public class TerminologyCache {

	//private static String LOOKUP_MAP = "LOOKUP_MAP";
	
	Map<String, List<? extends Lookup>> lookupMap = new HashMap<String, List<? extends Lookup>>(); 

	public <T extends Lookup> List<T> getTerms(Class<T> lookupType) throws TerminologyException {
		List<T> lookups = null;
		try {
			if (lookupType != null) {
				lookups = (List<T>) getTermsFromCache(lookupType);
				if (lookups == null) {
					lookups = terminologyService.findAllActive(lookupType);
					setTermsInCache(lookupType.getName(), lookups);
				}
			}
		} catch (Exception ex) {
			throw new TerminologyException("Error in getTerms(lookupName) " + lookupType.getName(),
					ex);
		}
		return lookups;
	}

	public List<? extends Lookup> getTerms(String lookupName) throws TerminologyException {
		List<? extends Lookup> lookups = null;
		try {
			if (StringUtils.isNotEmpty(lookupName)) {
				lookups = getTermsFromCache(lookupName);
				if (lookups == null) {
					lookups = terminologyService.findAll(lookupName);
					setTermsInCache(lookupName, lookups);
				}
			}
		} catch (Exception ex) {
			throw new TerminologyException("Error in getTerms(lookupName) " + lookupName, ex);
		}
		return lookups;
	}

	public List<? extends Lookup> searchTerms(String lookupName, String searchCriteria)
			throws TerminologyException {
		List<? extends Lookup> lookups = null;
		try {
			lookups = terminologyService.searchTerms(lookupName, searchCriteria);
		} catch (Exception ex) {
			throw new TerminologyException("Error in getTerms(lookupName) " + lookupName, ex);
		}
		return lookups;
	}

	public <T extends Lookup> T getTermByCode(Class<T> terminologyType, String code)
			throws TerminologyException {
		return terminologyService.getByCode(terminologyType, code);
	}

	public <T extends Lookup> T getTermByName(Class<T> terminologyType, String name)
			throws TerminologyException {
		return terminologyService.getByName(terminologyType, name);
	}

	public <T extends Lookup> T getTermById(Class<T> terminologyType, Long id)
			throws TerminologyException {
		return terminologyService.getById(terminologyType, id);
	}

	@SuppressWarnings("unchecked")
	private <T extends Lookup> List<T> getTermsFromCache(Class<T> clazz)
			throws TerminologyException {
		return (List<T>) getTermsFromCache(clazz.getName());
	}

	private List<? extends Lookup> getTermsFromCache(String lookupName) throws TerminologyException {
		List<? extends Lookup> lookups = null;
		if (StringUtils.isNotEmpty(lookupName)) {
			lookups = lookupMap.get(lookupName);
		}
		return lookups;
	}

	private void setTermsInCache(String lookupName, List<? extends Lookup> lookups)
			throws TerminologyException {
		if (StringUtils.isNotEmpty(lookupName)) {
			lookupMap.put(lookupName, lookups);
		}
	}
	
	//SU - Do not change signature of this method, it is invoked using reflections in other parts of the app.
	public void clearTermsFromCache(String lookupName)
			throws TerminologyException {
		if (StringUtils.isNotEmpty(lookupName)) {
			if(lookupMap.containsKey(lookupName)) {
					lookupMap.remove(lookupName);
			}		
		}
	}

	private TerminologyService terminologyService;

	public TerminologyService getTerminologyService() {
		return terminologyService;
	}

	public void setTerminologyService(TerminologyService terminologyService) {
		this.terminologyService = terminologyService;
	}
}
