/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.service.common;

import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.terminology.FederalHoliday;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.ldap.LdapPerson;
import gov.va.med.fw.model.ldap.SearchCriteria;
import gov.va.med.fw.security.Application;
import gov.va.med.fw.security.Permission;
import gov.va.med.fw.security.Role;
import gov.va.med.fw.security.SimpleRole;
import gov.va.med.fw.service.ServiceException;

import java.util.List;
import java.util.Set;

/**
 * 
 * Interface for Security Servies required by IHTA
 * 
 * IHTA IHTA_common Jun 24, 2010
 * 
 * @author vhaisakatikm
 */
public interface SecurityService extends gov.va.med.fw.security.SecurityService {
	/**
	 * Get User by Name
	 * 
	 * @param userName
	 * @return
	 * @throws ServiceException
	 */
	public User getUser(String userName) throws ServiceException;

	/**
	 * Get User by Entity Key
	 * 
	 * @param entityKey
	 * @return
	 * @throws ServiceException
	 */
	public User getUser(EntityKey<?> entityKey) throws ServiceException;
	public Role getRole(EntityKey<?> entityKey) throws ServiceException;
	
	public LdapPerson getLdapUser(String samAcountName) throws ServiceException;
	
	public Boolean authenticateLdapUser(String userDn, String password) throws ServiceException;
	
	/**
	 * Create user in IHTA database
	 * 
	 * @param user
	 * @throws ServiceException
	 */
	public void createUser(User user) throws ServiceException;

	/**
	 * update User
	 * 
	 * @param user
	 * @throws ServiceException
	 */
	public void updateUser(User user) throws ServiceException;

	/**
	 * update role
	 * 
	 * @param role
	 * @throws ServiceException
	 */
	public void updateRole(Role role) throws ServiceException;

	/**
	 * Delete a role from LDAP and IHTA Database
	 * 
	 * @param role
	 * @throws ServiceException
	 */
	public void deleteRole(Role role) throws ServiceException;

	/**
	 * Get list of available role names for granting this interface is for
	 * assigning the roles in LDAP which requires common name of roles
	 * 
	 * @throws ServiceException
	 */
	public Set<String> getAvailableRoleNames(Application application) throws ServiceException;

	/**
	 * 
	 * @param applicationName
	 * @return
	 * @throws ServiceException
	 */
	public Set<String> getAvailableRoleNames(String applicationName) throws ServiceException;

	public Set<String> getAvailableRoleNames() throws ServiceException;
	public List<SimpleRole> getAllSimpleRoles() throws ServiceException;

	public List<FederalHoliday> getHolidays(int year) throws ServiceException;
	/**
	 * Get All roles
	 * 
	 * @return
	 * @throws ServiceException
	 */
	public List<Role> getAllRoles(Application application) throws ServiceException;

	/**
	 * 
	 * @param applicationName
	 * @return
	 * @throws ServiceException
	 */
	public List<Role> getAllRoles(String applicationName) throws ServiceException;

	public List<Role> getAllRoles() throws ServiceException;

	/**
	 * Get all permissions for the application
	 * 
	 * @param application
	 * @return
	 * @throws ServiceException
	 */
	public List<Permission> getAllPermissions(Application application) throws ServiceException;

	public List<Permission> getAllPermissions() throws ServiceException;

	/**
	 * 
	 * @param applicationName
	 * @return
	 * @throws ServiceException
	 */
	public List<Permission> getAllPermissions(String applicationName) throws ServiceException;

	public List<User> findAppUsers(SearchCriteria searchCriteria) throws ServiceException;

	public List<String> getUserIds() throws ServiceException;
	
	public int updateUsers(List<String> userIds) throws ServiceException;
	public List<User> getSubmittedRegistrations(Long visnId, Long facilityId) throws ServiceException;
	public List<SimpleRole> getAllDMPRoles() throws ServiceException;
	public List<User> getSubmittedRegistrationsForDmp(Long visnId, Long facilityId) throws ServiceException;
}
