/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.service.common;

import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * IHTA - IHTA_common TODO: add content here
 * 
 * Jul 21, 2010
 * 
 * @author VHAISWBOHMEG
 */
public class ExceptionLogEntry extends AbstractKeyedEntity {

	private static final long serialVersionUID = -555923742648062250L;

	private String applicationName;
	private String severityType;
	private String message;
	private String detail;
	private String detailExt;

	private Throwable exception;
	private Class producerClass;
	private String producerClassName;

	/**
	 * @return the applicationName
	 */
	public String getApplicationName() {
		return applicationName;
	}

	/**
	 * @param applicationName
	 *            the applicationName to set
	 */
	public void setApplicationName(String applicationName) {
		this.applicationName = applicationName;
	}

	/**
	 * @return the severityType
	 */
	public String getSeverityType() {
		return severityType;
	}

	/**
	 * @param severityType
	 *            the severityType to set
	 */
	public void setSeverityType(String severityType) {
		this.severityType = severityType;
	}

	/**
	 * @return the message
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * @param message
	 *            the message to set
	 */
	public void setMessage(String message) {
		this.message = message;
	}

	/**
	 * @return the detail
	 */
	public String getDetail() {
		return detail;
	}

	/**
	 * @param detail
	 *            the detail to set
	 */
	public void setDetail(String detail) {
		this.detail = detail;
	}

	/**
	 * @return the detailExt
	 */
	public String getDetailExt() {
		return detailExt;
	}

	/**
	 * @param detailExt
	 *            the detailExt to set
	 */
	public void setDetailExt(String detailExt) {
		this.detailExt = detailExt;
	}

	/**
	 * @return the exception
	 */
	public Throwable getException() {
		return exception;
	}

	/**
	 * @param exception
	 *            the exception to set
	 */
	public void setException(Throwable exception) {
		this.exception = exception;
	}

	/**
	 * @return the producerClass
	 */
	public Class getProducerClass() {
		return producerClass;
	}

	/**
	 * @param producerClass
	 *            the producerClass to set
	 */
	public void setProducerClass(Class producerClass) {
		this.producerClass = producerClass;
		if (producerClass != null)
			this.producerClassName = producerClass.getName();
	}

	/**
	 * @return the producerClassName
	 */
	public String getProducerClassName() {
		return producerClassName;
	}

	/**
	 * @param producerClassName
	 *            the producerClassName to set
	 */
	public void setProducerClassName(String producerClassName) {
		this.producerClassName = producerClassName;
	}
}
