/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.service.common;

/**
 *  
 * Deployed environments
 */
public enum DeployedEnvironment {
	LOCAL("LOC", "Local"), DEVINT("DEV", "Development Integration"), SQA("SQA", "SQA Testing"), PREPROD(
			"PREPROD", "Pre-Production"), PROD("PROD", "Production"), TRAINING("TRNG", "Training"), STAGING(
			"STG", "Staging"), TROUBLESHOOTING("TRBL", "Troubleshooting"), UAT("UAT",
			"User Acceptance Testing"), IVV("IVV", "Independent Verification and Validation");

	private String key;
	private String description;

	private DeployedEnvironment(String key, String description) {
		this.key = key;
		this.description = description;
	}

	/**
	 * @return the description
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @return the key
	 */
	public String getKey() {
		return key;
	}
}
