package gov.va.med.ccht.persistent.utils;

import gov.va.med.ccht.model.dmp.PatientSatSurveyReportParameters;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;

import java.util.ArrayList;
import java.util.List;

public class PSSReportUtils extends GenericDAOImpl
{

	public final static String DO_NOT_INCLUDE = "Do Not Include";
	public final static String ALL = "All";
	public final static String IVR = "IVR";
	public final static String HOME_DEVICE = "Home Device";
	public final static String BROWSER = "Browser";

	public static List getModalityIds(String modality)
	{
		List<Integer> modalityList = new ArrayList<Integer>();
		
		
		if(modality != null && modality.equalsIgnoreCase(ALL))
		{
			modalityList.add(11501);
			modalityList.add(11502);
			modalityList.add(11503);
		}
		else if(modality != null && modality.equalsIgnoreCase(HOME_DEVICE))
		{
			modalityList.add(11501);			
		}
		else if(modality != null && modality.equalsIgnoreCase(IVR))
		{
			modalityList.add(11502);			
		}
		else if(modality != null && modality.equalsIgnoreCase(BROWSER))
		{
			modalityList.add(11503);			
		}
		
		return modalityList;
	}
	public static String getModalityString(PatientSatSurveyReportParameters reportParams)
	{
		return getModalityString(reportParams.getModality());
	}
	
	public static String getModalityString(String selectedModality)
	{
		StringBuilder modalityString = new StringBuilder();

		if (selectedModality.equalsIgnoreCase(DO_NOT_INCLUDE))
		{
			modalityString.append(" '' AS [Modality] ");
		}
		else
		{
			modalityString.append(" DEVICE_MODALITY_TYPE.NAME AS [Modality] ");
		}
	

		return modalityString.toString();
	}
	
	public static String getModalityInnerJoinString(PatientSatSurveyReportParameters reportParams)
	{
		StringBuilder modalityString = new StringBuilder();

		if (reportParams.getModality().equalsIgnoreCase(DO_NOT_INCLUDE))
		{
			modalityString.append(" ");
		}
		else
		{
			modalityString.append(" INNER JOIN DEVICE_MODALITY_TYPE ON Device.Device_Modality_Type_ID = DEVICE_MODALITY_TYPE.ID ");
		}
		
		return modalityString.toString();
		
	}
	
	public static String getModalityInString(PatientSatSurveyReportParameters reportParams)
	{
		StringBuilder modalityString = new StringBuilder();

		if (reportParams.getModality().equalsIgnoreCase(DO_NOT_INCLUDE))
		{
			modalityString.append(" ");
		}
		else
		{
			modalityString.append(" and Device.Device_Modality_Type_ID in (:modalityIdList) ");
		}
		
		return modalityString.toString();
		
	}
	
	public static String getModalityStringForGroupByClause(PatientSatSurveyReportParameters reportParams)
	{
		StringBuilder modalityString = new StringBuilder();

		if (reportParams.getModality().equalsIgnoreCase(DO_NOT_INCLUDE))
		{
			modalityString.append(" ");
		}
		else
		{
			modalityString.append(", DEVICE_MODALITY_TYPE.NAME ");
		}
		


		return modalityString.toString();
	}
	
	public static String getSurveyIdClause(
			PatientSatSurveyReportParameters reportParams)
	{
		StringBuilder qString = new StringBuilder();

		switch (reportParams.getPatientSatisfactionVersion())
		{
		case 1:
			qString.append("AND (b.Survey_ID = 1) ");
			break;
		case 2:
			qString.append("AND (b.Survey_ID = 2) ");
			break;
		case 3:
			qString.append("AND (b.Survey_ID = 3) ");
			break;
		}

		return qString.toString();
	}

}
