package gov.va.med.ccht.persistent.hibernate;

import gov.va.med.ccht.persistent.TerminologyDAO;
import gov.va.med.fw.model.lookup.AbstractActiveLookup;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.dao.DataAccessException;

/**
 * @author Muddaiah Ranga
 */
public class TerminologyDAOImpl extends GenericDAOImpl implements TerminologyDAO {

	private static final long serialVersionUID = -8225278338802392588L;

	private Map<String, String> findAllQueryMap = new HashMap<String, String>();

	public <T extends Lookup> List<T> findAll(Class<T> terminologyType) throws DAOException {
		return findAll(terminologyType.getName());
	}

	@SuppressWarnings("unchecked")
	public <T extends Lookup> List<T> findAll(String terminologyType) throws DAOException {
		// get custom query
		String query = null;
		
		String type = (String) findAllQueryMap.get(terminologyType);

		// create default query if custom query is not defined
		try {
			Class<?> clazz=null;
			if (type == null) {
				try {
					clazz = Class.forName(terminologyType);
					//test for trusted object types for IHTA Terminolgies
					if(!AbstractLookup.class.isAssignableFrom(clazz))
					{
						throw new DAOException("TerminologyType does not implement AbsractLookup");
					}
							
				} catch (ClassNotFoundException e) {
					logger.debug(e.getMessage());
					throw new DAOException("Terminology table not found");
				}
				query = "select l from " + clazz.getName() + " l order by l.name asc";												
				return getJpaTemplate().find(query);
				
			} else {
					if("weeksOfmonth".equals(type))					
							query = "select l from gov.va.med.ccht.model.terminology.WeekOfMonth l order by l.identifier asc";
					else if ("reportRunFrequency".equals(type))
						query = "select l from gov.va.med.ccht.model.terminology.RunFrequency l order by l.code asc";
					else if ("months".equals(type))
						query = "select l from gov.va.med.ccht.model.terminology.Month l order by l.code asc";
					else if ("daysOfMonth".equals(type))
						query = "select l from gov.va.med.ccht.model.terminology.DayOfMonth l order by l.identifier asc";
					else if ("daysOfQuarter".equals(type))
						query = "select l from gov.va.med.ccht.model.terminology.DayOfQuarter l order by l.identifier asc";
					else if ("weekDays".equals(type))
						query = "select l from gov.va.med.ccht.model.terminology.DayOfWeek l order by l.code asc";
					else if ("reportScheduleTypes".equals(type))
						query = "select l from gov.va.med.ccht.model.terminology.ScheduleType l order by l.code asc";
					else if ("reportPeriodTypes".equals(type))
						query = "select l from gov.va.med.ccht.model.terminology.ReportPeriodType l order by l.code asc";
					else if("quarters".equals(type))
						query = "select l from gov.va.med.ccht.model.terminology.Quarter l order by l.code asc";
					
					return getJpaTemplate().find(query);
					
					//return getJpaTemplate().findByNamedQuery(query);							
			}
		} catch (DataAccessException e) {
			throw new DAOException(e.getMessage(), e);
		}
	}

	@SuppressWarnings("unchecked")
	public <T extends Lookup> List<T> findAllActive(Class<T> terminologyType) throws DAOException {
		if (AbstractActiveLookup.class.isAssignableFrom(terminologyType)) {
			return (List<T>) findAllActive(terminologyType.getName());
		} else {
			return findAll(terminologyType.getName());
		}
	}

	@SuppressWarnings("unchecked")
	public Lookup getByCode(String terminologyType, String code) throws DAOException {
		Class<?> clazz=null;
		try {
			clazz = Class.forName(terminologyType);
		} catch (ClassNotFoundException e) {
			logger.debug(e.getMessage());
			e.printStackTrace();				
			
			throw new DAOException("Terminology table not found:" + terminologyType);
		}
		String query = "select l from " + clazz.getName() + " l where l.code = :code";
		List<Lookup> list = getJpaTemplate().findByNamedParams(query,
				Collections.singletonMap("code", code));
		if (list != null && list.size() > 0)
			return list.get(0);
		return null;
	}

	@SuppressWarnings("unchecked")
	public <T extends Lookup> List<T> getByCodes(Class<T> terminologyType, Collection<String> codes) {
		String query = "select l from " + terminologyType.getName() + " l where l.code in (:codes)";
		List<T> list = getJpaTemplate().findByNamedParams(query,
				Collections.singletonMap("codes", codes));
		return list;
	}

	@SuppressWarnings("unchecked")
	public <T extends Lookup> T getByCode(Class<T> terminologyType, String code)
			throws DAOException {
		return (T) this.getByCode(terminologyType.getName(), code);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.IHTA.persistent.TerminologyDAO#getByName(java.lang.Class,
	 * java.lang.String)
	 */
	@SuppressWarnings("unchecked")
	public <T extends Lookup> T getByName(Class<T> terminologyType, String name)
			throws DAOException {
		return (T) this.getByName(terminologyType.getName(), name);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.IHTA.persistent.TerminologyDAO#getByName(java.lang.String,
	 * java.lang.String)
	 */
	@SuppressWarnings("unchecked")
	public Lookup getByName(String terminologyType, String name) throws DAOException {
		Class<?> clazz=null;
		try {
			clazz = Class.forName(terminologyType);
		} catch (ClassNotFoundException e) {
			logger.debug(e.getMessage());
			
			throw new DAOException("Terminology table not found:" + terminologyType);
		}
		String query = "select l from " + clazz.getName() + " l where l.name = :name";
		List<Lookup> list = getJpaTemplate().findByNamedParams(query,
				Collections.singletonMap("name", name));
		if (list != null && list.size() > 0)
			return list.get(0);
		return null;

	}

	/**
	 * @return the findAllQueryMap
	 */
	public Map<String, String> getFindAllQueryMap() {
		return findAllQueryMap;
	}

	/**
	 * @param findAllQueryMap
	 *            the findAllQueryMap to set
	 */
	public void setFindAllQueryMap(Map<String, String> findAllQueryMap) {
		this.findAllQueryMap = findAllQueryMap;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.IHTA.persistent.TerminologyDAO#getById(java.lang.Class,
	 * java.lang.Long)
	 */
	@SuppressWarnings("unchecked")
	public <T extends Lookup> T getById(Class<T> terminologyType, Long id) throws DAOException {
		return (T) getById(terminologyType.getName(), id);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.IHTA.persistent.TerminologyDAO#getById(java.lang.String,
	 * java.lang.Long)
	 */
	@SuppressWarnings("unchecked")
	public Lookup getById(String terminologyType, Long id) throws DAOException {
		Class<?> clazz=null;
		try {
			clazz = Class.forName(terminologyType);
		} catch (ClassNotFoundException e) {
			
			throw new DAOException("Terminology table not found");
		}
		System.out.println(clazz.getName());
		String query = "select l from " + clazz.getName() + " l where l.identifier = "
				+ id.toString();
		List<Lookup> list = getJpaTemplate().find(query);
		if (list != null && list.size() > 0) {
			return list.get(0);
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.IHTA.persistent.TerminologyDAO#searchIcd(java.lang.String,
	 * java.lang.String)
	 */
	@SuppressWarnings("unchecked")
	public List<? extends Lookup> searchTerms(String terminologyType, String searchCriteria)
			throws DAOException {
		StringBuilder query = new StringBuilder();
		query.append("select l from " + terminologyType + " l where ");
		query.append("(l.code like '%" + searchCriteria + "%' or l.name like '%" + searchCriteria + "%') ");
		List<? extends Lookup> list = getJpaTemplate().find(query.toString());
		if (list != null && list.size() > 0) {
			return list;
		}
		return null;
	}

	private List<?> findAllActive(String terminologyType) throws DAOException {
		// get custome query
		String query = (String) findAllQueryMap.get(terminologyType);

		// create default query if custom query is not defined
		try {
			if (query == null) {
				query = "select l from " + terminologyType
						+ " l where l.active = true order by l.name asc";
				return getJpaTemplate().find(query);
			} else {
				return getJpaTemplate().findByNamedQuery(query);
			}
		} catch (DataAccessException e) {
			throw new DAOException(e.getMessage(), e);
		}
	}
	
	public void save(AbstractLookup lookup) throws DAOException {
		try {
			saveObject(lookup);
		} catch (DataAccessException e) {
			throw new DAOException(e.getMessage(), e);
		}
	}
}
