/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.persistent.hibernate;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

import javax.persistence.EntityManager;
import javax.persistence.Query;

import gov.va.med.fw.persistent.hibernate.AbstractDAOImpl;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import gov.va.med.fw.util.DateUtils;

import gov.va.med.ccht.model.inventory.DIReportParameters;
import gov.va.med.ccht.model.inventory.DeviceStatusType;
import gov.va.med.ccht.model.report.ReportParameters;
import gov.va.med.ccht.model.report.ReportSetup;
import gov.va.med.ccht.model.report.scheduled.DateRangeBoundary;
import gov.va.med.ccht.service.report.StandardReportCriteria;

/**
 * 
 * 
 * IHTA ohrs_common Nov 4, 2010
 * 
 * @author vhaisakatikm
 */
public class StandardReportDataDAOImpl extends AbstractStandardReportDataDAOImpl {
	private static final long serialVersionUID = -5623959498516400752L;

	public static final long MILLISECONDS_DAY = 24 * 60 * 60 * 1000;

	@Override
	protected Query buildQuery(ReportConfiguration config, EntityManager entityManager)
			throws ReportDataException {
		// return entityManager.createNamedQuery(this.queryName);
		// Get All the parameters
		QueryCriteria criteria = config.getQueryCriteria();
		StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria) criteria
				: null;
		// Build and return the query
		Query query = super.buildQuery(config, entityManager);

		if (reportCriteria != null) {
			ReportSetup setup = reportCriteria.getReportSetup();
			Map<String, Object> paramMap = getQueryParameters(setup);
			AbstractDAOImpl.setQueryParameters(query, paramMap);
		}
		return query;
	}

	@Override
	protected Map<String, Object> getQueryParameters(ReportSetup setup) {
		Map<String, Object> paramMap = super.getQueryParameters(setup);
		ReportParameters params = setup != null ? setup.getReportParameters() : null;
		if(params!=null)
		{
		DIReportParameters diReportParams = (DIReportParameters) params;
		DateRangeBoundary scheduledReportFromDate = params.getScheduledReportFromDate();
		DateRangeBoundary scheduledReportToDate = params.getScheduledReportToDate();

		boolean isScheduledReport = scheduledReportFromDate != null && scheduledReportToDate != null;

		Date reportStartDate = diReportParams.getReportWeek() == null ? null : diReportParams.getReportWeek().getStartDate();
		Date reportEndDate = diReportParams.getReportWeek() == null ? null : diReportParams.getReportWeek().getEndDate();
	
		if (isScheduledReport) {
			//calculate the dates
		} else {
			//adjust the dates if needed or compute other required dates
		}
		
		if (diReportParams.getFromDate() != null) {
			paramMap.put("fromDate", diReportParams.getFromDate());
		}else {
			//default from date
			Calendar cal = Calendar.getInstance();
			cal.set(2000,0,1,0,0,0); //Olddest date for IHTA database
			paramMap.put("fromDate", cal.getTime());
		}
		if (diReportParams.getToDate() != null) {
			paramMap.put("toDate", diReportParams.getToDate());
		}else {			
			//default to date
			paramMap.put("toDate", DateUtils.getTomorrowDate());
		}
		if (reportStartDate != null) {
			paramMap.put("reportStartDate", reportStartDate);
		}
		if (reportEndDate != null) {
			paramMap.put("reportEndDate", reportEndDate);
		}

		//Visn
		if (diReportParams.getVisn() != null) {
			paramMap.put("allVisn", "Visn");
			paramMap.put("visnId", diReportParams.getVisn().getId());
		}else {
			paramMap.put("allVisn", "allVisn");
			paramMap.put("visnId", new Long(0));
		}
		//Facilities
		if (diReportParams.getFacility() != null) {
			paramMap.put("allFacilities", "Facilitiy");
			paramMap.put("facilityId", diReportParams.getFacility().getId());
		}else {
			paramMap.put("allFacilities", "allFacilities");
			paramMap.put("facilityId", new Long(0));
		}
		//Device Statuses
		Set<DeviceStatusType> deviceStatuses = diReportParams.getDeviceStatuses();
		if (deviceStatuses != null && deviceStatuses.size() > 0){
			paramMap.put("deviceStatuses", getLookupIds(deviceStatuses));
		}
		}		
		// return parameter map
		return paramMap;
	}

	// Returns the date in the server time zone as entered by the user
	protected Date getUserDate(Date userDate, TimeZone userTz) {
		if (userDate == null)
			return null;
			SimpleDateFormat dateFormat = new SimpleDateFormat(DateUtils.MMDDYYYY);
			dateFormat.setTimeZone(userTz);
			String dateStr = dateFormat.format(userDate);
			try {
				return DateUtils.parseDate(dateStr, DateUtils.MMDDYYYY);
			} catch (ParseException e) {
				return userDate;
			}
	}

	protected Date getDefaultFromDate() {
		return DateUtils.createCalendar(1900, 1, 1).getTime();
	}

	protected Date addDay(Date userDate) {
		Calendar cal = Calendar.getInstance();
		cal.setTime(userDate);
		cal.add(Calendar.DATE, 1);
		return cal.getTime();
	}
}
