/**
 * 
 */
package gov.va.med.ccht.persistent.hibernate;


import gov.va.med.ccht.model.qir.QIR;
import gov.va.med.ccht.model.qir.QIRSearchParameters;
import gov.va.med.ccht.model.qir.QIRStatusType;
import gov.va.med.ccht.persistent.QIRDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import gov.va.med.fw.persistent.hibernate.QueryAndParams;
import gov.va.med.fw.ui.model.TermType;
import gov.va.med.fw.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @author vhaisakatikm
 *
 */
public class QIRDAOImpl extends GenericDAOImpl implements QIRDAO {

	private static final long serialVersionUID = 80510049879019497L;

	public QIR saveQIR(QIR qir) throws DAOException {
		try {
			QIR persisted = (QIR)super.getJpaTemplate().merge( qir );
			super.getJpaTemplate().flush();
			return persisted;
		}
		catch(Exception e) {
			throw new DAOException(e.getMessage(), e);
		}
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public List<Object[]> searchQIR(QIRSearchParameters qirSearchParameters)
			throws DAOException {
		try {				
			QueryAndParams queryAndParams = null;
			queryAndParams = buildQuerySearchByGeneric(qirSearchParameters);
			List<Object[]> results = (List<Object[]>) executeSQLQuery(queryAndParams);
			return results;
		} catch (Exception e) {
				throw new DAOException(e.getMessage(), e);
		}
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public List<String> getVendorResponseDueQIRIds() throws DAOException {
		String query = 		
			"SELECT cast(q.QIR_ID as varchar) id FROM qir.QIR q where q.VENDOR_RESP_DUE_DATE is not null " +
			"and q.VENDOR_RESP_DUE_DATE < current_timestamp " +
			"and q.qir_status_type_id in (select qst.id from qir.qir_status_types qst where code in (2,4,5)) " +
			"and q.date_email_reminder_sent is null";
		QueryAndParams queryAndParams = new QueryAndParams(query);
		List<String> results = (List<String>) executeSQLQuery(queryAndParams);		
		return results;
	}

	private QueryAndParams buildQuerySearchByGeneric(QIRSearchParameters qirSearchParameters) 
	 {
		
		Map<String, Object> parameters = new HashMap<String, Object>();				
		String query = 	"SELECT ";
			if (qirSearchParameters.getMaxRecords() != null && qirSearchParameters.getMaxRecords() > 0) {
				query += " top " + qirSearchParameters.getMaxRecords().intValue() + " ";
			}
			query +=
			"q.QIR_ID id, qt.NAME qirType, qst.NAME qirStatusType, " +
			"cast(v.visn_name as varchar) visn, f.facility_id facilityCode, f.facility_name facility, " +
			"mdmt.NAME deviceType, ven.VENDOR_NAME vendor, " +
			"q.QIR_COMPLAINT complaint, q.QIR_SUMMARY headline, " +
			"q.DATE_SUBMITTED submittedDate, q.SUBMITTED_BY submittedBy, " +
			"isnull(u.last_name,'') + ', ' + isnull(u.first_name,'')+' ' + isnull(u.middle_name,'') submittedByName, " +
			"count(qda.QIR_DOC_ATTCHMNT_ID) attchmnt_cnt "+			
			"FROM qir.QIR q " +			
			"join qir.QIR_STATUS_TYPES qst on q.QIR_STATUS_TYPE_ID = qst.ID " +
			"join ht.app_user u on q.SUBMITTED_BY = u.user_name " +
			"left join qir.QIR_TYPES qt on q.QIR_TYPE_ID = qt.id " +
			"left join dbo.MEDICAL_DEVICE_MODEL_TYPE mdmt on q.MED_DVC_MODEL_TYPE_ID = mdmt.id " +
			"left join dbo.VENDOR ven on q.VENDOR_ID = ven.Vendor_ID " +
			"left join dbo.facilities f on q.FACILITIES_ID = f.ID " +
			"left join dbo.visn v on q.visn_id = v.visn_id "+
			"left outer join qir.QIR_DOC_ATTACHMENTS qda on q.QIR_ID = qda.QIR_ID ";
		
			//qir id and statuses are exclusive
			List<TermType> qirStatuses = qirSearchParameters.getQirStatuses();
			if (StringUtils.isEmpty(qirSearchParameters.getId())) {
				List<String> defaultQirStatuses = new ArrayList<String>();
				if (qirStatuses != null && qirStatuses.size() > 0) {
					for (TermType qst:qirStatuses) {
						defaultQirStatuses.add(qst.getValue());
					}
					parameters.put("qirStatuses", defaultQirStatuses);
					query += "where qst.code in (:qirStatuses) ";
				}else {					
					defaultQirStatuses.add(QIRStatusType.CLOSED);
					defaultQirStatuses.add(QIRStatusType.WITHDRAWN);	
					parameters.put("qirStatuses", defaultQirStatuses);
					query += "where qst.code not in (:qirStatuses) ";
				}
				
				
				//Additional search conditions
				if (qirSearchParameters.getDeviceType() != null) {
					parameters.put("deviceType", qirSearchParameters.getDeviceType().getValue());
					query += "and mdmt.code = :deviceType ";
				}
				
				if (qirSearchParameters.getVendor() != null) {
					parameters.put("vendor_id", qirSearchParameters.getVendor().getValue() );
					query += "and ven.vendor_id = :vendor_id ";
				}
				
				if (qirSearchParameters.getQirType() != null) {
					parameters.put("qirType", qirSearchParameters.getQirType().getValue());
					query += "and qt.code = :qirType ";
				}
				
				if (qirSearchParameters.getFacility() != null) {
					parameters.put("station", qirSearchParameters.getFacility().getValue());
					query += "and f.facility_id = :station ";
				}							
				
				if (qirSearchParameters.getVisn() != null) {
					parameters.put("visnName", qirSearchParameters.getVisn().getValue());
					query += "and v.visn_name = :visnName ";
				}	
				if (StringUtils.isNotEmpty(qirSearchParameters.getSubmittedBy())) {
					parameters.put("submittedBy", qirSearchParameters.getSubmittedBy());
					query += "and q.submitted_by = :submittedBy ";
				}
				if (qirSearchParameters.getSubmittedFromDate() != null) {
					parameters.put("submittedFromDate", qirSearchParameters.getSubmittedFromDate());
					query += "and DATE_SUBMITTED >= :submittedFromDate ";
				}
				if (qirSearchParameters.getSubmittedToDate() != null) {
					parameters.put("submittedToDate", qirSearchParameters.getSubmittedToDate());
					query += "and DATE_SUBMITTED <= :submittedToDate ";
				}
			} else {
				parameters.put("id", qirSearchParameters.getId());
				query += "where q.qir_id = :id ";
			}
						
			//order by
			//query += "order by id desc";
			//group by
			query += "group by q.QIR_ID, qt.NAME, qst.NAME, v.visn_name, f.facility_id, f.facility_name, mdmt.NAME, ven.VENDOR_NAME, q.QIR_COMPLAINT, q.QIR_SUMMARY, q.DATE_SUBMITTED, " +
					"q.SUBMITTED_BY, u.last_name, u.first_name, u.middle_name order by q.QIR_ID DESC";			
		

		QueryAndParams queryAndParams = new QueryAndParams(query,parameters);
		return queryAndParams;
	}	
	
	public Date getVendorResponseDueDate(String qirId) throws DAOException
	{
		try {
			StringBuffer query = new StringBuffer();
			query.append("SELECT MAX(VENDOR_RESP_DUE_DATE) FROM qir.QIR_H WHERE qir_id = :id");
			
			QueryAndParams queryAndParams = new QueryAndParams(query.toString());
			queryAndParams.addParam("id", qirId);			
			List<?> dates = executeSQLQuery(queryAndParams);
			
			Date vendorResponseDueDate = (Date)dates.get(0);
			
			return vendorResponseDueDate;
		}
		catch(Exception e) {
			throw new DAOException(e.getMessage(), e);
		}
	}
}
