package gov.va.med.ccht.persistent.hibernate;

import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.inventory.Vendor;
import gov.va.med.ccht.model.dmp.DMP;
import gov.va.med.ccht.model.dmp.DMPContents;
import gov.va.med.ccht.model.dmp.DMPFindReplaceCriteria;
import gov.va.med.ccht.model.dmp.DMPFindResults;
import gov.va.med.ccht.model.dmp.DMPQuestion;
import gov.va.med.ccht.model.dmp.DMPResponse;
import gov.va.med.ccht.model.dmp.DMPReview;
import gov.va.med.ccht.model.dmp.DMPSearch;
import gov.va.med.ccht.model.dmp.DMPSearchParameters;
import gov.va.med.ccht.model.dmp.DMPStandLibCatType;
import gov.va.med.ccht.model.dmp.DMPStandLibContentType;
import gov.va.med.ccht.model.dmp.DMPStandLibEntry;
import gov.va.med.ccht.model.dmp.DMPStatusType;
import gov.va.med.ccht.model.dmp.DMPToolUser;
import gov.va.med.ccht.model.dmp.DMPVendorDeployment;
import gov.va.med.ccht.model.dmp.FindDMPAttributes;
import gov.va.med.ccht.model.dmp.FindDMPContent;
import gov.va.med.ccht.model.dmp.FindDMPResponseContent;
import gov.va.med.ccht.persistent.DMPDAO;
import gov.va.med.ccht.util.DMPExport;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import gov.va.med.fw.persistent.hibernate.QueryAndParams;
import gov.va.med.fw.util.date.TimeZoneUtils;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

import javax.persistence.EntityManager;
import javax.persistence.Query;

import org.springframework.dao.DataAccessException;
import org.springframework.orm.jpa.JpaCallback;

public class DMPDAOImpl extends GenericDAOImpl implements DMPDAO {

	private static final long serialVersionUID = 4297939088035071869L;

	public DMP saveDMP(DMP dmp) throws DAOException {
		try {
			// DMP persisted=null;
			DMP persisted = (DMP) super.getJpaTemplate().merge(dmp);
			super.getJpaTemplate().flush();

			// persisted=(DMP)this.saveObject(dmp);
			return persisted;
		} catch (Exception e) {
			throw new DAOException(e.getMessage(), e);
		}
	}

	public DMPStandLibEntry saveDMPStandLibEntry(
			DMPStandLibEntry dmpStandLibEntry) throws DAOException {
		try {
			DMPStandLibEntry persisted = (DMPStandLibEntry) super
					.getJpaTemplate().merge(dmpStandLibEntry);
			super.getJpaTemplate().flush();

			// persisted=(DMP)this.saveObject(dmp);
			return persisted;
		} catch (Exception e) {
			throw new DAOException(e.getMessage(), e);
		}

	}

	@SuppressWarnings("unchecked")
	public Boolean isDMPStandLibEntryDuplicate(
			DMPStandLibEntry dmpStandLibEntry) throws DAOException {
		try {
			StringBuilder qString = new StringBuilder();
			qString.append("select dmp.");
			DMPStandLibCatType catType = dmpStandLibEntry.getSlCategoryType();
			DMPStandLibContentType contentType = dmpStandLibEntry.getSlContentType();
			String content = dmpStandLibEntry.getSlContent();
			String query = "select l from " + DMPStandLibEntry.class.getName()
			+ " l where l.slCategoryType = :catType and l.slContentType =:contentType and l.slContent =:content";
			Map map = new HashMap();
			map.put("catType", catType);
			map.put("contentType", contentType);
			map.put("content", content);
	List<DMPStandLibEntry> list = getJpaTemplate().findByNamedParams(query,map);
	if (list != null && list.size() > 0) {
		DMPStandLibEntry matchingStandLibEntry = (DMPStandLibEntry)list.get(0);
		if(matchingStandLibEntry.getId().longValue()!=dmpStandLibEntry.getId().longValue())
		{
			return true;
		}
		else
		{
			return false;
		}

	}
	return false;
		} catch (Exception e) {
			throw new DAOException(e.getMessage(), e);
		}

	}

	public DMPToolUser saveDMPToolUser(DMPToolUser assignee) throws DAOException {
		return saveDMPToolUser(assignee, true);
	}

	public DMPToolUser saveDMPToolUser(DMPToolUser assignee, boolean isAssignDMP) throws DAOException {
		try {
			DMPToolUser persisted = saveDMPToolUser2(assignee, isAssignDMP);
			return persisted;
		} catch (Exception e) {
			throw new DAOException(e.getMessage(), e);
		}
	}
	
	public DMPQuestion saveDMPQuestion(DMPQuestion question)
			throws DAOException {
		try {

			DMPQuestion persisted = (DMPQuestion) super.getJpaTemplate().merge(
					question);
			super.getJpaTemplate().flush();
			return persisted;
		} catch (Exception e) {
			throw new DAOException(e.getMessage(), e);
		}
	}

	public DMPResponse saveDMPResponse(DMPResponse response)
			throws DAOException {
		try {

			DMPResponse persisted = (DMPResponse) super.getJpaTemplate().merge(
					response);
			super.getJpaTemplate().flush();
			return persisted;
		} catch (Exception e) {
			throw new DAOException(e.getMessage(), e);
		}
	}

	@SuppressWarnings("unchecked")
	public DMP findDMPById(String dmpId) throws DAOException {
		try {
			Long id = Long.valueOf(dmpId);
			String query = "select l from " + DMP.class.getName()
					+ " l where l.id = :id";
			List<DMP> list = getJpaTemplate().findByNamedParams(query,
					Collections.singletonMap("id", id));
			if (list != null && list.size() > 0) {
				DMP dmp = list.get(0);
				//this.setDMPReviewers(dmp);
				return dmp;
			}
			return null;
		} catch (Exception e) {
			throw new DAOException("getDMPById failed", e);
		}
	}
	@SuppressWarnings("unchecked")
	public DMPStandLibEntry findDMPStanLibEntryById(Long id) throws DAOException {
		try {
			String query = "select l from " + DMPStandLibEntry.class.getName()
					+ " l where l.id = :id";
			List<DMPStandLibEntry> list = getJpaTemplate().findByNamedParams(query,
					Collections.singletonMap("id", id));
			if (list != null && list.size() > 0) {
				return list.get(0);
			}
			return null;
		} catch (Exception e) {
			throw new DAOException("findDMPStanLibEntryById failed", e);
		}
	}
	@SuppressWarnings("unchecked")
	public DMPVendorDeployment findDMPVendorDeployment(DMP dmp,Vendor vendor) throws DAOException {
		try {
			String query = "select l from " + DMPVendorDeployment.class.getName()
					+ " l where l.dmp.id = :dmpId and l.vendor= :vendorId and l.dmpVersion=:dmpVersion";
			Map map = new HashMap();
			map.put("dmpId", dmp.getId());
			map.put("vendorId", vendor.getId());
			map.put("dmpVersion",dmp.getDmpVersion());
			List<DMPVendorDeployment> list = getJpaTemplate().findByNamedParams(query,map);
			if (list != null && list.size() > 0) {
				return list.get(0);
			}
			return null;
		} catch (Exception e) {
			throw new DAOException("findDMPVendorDeployment failed", e);
		}
	}
	public DMPVendorDeployment saveDMPVendorDeployment(
			DMPVendorDeployment dmpVendorDeployment) throws DAOException {
		try {
			DMPVendorDeployment persisted = (DMPVendorDeployment) super
					.getJpaTemplate().merge(dmpVendorDeployment);
			super.getJpaTemplate().flush();
			return persisted;
		} catch (Exception e) {
			throw new DAOException(e.getMessage(), e);
		}

	}
	@SuppressWarnings("unchecked")
	public DMPQuestion findQuestionById(String questionId) throws DAOException {
		try {
			Long id = Long.valueOf(questionId);
			String query = "select l from " + DMPQuestion.class.getName()
					+ " l where l.id = :id";
			List<DMPQuestion> list = getJpaTemplate().findByNamedParams(query,
					Collections.singletonMap("id", id));
			if (list != null && list.size() > 0) {
				return list.get(0);
			}
			return null;
		} catch (Exception e) {
			throw new DAOException("findCreatedDmps failed", e);
		}

	}

	@SuppressWarnings("unchecked")
	public User findUserById(String userId) throws DAOException {
		try {
			Long id = Long.valueOf(userId);
			String query = "select l from " + User.class.getName()
					+ " l where l.id = :id";
			List<User> list = getJpaTemplate().findByNamedParams(query,
					Collections.singletonMap("id", id));
			if (list != null && list.size() > 0) {
				return list.get(0);
			}
			return null;
		} catch (Exception e) {
			throw new DAOException("findUserById failed", e);
		}
	}

	@SuppressWarnings("unchecked")
	public List<DMP> findAllDmps() throws DAOException {
		List<DMP> results = new ArrayList<DMP>();
		try {
			results = getJpaTemplate().findByNamedQuery("findAllDmps");
		} catch (Exception e) {
			logger.error("***DMPDAO error:  " + e.getMessage());
			throw new DAOException(e.getMessage(), e);
		}
		return results;
	}

	@SuppressWarnings("unchecked")
	public List<DMPToolUser> findAssigedDmps(String userId) throws DAOException {
		try {
			String query = "select l from " + DMPToolUser.class.getName()
					+ " l where l.appUser.userCredentials.userID = '" + userId + "' and (1.assigned = true or l.reviewer = true)"
					+ " order by l.dmp.name asc";
			return getJpaTemplate().find(query);
		} catch (Exception e) {
			throw new DAOException("getDMPById failed", e);
		}

	}

	@SuppressWarnings("unchecked")
	public List<DMP> findCreatedDmps(String userId) throws DAOException {
		try {
			String query = "select l from " + DMP.class.getName()
					+ " l where l.createdBy.changeUser = '" + userId
					+ "' order by l.name asc";
			return getJpaTemplate().find(query);
		} catch (Exception e) {
			throw new DAOException("findCreatedDmps failed", e);
		}

	}

	public void deleteDMPToolUser(EntityKey<Object> identifier)
			throws DAOException {
		Validate.notNull(identifier, "DMPToolUser identifier can not be null.");
		Validate.notNull(identifier.getKeyValue(),
				"DMPToolUser identifier key can not be null.");
		removeObject(identifier);
	}

	public void deleteDMPQuestion(EntityKey<Object> identifier)
			throws DAOException {
		Validate.notNull(identifier, "DMPQuestion identifier can not be null.");
		Validate.notNull(identifier.getKeyValue(),
				"DMPQuestion identifier key can not be null.");
		removeObject(identifier);
	}

	public void deleteDMPResponse(EntityKey<Object> identifier)
			throws DAOException {
		Validate.notNull(identifier, "DMPResponse identifier can not be null.");
		Validate.notNull(identifier.getKeyValue(),
				"DMPResponse identifier key can not be null.");
		DMPResponse attached = getJpaTemplate().find(DMPResponse.class,
				identifier.getKeyValue());
		getJpaTemplate().getEntityManager().remove(
				getJpaTemplate().getEntityManager().merge(attached));
		// deleteEntity(attached);
		// removeObject(identifier);
	}

	public void deleteDMPResponses(Collection<DMPResponse> responses)
			throws DAOException {

		deleteAll(responses);
	}

	@SuppressWarnings("unchecked")
	public List<DMPToolUser> findDMPToolUsers(DMP dmp) throws DAOException {
		Long id = dmp.getId();
		try {
			String query = "select l from " + DMPToolUser.class.getName()
					+ " l where l.dmp.id = " + id.toString()
					+ " order by l.appUser.familyName asc";
			return getJpaTemplate().find(query);
		} catch (Exception e) {
			throw new DAOException("getDMPById failed", e);
		}
	}

	@SuppressWarnings("unchecked")
	public List<DMPToolUser> findDMPToolUsers(String dmpId) throws DAOException {

		try {
			String query = "select l from " + DMPToolUser.class.getName()
					+ " l where l.dmp.id = " + dmpId;
			return getJpaTemplate().find(query);
		} catch (Exception e) {
			throw new DAOException("getDMPById failed", e);
		}
	}

	@SuppressWarnings("unchecked")
	private List dmpExportList;

	@SuppressWarnings("unchecked")
	public DMPExport exportDmp(String dmpId) throws DAOException {
		logger.info(" CCHTExportDaoImpl ::: getListOfDMPsAvailable");

		StringBuilder qString = new StringBuilder();
		qString.append("SELECT dc.CONTENT_ORDER,");
		qString.append("dc.CONTENT,");
		qString.append("dr.RESPONSE_CONTENT,");
		qString.append("at.NAME,");
		qString.append("dc.FREQUENCY ,");
		qString.append("dr.EDU_CONTENT ,");
		qString.append("dr.NXT_QUESTION_ID,");
		qString.append("dr.VNDR_I_CONTENT as \"VENDOR INSTRUCTIONS\",");
		qString.append("dmp.DMP_ID,");
		qString.append("dmp.NAME,");
		qString.append("dmp.DESCRIPTION,");
		qString.append("dmp.OBJECTIVE,");
		qString.append("dmp.DMP_TAG,");
		qString.append("dc.DMP_CONTENT_ID,");
		qString.append("dc.CONTENT_TYPE_ID,");
		qString.append("dc.RSPNSE_TYPE_ID ");
		qString.append("FROM dmp.DMP dmp, dmp.DMP_CONTENT dc ");
		qString.append("LEFT OUTER JOIN dmp.DMP_RESPONSE dr ");
		qString.append("ON dc.DMP_CONTENT_ID = dr.DMP_CONTENT_ID ");
		qString.append("LEFT OUTER JOIN dmp.DMP_ALERT_TYPE at ");
		qString.append("ON dr.ALERT_LEVEL_ID = at.ID ");
		qString.append("WHERE dmp.DMP_ID = " + dmpId
				+ " AND dmp.DMP_ID = dc.DMP_ID ");
		qString.append("ORDER BY dc.CONTENT_ORDER, dc.CONTENT_TYPE_ID");
		try {
			QueryAndParams queryAndParams = new QueryAndParams(qString
					.toString());
			dmpExportList = executeSQLQuery(queryAndParams);
			// clean up next question get the actual order from the related
			// content

			List<DMPContents> dmpComponentList = new ArrayList<DMPContents>();
			for (int i = 0; i < dmpExportList.size(); i++) {
				Object[] o = (Object[]) dmpExportList.get(i);
				String goTo = sanitizeString(String.valueOf(o[6]));
				if (goTo.length() > 0 && !goTo.equalsIgnoreCase("-1")) {
					String goToSelect = "Select CONTENT_ORDER from dmp.DMP_CONTENT where DMP_CONTENT_ID="
							+ goTo;
					QueryAndParams qp = new QueryAndParams(goToSelect);
					List resultList = executeSQLQuery(qp);
					String newGoToValue = sanitizeString(String
							.valueOf(resultList.get(0)));
					o[6] = newGoToValue;
					dmpExportList.set(i, o);
				}

			}
			if (dmpExportList != null && dmpExportList.size() > 0)
				dmpComponentList = convertContentsToList(dmpExportList);
			DMPExport dmpExport = new DMPExport();

			// Populate contents DMPContents
			dmpExport.setDmpComponentList(dmpComponentList);
			return dmpExport;
		} catch (Exception e) {
			throw new DAOException("getDMPById failed", e);
		}
	}

	private String gotoValue;
	private String dmpContentTypeId;
	private String qStmtOrder;
	private String previousOrder = "0";
	String qStmtIdDesc;

	@SuppressWarnings("unchecked")
	private List<DMPContents> convertContentsToList(List dmpExportList) {
		
		List<DMPContents> contentList = new java.util.ArrayList<DMPContents>();
		previousOrder = "0";
		for (int i = 0; i < dmpExportList.size(); i++) {
			includeContent = true;
			Object[] o = (Object[]) dmpExportList.get(i);
			qStmtOrder = sanitizeString(String.valueOf(o[0])); // int
			qStmtIdDesc = sanitizeString((String) o[1]); // String
			String alertStatus = sanitizeString((String) o[3]); // String
			String freqQuestion = sanitizeString((String) o[4]); // String
			String feedbackEdu = sanitizeString((String) o[5]); // String
			gotoValue = processNextQ(String.valueOf(o[6])); // BigInteger
															// dr.NXT_QUESTION_ID
			String vendorInst = sanitizeString((String) o[7]); // String
			String dmpId = sanitizeString(String.valueOf(o[8])); // BigInteger
			String name = sanitizeString((String) o[9]); // String
			String description = sanitizeString((String) o[10]); // String
			String objective = sanitizeString((String) o[11]); // String
			String dmpTag = sanitizeString((String) o[12]); // String
			String dmpContentId = sanitizeString(String.valueOf(o[13])); // BigInteger
			dmpContentTypeId = sanitizeString(String.valueOf(o[14])); // BigInteger
			String response = processResponse((String) o[2], feedbackEdu, vendorInst); // String
			String dmpVersion       = "";         // String
																// RESPONSE_CONTE
			// qStmtOrder =
			processOrder(qStmtOrder);
			if (includeContent) {
				DMPContents dmpContents = new DMPContents(qStmtOrder,
						qStmtIdDesc, response, alertStatus, freqQuestion,
						feedbackEdu, gotoValue, vendorInst, dmpId, name,
						description, objective, dmpTag, dmpContentId,
						dmpContentTypeId, dmpVersion);
				contentList.add(dmpContents);
			}
			includeContent = true;

		}

		return contentList;
	}

	private void processOrder(String o) {
		if (o.equalsIgnoreCase(previousOrder)) {
			qStmtOrder = "";
			qStmtIdDesc = "";
			if (!dmpContentTypeId.equalsIgnoreCase("1001")) {
				includeContent = false;
			}
		}
		previousOrder = o;
	}

	private boolean includeContent = true;

	private String processNextQ(String nextQ) {
		String returnValu = "";
		if (nextQ == null) {
			returnValu = "";
		} else if (nextQ.equalsIgnoreCase("-1")) {
			int order = Integer.parseInt(qStmtOrder);
			order++;
			returnValu = order + "";
			if (order == dmpExportList.size()) {
				returnValu = "";
			}

		} else {
			returnValu = nextQ;
		}
		return returnValu;
	}

	//fchen 11/27/12: HTCE_CodeCR778 add two more parameters feedbackEdu and vendorInst to check on for export
	private String processResponse(String argument, String feedbackEdu, String vendorInst) {

		// check if row is content
		String retVal = "";

		if (argument == null) {
			gotoValue = "";
			retVal = sanitizeString(argument);
			includeContent = true;
		}
		// extra response rows
		else if (argument != null && argument.length() < 1
				&& dmpContentTypeId.equalsIgnoreCase("1001")
				&& (feedbackEdu == null || feedbackEdu.trim().length() == 0) 
				&& (vendorInst == null || vendorInst.trim().length() == 0) ) { //fchen 11/27/12: HTCE_CodeCR778 export the record as well if VI or EC are not empty
			includeContent = false;
		} else {
			retVal = sanitizeString(argument);
		}
		return retVal;
	}

	private String sanitizeString(String argument) {
		String retVal = "";
		if (argument != null) {
			if (argument.length() > 0) {
				retVal = (argument.equalsIgnoreCase("null") || argument
						.equalsIgnoreCase("0")) ? "" : argument;
				try {
					byte[] utf8 = retVal.getBytes("UTF-8");
					byte[] latin1 = new String(utf8, "UTF-8")
							.getBytes("ISO-8859-1");
					return new String(latin1);

				} catch (UnsupportedEncodingException encodingException) {
					logger.error("Unsupported Encoding exception:  "+encodingException.getMessage());
				}
			}
		}
		return retVal;
	}

	@SuppressWarnings("unchecked")
	public List<DMPToolUser> findDmpFacilitators() throws DAOException {
		List<DMPToolUser> results = new ArrayList<DMPToolUser>();

		try {
			List<Object[]> data = getJpaTemplate().findByNamedQuery(
					"findDmpFacilitators");
			for (Object[] objs : data) {
				DMPToolUser DMPToolUser = new DMPToolUser();
				User user = new User();
				user.setId(new BigInteger(objs[0].toString()).longValue());
				user.setName((String) objs[1]);
				user.setFamilyName((String) objs[2]);
				user.setGivenName((String) objs[3]);
				DMPToolUser.setAppUser(user);
				results.add(DMPToolUser);
			}

		} catch (Exception e) {
			logger.error("***DMPDAO error:  " + e.getMessage());
			throw new DAOException(e.getMessage(), e);
		}
		return results;
	}

	@SuppressWarnings("unchecked")
	public List<DMPToolUser> findAllDMPToolUsers() throws DAOException {
		List<DMPToolUser> results = new ArrayList<DMPToolUser>();

		try {
			List<Object[]> data = getJpaTemplate().findByNamedQuery(
					"findAllUsers");
			for (Object[] objs : data) {
				DMPToolUser DMPToolUser = new DMPToolUser();
				User user = new User();
				user.setId(new BigInteger(objs[0].toString()).longValue());
				user.setName((String) objs[1]);
				user.setFamilyName((String) objs[2]);
				user.setGivenName((String) objs[3]);
				DMPToolUser.setAppUser(user);
				results.add(DMPToolUser);
			}

		} catch (Exception e) {
			logger.error("***DMPDAO error:  " + e.getMessage());
			throw new DAOException(e.getMessage(), e);
		}
		return results;
	}

	@SuppressWarnings("unchecked")
	public List<DMPSearch> getAllDmps() throws DAOException {
		List<DMPSearch> results = new ArrayList<DMPSearch>();
		try {
			results = getJpaTemplate().findByNamedQuery("getAllDmps");
			this.setHasComments(results);
		} catch (Exception e) {
			logger.error("***DMPDAO error:  " + e.getMessage());
			throw new DAOException(e.getMessage(), e);
		}
		return results;
	}

	@SuppressWarnings("unchecked")
	public List<DMPSearch> searchAllDmps(DMPSearchParameters dmpSearchParameters)
			throws DAOException {
		List<DMPSearch> results = new ArrayList<DMPSearch>();
		try {

			boolean whereFlag = false;

			StringBuilder qString = new StringBuilder();
			qString
					.append("select dmp.dmp_id, max(dmp.name) as dmpName, max(description) as dmpDescription ");
			qString
					.append(", max(dmp_tag) as tag, max(status_type_id) as status ");

			// Build SELECT
			// Response Column
			if (StringUtils.isNotEmpty(dmpSearchParameters.getDmpResponse())) {
				qString.append(", max(dr.response_content) as responseContent");
			} else {
				qString.append(", max('') as columnPlaceHolder5 ");
			}
			// Facilitator Column
			if (StringUtils.isNotEmpty(dmpSearchParameters.getFacilitatorId())) {
				qString.append(", max(dmp.record_created_by) AS facilitator  ");
			} else {
				qString.append(", max('') as columnPlaceHolder6 ");
			}
			// Assignee Column
			if (StringUtils.isNotEmpty(dmpSearchParameters.getAssigneeId())) {
				qString.append(", max(dtu.APP_USER_ID) as Assignee ");
			} else {
				qString.append(", max('') as columnPlaceHolder7 ");
			}
			// Question Column
			if (StringUtils.isNotEmpty(dmpSearchParameters.getDmpQuestion())) {
				qString.append(", max(dc.content) as content ");
			} else {
				qString.append(", max('') as columnPlaceHolder8 ");
			}
			if (StringUtils.isNotEmpty(dmpSearchParameters.getDmpQuestion())) {
				qString.append(", dc.content_order  ");
			}
			if (StringUtils.isNotEmpty(dmpSearchParameters.getDmpResponse())) {
				qString.append(", dr.dmp_rspnse_id ");
			}
			// Build FROM
			qString.append(" FROM dmp.DMP dmp ");
			if (StringUtils.isNotEmpty(dmpSearchParameters.getAssigneeId())) {
				qString
						.append("LEFT OUTER JOIN dmp.DMP_TOOL_USER dtu ON dmp.dmp_id = dtu.dmp_id ");
			}

			// QUESTION TABLES
			if (StringUtils.isNotEmpty(dmpSearchParameters.getDmpQuestion())) {
				qString
						.append(" LEFT OUTER JOIN dmp.DMP_CONTENT dc ON dmp.dmp_id = dc.dmp_id ");
				// qString.append(" AND (dc.content_order = 1 or dc.content_order = NULL OR dc.CONTENT like '%"+
				// dmpSearchParameters.getDmpQuestion().trim() + "%') ");

				// qString.append(", dmp.DMP_CONTENT dc ");
			}
			// RESPONSE TABLES
			if (StringUtils.isNotEmpty(dmpSearchParameters.getDmpResponse())) {
				if (StringUtils
						.isNotEmpty(dmpSearchParameters.getDmpQuestion()))
					qString
							.append(" LEFT OUTER JOIN dmp.DMP_RESPONSE dr ON dmp.dmp_id = dc.dmp_id AND dc.DMP_CONTENT_ID = dr.DMP_CONTENT_ID ");
				// qString.append(", dmp.DMP_RESPONSE dr ");
				else {
					qString
							.append(" LEFT OUTER JOIN dmp.DMP_CONTENT dc ON dmp.dmp_id = dc.dmp_id ");
					qString
							.append(" LEFT OUTER JOIN dmp.DMP_RESPONSE dr ON dmp.dmp_id = dc.dmp_id AND dc.DMP_CONTENT_ID = dr.DMP_CONTENT_ID ");
					// qString.append(", dmp.DMP_CONTENT dc,  dmp.DMP_RESPONSE dr ");
				}
				// qString.append(" AND dr.dmp_rspnse_id = (select  min(dr2.dmp_rspnse_id) as test12 from dmp.dmp dmp2, dmp.DMP_CONTENT dc2, dmp.DMP_RESPONSE dr2 ");
				// qString.append(" where dmp.dmp_id = dc2.dmp_id AND dc2.DMP_CONTENT_ID = dr2.DMP_CONTENT_ID and dr2.response_content != ''  ) ");

			}

			// Build WHERE
			if (StringUtils.isNotEmpty(dmpSearchParameters.getDmpName())) {
				if (!whereFlag) {
					qString.append("WHERE ( dmp.name like '%"
							+ dmpSearchParameters.getDmpName().trim() + "%' ");
					// qString.append("WHERE dmp.name like '%"+
					// dmpSearchParameters.getDmpName().trim() + "%' " );
					whereFlag = true;
				} else {
					qString.append("or dmp.name like '%"
							+ dmpSearchParameters.getDmpName().trim() + "%' ");
				}
			}
			if (StringUtils.isNotEmpty(dmpSearchParameters.getDmpTag())) {
				if (!whereFlag) {
					qString.append("WHERE ( dmp.dmp_tag like '%"
							+ dmpSearchParameters.getDmpTag().trim() + "%' ");
					// qString.append("WHERE dmp.dmp_tag like '%"+
					// dmpSearchParameters.getDmpTag().trim() + "%' " );
					whereFlag = true;
				} else {
					qString.append("or dmp.dmp_tag like '%"
							+ dmpSearchParameters.getDmpName().trim() + "%' ");
				}
			}
			if (StringUtils.isNotEmpty(dmpSearchParameters.getDmpQuestion())) {
				if (!whereFlag) {
					qString
							.append("WHERE ( (dmp.DMP_ID = dc.DMP_ID  AND dc.CONTENT like '%"
									+ dmpSearchParameters.getDmpQuestion()
											.trim() + "%') ");
					// qString.append("WHERE (dmp.DMP_ID = dc.DMP_ID  AND dc.CONTENT like '%"+
					// dmpSearchParameters.getDmpQuestion().trim() + "%') " );
					whereFlag = true;
				} else {
					qString
							.append("OR (dmp.DMP_ID = dc.DMP_ID  AND dc.CONTENT like '%"
									+ dmpSearchParameters.getDmpQuestion()
											.trim() + "%' )");
				}
			}
			if (StringUtils.isNotEmpty(dmpSearchParameters.getDmpResponse())) {
				if (!whereFlag) {
					qString
							.append("WHERE ((dmp.DMP_ID = dc.DMP_ID  AND dc.DMP_CONTENT_ID = dr.DMP_CONTENT_ID AND dr.RESPONSE_CONTENT like '%"
									+ dmpSearchParameters.getDmpResponse()
											.trim() + "%') ");
					// qString.append("WHERE (dmp.DMP_ID = dc.DMP_ID  AND dc.DMP_CONTENT_ID = dr.DMP_CONTENT_ID AND dr.RESPONSE_CONTENT like '%"+
					// dmpSearchParameters.getDmpResponse().trim() + "%') " );

					whereFlag = true;
				} else {
					qString
							.append("OR (dmp.DMP_ID = dc.DMP_ID  AND dc.DMP_CONTENT_ID = dr.DMP_CONTENT_ID AND dr.RESPONSE_CONTENT like '%"
									+ dmpSearchParameters.getDmpResponse()
											.trim() + "%' ) ");
				}
			}
			if (whereFlag) {
				qString.append(" ) ");
			}
			if (StringUtils.isNotEmpty(dmpSearchParameters.getStatus())) {

				String statusValue = "";
				if (dmpSearchParameters.getStatus().trim().length() > 1)
					statusValue = dmpSearchParameters.getStatus().trim();
				else
					statusValue = "0" + dmpSearchParameters.getStatus().trim();

				if (!whereFlag) {
					qString.append("WHERE dmp.status_type_id like '%200"
							+ statusValue + "%' ");
					whereFlag = true;
				} else {
					qString.append("AND dmp.status_type_id like '%200"
							+ statusValue + "%' ");
				}

			}
			if (StringUtils.isNotEmpty(dmpSearchParameters.getFacilitatorId())) {
				if (!whereFlag) {
					qString.append("WHERE (dmp.record_created_by like '%"
							+ dmpSearchParameters.getFacilitatorId().trim()
							+ "%' )");
					whereFlag = true;
				} else {
					qString.append("AND (dmp.record_created_by like '%"
							+ dmpSearchParameters.getFacilitatorId().trim()
							+ "%' ) ");
					// qString.append("OR (dmp.record_created_by like '%"+
					// dmpSearchParameters.getFacilitatorId().trim() + "%' ) "
					// );
				}
			}

			if (StringUtils.isNotEmpty(dmpSearchParameters.getAssigneeId())) {
				if (!whereFlag) {
					qString
							.append("WHERE (dmp.dmp_id = dtu.dmp_id AND dtu.app_user_id like '%"
									+ dmpSearchParameters.getAssigneeId()
											.trim() + "%' )");
				} else {
					qString
							.append("AND (dmp.dmp_id = dtu.dmp_id AND dtu.app_user_id like '%"
									+ dmpSearchParameters.getAssigneeId()
											.trim() + "%' )");
				}
			}
			qString.append(" group by dmp.dmp_id ");
			if (StringUtils.isNotEmpty(dmpSearchParameters.getDmpQuestion())) {
				qString.append(", dc.content_order ");
			}
			if (StringUtils.isNotEmpty(dmpSearchParameters.getDmpResponse())) {
				qString.append(", dr.dmp_rspnse_id ");
			}
			qString.append(" order by dmpName asc");
			QueryAndParams queryAndParams = new QueryAndParams(qString
					.toString());
			Long dmp_id = new Long(0);
			List dmpList = executeSQLQuery(queryAndParams);
			for (int i = 0; i < dmpList.size(); i++) {

				Object[] objs = (Object[]) dmpList.get(i);

				DMPSearch DMPSearch = new DMPSearch();
				DMPSearch.setId(new BigInteger(objs[0].toString()).longValue());
				DMPSearch.setName((String) objs[1]);
				DMPSearch.setDescription((String) objs[2]);
				DMPSearch.setTag((String) objs[3]);
				DMPSearch.setStatus((String) objs[4].toString());
				if (dmp_id.longValue() != DMPSearch.getId().longValue()) {

					DMPStatusType statusType = new DMPStatusType();

					qString = new StringBuilder();
					qString.append("select code, name from dmp.DMP_STATUS_TYPE where id = "
							+  " '" + DMPSearch.getStatus() + "' ");
					queryAndParams = new QueryAndParams(qString.toString());

					List statusList = executeSQLQuery(queryAndParams);
					for (int j = 0; j < statusList.size(); j++) {
						Object[] status = (Object[]) statusList.get(j);
						if (status != null) {
							statusType.setCode((String) status[0]);
							statusType.setName((String) status[1]);
						}
					}
					DMPSearch.setDmpStatusType(statusType);

					if (objs[5] != null && !objs[5].toString().isEmpty())
						DMPSearch.setResponse((String) objs[5].toString());
					else
						DMPSearch.setResponse("");
					// Get Facilitator names
					if (objs[6] != null && !objs[6].toString().isEmpty()) {
						DMPSearch.setCreatedByName((String) objs[6].toString());
						qString = new StringBuilder();
						qString
								.append("select max(au.Last_Name + ', ' + au.First_Name) AS facilitator ");
						qString.append(" FROM ht.APP_USER au  ");
						qString.append("WHERE au.user_name like '%"
								+ (String) objs[6].toString() + "%' ");
						queryAndParams = new QueryAndParams(qString.toString());

						List dmpList2 = executeSQLQuery(queryAndParams);
						for (int j = 0; j < dmpList2.size(); j++) {
							if (dmpList2.get(j) == null) {
								DMPSearch.setCreatedByName((String) objs[6]
										.toString());
							} else {
								DMPSearch.setCreatedByName((String) dmpList2
										.get(j));
							}
						}
					} else {
						DMPSearch.setCreatedByName("");
					}
					// Get Assignees names
					if (objs[7] != null && !objs[7].toString().isEmpty()) {
						DMPSearch.setAssignee((String) objs[7].toString());
						qString = new StringBuilder();
						qString
								.append("select au.Last_Name + ', ' + au.First_Name AS assignee ");
						qString.append(" FROM ht.APP_USER au ");
						qString.append("WHERE au.app_user_id like '%"
								+ (String) objs[7].toString() + "%' ");
						queryAndParams = new QueryAndParams(qString.toString());

						List dmpList2 = executeSQLQuery(queryAndParams);
						for (int j = 0; j < dmpList2.size(); j++) {
							if (dmpList2.get(j) == null) {
								DMPSearch.setAssignee((String) objs[7]
										.toString());
							} else {
								DMPSearch.setAssignee((String) dmpList2.get(j));
							}
						}
					} else {
						DMPSearch.setAssignee("");
					}
					if (objs[8] != null && !objs[8].toString().isEmpty())
						DMPSearch.setQuestion((String) objs[8].toString());
					else
						DMPSearch.setQuestion("");

					results.add(DMPSearch);
				}
				dmp_id = DMPSearch.getId();
			}
			this.setHasComments(results);
			return results;

		} catch (Exception e) {
			throw new DAOException(e.getMessage(), e);
		}
	}

	@SuppressWarnings("unchecked")
	public List<DMPFindResults> findTermInDMPAttributes(
			DMPFindReplaceCriteria criteria) throws DAOException {
		List<DMPFindResults> results = new ArrayList<DMPFindResults>();

		try {
			String findTerm = criteria.getFindTerm();
			findTerm = findTerm.replaceAll("_", "[_]");
			findTerm = findTerm.replaceAll("%", "[%]");
			findTerm = findTerm.replaceAll("\\[", "[[]");
			String nameQuery = "select l from "
					+ FindDMPAttributes.class.getName()
					+ " l where l.name like concat('%',:findTerm,'%')"
					+ " order by l.name asc";
			Map<String,Object> nameParams = new HashMap<String,Object>();
			nameParams.put("findTerm", findTerm);
			List<FindDMPAttributes> nameAttributes = getJpaTemplate().findByNamedParams(nameQuery, nameParams);
			for (FindDMPAttributes aNameAttribute : nameAttributes) {
				DMPFindResults aFindResult = new DMPFindResults();
				aFindResult.setDmpName(aNameAttribute.getName());
				aFindResult.setDmpTag(aNameAttribute.getTag());
				aFindResult.setFindLocation("DMP Name");
				aFindResult.setDmpFacilitator(aNameAttribute.getFacilitator());
				aFindResult.setLocked("No");
				aFindResult.setContents(aNameAttribute.getName());
				aFindResult.setId(aNameAttribute.getId());
				results.add(aFindResult);
			}
			String queryTag = "select l from "
					+ FindDMPAttributes.class.getName()
					+ " l where l.tag like concat('%',:findTerm,'%')"
					+ " order by l.name asc";
			Map<String,Object> tagParams = new HashMap<String,Object>();
			tagParams.put("findTerm", findTerm);			
			List<FindDMPAttributes> tagAttributes = getJpaTemplate().findByNamedParams(queryTag, tagParams);
			for (FindDMPAttributes aNameAttribute : tagAttributes) {
				DMPFindResults aFindResult = new DMPFindResults();
				aFindResult.setDmpName(aNameAttribute.getName());
				aFindResult.setDmpTag(aNameAttribute.getTag());
				aFindResult.setFindLocation("DMP Tag");
				aFindResult.setDmpFacilitator(aNameAttribute.getFacilitator());
				aFindResult.setLocked("No");
				aFindResult.setContents(aNameAttribute.getTag());
				aFindResult.setId(aNameAttribute.getId());
				results.add(aFindResult);
			}
			String queryDesc = "select l from "
					+ FindDMPAttributes.class.getName()
					+ " l where l.description like concat('%',:findTerm,'%')"
					+ " order by l.name asc";
			Map<String,Object> descParams = new HashMap<String,Object>();
			descParams.put("findTerm", findTerm);			
			List<FindDMPAttributes> descAttributes = getJpaTemplate().findByNamedParams(queryDesc, descParams);	
			for (FindDMPAttributes aNameAttribute : descAttributes) {
				DMPFindResults aFindResult = new DMPFindResults();
				aFindResult.setDmpName(aNameAttribute.getName());
				aFindResult.setDmpTag(aNameAttribute.getTag());
				aFindResult.setFindLocation("DMP Description");
				aFindResult.setDmpFacilitator(aNameAttribute.getFacilitator());
				aFindResult.setLocked("No");
				aFindResult.setContents(aNameAttribute.getDescription());
				aFindResult.setId(aNameAttribute.getId());
				results.add(aFindResult);
			}
			String queryObjective = "select l from "
					+ FindDMPAttributes.class.getName()
					+ " l where l.objective like concat('%',:findTerm,'%')"
					+ " order by l.name asc";
			Map<String,Object> params = new HashMap<String,Object>();
			params.put("findTerm", findTerm);			
			List<FindDMPAttributes> objAttributes = getJpaTemplate().findByNamedParams(queryObjective, params);		
			for (FindDMPAttributes aNameAttribute : objAttributes) {
				DMPFindResults aFindResult = new DMPFindResults();
				aFindResult.setDmpName(aNameAttribute.getName());
				aFindResult.setDmpTag(aNameAttribute.getTag());
				aFindResult.setFindLocation("DMP Objective");
				aFindResult.setDmpFacilitator(aNameAttribute.getFacilitator());
				aFindResult.setLocked("No");
				aFindResult.setContents(aNameAttribute.getObjective());
				aFindResult.setId(aNameAttribute.getId());
				results.add(aFindResult);
			}

		} catch (Exception e) {
			logger.error("***DMPDAO error:  " + e.getMessage());
			throw new DAOException(e.getMessage(), e);
		}
		return results;
	}

	@SuppressWarnings("unchecked")
	public List<DMPFindResults> findTermInDMPContent(
			DMPFindReplaceCriteria criteria) throws DAOException {
		List<DMPFindResults> results = new ArrayList<DMPFindResults>();

		try {
			String findTerm = criteria.getFindTerm();
			findTerm = findTerm.replaceAll("_", "[_]");
			findTerm = findTerm.replaceAll("%", "[%]");
			findTerm = findTerm.replaceAll("\\[", "[[]");
			String contentQuery = "select l from "
					+ FindDMPContent.class.getName()
					+ " l where l.content like concat('%',:findTerm,'%')"
					+ " order by l.findDMPAttributes.name asc";
			Map<String,Object> params = new HashMap<String,Object>();
			params.put("findTerm", findTerm);
			List<FindDMPContent> contentAttributes = getJpaTemplate().findByNamedParams(contentQuery, params);	
			for (FindDMPContent aContentAttribute : contentAttributes) {
				DMPFindResults aFindResult = new DMPFindResults();
				aFindResult.setDmpName(aContentAttribute.getFindDMPAttributes()
						.getName());
				aFindResult.setDmpTag(aContentAttribute.getFindDMPAttributes()
						.getTag());
				aFindResult.setFindLocation("DMP Content");
				aFindResult.setDmpFacilitator(aContentAttribute
						.getFindDMPAttributes().getFacilitator());
				if (aContentAttribute.getLocked()) {
					aFindResult.setLocked("Yes");
				} else if (!aContentAttribute.getLocked()) {
					aFindResult.setLocked("No");
				}
				aFindResult.setContents(aContentAttribute.getContent());
				aFindResult.setId(aContentAttribute.getId());
				results.add(aFindResult);
			}

		} catch (Exception e) {
			logger.error("***DMPDAO error:  " + e.getMessage());
			throw new DAOException(e.getMessage(), e);
		}
		return results;
	}

	@SuppressWarnings("unchecked")
	public List<DMPFindResults> findTermInDMPResponses(
			DMPFindReplaceCriteria criteria) throws DAOException {
		List<DMPFindResults> results = new ArrayList<DMPFindResults>();

		try {
			String findTerm = criteria.getFindTerm();
			findTerm = findTerm.replaceAll("_", "[_]");
			findTerm = findTerm.replaceAll("%", "[%]");
			findTerm = findTerm.replaceAll("\\[", "[[]");
			String responseContentQuery = "select l from "
					+ FindDMPResponseContent.class.getName()
					+ " l where l.responseContent like concat('%',:findTerm,'%')"
					+ " order by l.findDMPContent.findDMPAttributes.name asc";
			Map<String,Object> contentParams = new HashMap<String,Object>();
			contentParams.put("findTerm", findTerm);
			List<FindDMPResponseContent> responseContentAttributes = getJpaTemplate().findByNamedParams(responseContentQuery, contentParams);
			for (FindDMPResponseContent aResponseContentAttribute : responseContentAttributes) {
				DMPFindResults aFindResult = new DMPFindResults();
				aFindResult.setDmpName(aResponseContentAttribute
						.getFindDMPContent().getFindDMPAttributes().getName());
				aFindResult.setDmpTag(aResponseContentAttribute
						.getFindDMPContent().getFindDMPAttributes().getTag());
				aFindResult.setFindLocation("DMP Response Content");
				aFindResult.setDmpFacilitator(aResponseContentAttribute
						.getFindDMPContent().getFindDMPAttributes()
						.getFacilitator());
				if (aResponseContentAttribute.getFindDMPContent().getLocked()) {
					aFindResult.setLocked("Yes");
				} else if (!aResponseContentAttribute.getFindDMPContent()
						.getLocked()) {
					aFindResult.setLocked("No");
				}
				aFindResult.setContents(aResponseContentAttribute
						.getResponseContent());
				aFindResult.setId(aResponseContentAttribute.getId());
				results.add(aFindResult);
			}

			String eduContentQuery = "select l from "
					+ FindDMPResponseContent.class.getName()
					+ " l where l.eduContent like concat('%',:findTerm,'%')"
					+ " order by l.findDMPContent.findDMPAttributes.name asc";
			Map<String,Object> eduContentParams = new HashMap<String,Object>();
			eduContentParams.put("findTerm", findTerm);
			List<FindDMPResponseContent> eduContentAttributes = getJpaTemplate().findByNamedParams(eduContentQuery, eduContentParams);	
			for (FindDMPResponseContent aResponseContentAttribute : eduContentAttributes) {
				DMPFindResults aFindResult = new DMPFindResults();
				aFindResult.setDmpName(aResponseContentAttribute
						.getFindDMPContent().getFindDMPAttributes().getName());
				aFindResult.setDmpTag(aResponseContentAttribute
						.getFindDMPContent().getFindDMPAttributes().getTag());
				aFindResult.setFindLocation("DMP Response Educational Content");
				aFindResult.setDmpFacilitator(aResponseContentAttribute
						.getFindDMPContent().getFindDMPAttributes()
						.getFacilitator());
				if (aResponseContentAttribute.getFindDMPContent().getLocked()) {
					aFindResult.setLocked("Yes");
				} else if (!aResponseContentAttribute.getFindDMPContent()
						.getLocked()) {
					aFindResult.setLocked("No");
				}
				aFindResult.setContents(aResponseContentAttribute
						.getEduContent());
				aFindResult.setId(aResponseContentAttribute.getId());
				results.add(aFindResult);
			}
			String viContentQuery = "select l from "
					+ FindDMPResponseContent.class.getName()
					+ " l where l.vendorInstContent like concat('%',:findTerm,'%')"
					+ " order by l.findDMPContent.findDMPAttributes.name asc";
			Map<String,Object> viContentParams = new HashMap<String,Object>();
			viContentParams.put("findTerm", findTerm);
			List<FindDMPResponseContent> viContentAttributes = getJpaTemplate().findByNamedParams(viContentQuery, viContentParams);	
			for (FindDMPResponseContent aResponseContentAttribute : viContentAttributes) {
				DMPFindResults aFindResult = new DMPFindResults();
				aFindResult.setDmpName(aResponseContentAttribute
						.getFindDMPContent().getFindDMPAttributes().getName());
				aFindResult.setDmpTag(aResponseContentAttribute
						.getFindDMPContent().getFindDMPAttributes().getTag());
				aFindResult.setFindLocation("DMP Response Vendor Instruction");
				aFindResult.setDmpFacilitator(aResponseContentAttribute
						.getFindDMPContent().getFindDMPAttributes()
						.getFacilitator());
				if (aResponseContentAttribute.getFindDMPContent().getLocked()) {
					aFindResult.setLocked("Yes");
				} else if (!aResponseContentAttribute.getFindDMPContent()
						.getLocked()) {
					aFindResult.setLocked("No");
				}
				aFindResult.setContents(aResponseContentAttribute
						.getVendorInstContent());
				aFindResult.setId(aResponseContentAttribute.getId());
				results.add(aFindResult);
			}

		} catch (Exception e) {
			logger.error("***DMPDAO error:  " + e.getMessage());
			throw new DAOException(e.getMessage(), e);
		}
		return results;
	}

	@SuppressWarnings("unchecked")
	public List<DMP> getAllMyCreatedDmps(String userId) throws DAOException {
		List<DMP> results = new ArrayList<DMP>();
		try {

			StringBuilder qString = new StringBuilder();
			qString
					.append("select dmp.dmp_id, dmp.name,dmp.dmp_tag,dmp.description, dmp.status_type_id, (isnull(u.last_name,'') + ', ' + isnull(u.first_name,'')+' ' + isnull(u.middle_name,'')) as modifyBy, dmp.record_modified_date ");
			qString
					.append("from dmp.dmp dmp LEFT OUTER JOIN ht.app_user u ON u.user_name = dmp.record_modified_by where dmp.record_created_by = '"
							+ userId + "' order by dmp.name asc");

			QueryAndParams queryAndParams = new QueryAndParams(qString
					.toString());

			List dmpList = executeSQLQuery(queryAndParams);
			for (int i = 0; i < dmpList.size(); i++) {
				Object[] objs = (Object[]) dmpList.get(i);
				// DMPToolUser toolUser = new DMPToolUser();
				DMP DMPObject = new DMP();
				DMPObject.setId(new BigInteger(objs[0].toString()).longValue());
				DMPObject.setName((String) objs[1]);
				DMPObject.setTag((String) objs[2]);
				DMPObject.setDescription((String) objs[3]);
				String status = (String) objs[4].toString();
				DMPObject.setModifiedByName((String) objs[5]);
				Timestamp timestamp = (Timestamp) objs[6];
				Date modified = TimeZoneUtils.convertUTCDateToSpecifiedTimeZone(new Date(timestamp.getTime()), TimeZone.getDefault());
				DMPObject.setModifiedOn(modified);
				//DMPObject.setModifiedOn(new Date(timestamp.getTime()));
				DMPStatusType statusType = new DMPStatusType();

				qString = new StringBuilder();
				qString.append("select code, name from dmp.DMP_STATUS_TYPE where id = "
						+  " '" + status + "' ");
				queryAndParams = new QueryAndParams(qString.toString());

				List statusList = executeSQLQuery(queryAndParams);
				for (int j = 0; j < statusList.size(); j++) {
					Object[] statusSearch = (Object[]) statusList.get(j);
					if (statusSearch != null) {
						statusType.setCode((String) statusSearch[0]);
						statusType.setName((String) statusSearch[1]);
					}
				}
			/*
				if (status.equalsIgnoreCase("20001")) {
					statusType.setCode("1");
					statusType.setName("Draft");
				} else if (status.equalsIgnoreCase("20002")) {
					statusType.setCode("2");
					statusType.setName("Nationally Released");
				}
				*/
				DMPObject.setDmpStatusType(statusType);
				
				////// fchen 11/14/12: get assignees for each dmp //////
				//put in place holder here to avoid null pointer exception, the assignee and question data are retrieved from other sql statements
				if (DMPObject.getAssignees() == null) DMPObject.setAssignees(new HashSet<DMPToolUser>());
				if (DMPObject.getQuestions() == null) DMPObject.setQuestions(new HashSet<DMPQuestion>());
				////// end of fchen's change //////
				//dmpIds.add(DMPObject.getId());
				results.add(DMPObject);
			}
			//// set hasCommends field for each DMP object /////////////////////////
			this.setHasComments(results);
			//////////////end of change/////////////////////
			return results;

		} catch (Exception e) {
			throw new DAOException(e.getMessage(), e);
		}
	}
	@SuppressWarnings("unchecked")
	public List<DMPStandLibEntry> getAllStandardLibs() throws DAOException {
		try {
			String query = "select l from " + DMPStandLibEntry.class.getName()
					+ " l order by l.slCategoryType.name, l.slContentType.name asc";
			List<DMPStandLibEntry> list = getJpaTemplate().findByNamedParams(query,
					null);
				return list;
		} catch (Exception e) {
			throw new DAOException("getAllStandardLibs failed", e);
		}
	}

	@SuppressWarnings("unchecked")
	public List<DMPToolUser> getAllMyAssigedDmps(String userId) throws DAOException {
		List<DMPToolUser> results = new ArrayList<DMPToolUser>();
		//List<Long> dmpIds = new ArrayList<Long>();
		try {
			StringBuilder qString = new StringBuilder();
			qString.append("select dmp.dmp_id, dmp.name,dmp.dmp_tag,dmp.description, dmp.status_type_id, (isnull(u.last_name,'') + ', ' + isnull(u.first_name,'')+' ' + isnull(u.middle_name,'')) as modifyBy, dmp.record_modified_date ");
			qString.append("from dmp.dmp dmp LEFT OUTER JOIN ht.app_user u ON u.user_name = dmp.record_modified_by, ");
			qString.append("dmp.dmp_tool_user dtu, ht.app_user au where dmp.dmp_id = dtu.dmp_id and dtu.app_user_id = au.app_user_id and au.user_name = '"
							+ userId + " ' and (dtu.assigned_ind = 1 or dtu.reviewer_ind = 1)" + " order by dmp.name asc");
			QueryAndParams queryAndParams = new QueryAndParams(qString.toString());

			List dmpList = executeSQLQuery(queryAndParams);
			for (int i = 0; i < dmpList.size(); i++) {
				Object[] objs = (Object[]) dmpList.get(i);
				DMPToolUser toolUser = new DMPToolUser();
				DMP DMPObject = new DMP();
				DMPObject.setId(new BigInteger(objs[0].toString()).longValue());
				DMPObject.setName((String) objs[1]);
				DMPObject.setTag((String) objs[2]);
				DMPObject.setDescription((String) objs[3]);
				String status = (String) objs[4].toString();
				DMPObject.setModifiedByName((String) objs[5]);
				Timestamp timestamp = (Timestamp) objs[6];
				Date modified = TimeZoneUtils.convertUTCDateToSpecifiedTimeZone(new Date(timestamp.getTime()), TimeZone.getDefault());
				DMPObject.setModifiedOn(modified);
				//DMPObject.setModifiedOn(new Date(timestamp.getTime()));
				DMPStatusType statusType = new DMPStatusType();

				qString = new StringBuilder();
				qString.append("select code, name from dmp.DMP_STATUS_TYPE where id = "
						+  " '" + status + "' ");
				queryAndParams = new QueryAndParams(qString.toString());

				List statusList = executeSQLQuery(queryAndParams);
				for (int j = 0; j < statusList.size(); j++) {
					Object[] statusSearch = (Object[]) statusList.get(j);
					if (statusSearch != null) {
						statusType.setCode((String) statusSearch[0]);
						statusType.setName((String) statusSearch[1]);
					}
				}

		/*		if (status.equalsIgnoreCase("20001")) {
					statusType.setCode("1");
					statusType.setName("Draft");
				} else if (status.equalsIgnoreCase("20002")) {
					statusType.setCode("2");
					statusType.setName("Nationally Released");
				}
				*/
				DMPObject.setDmpStatusType(statusType);
				/////// fchen 11/14/12: get assignees for each dmp ///////
				//put in place holder here to avoid null pointer exception, the assignee and question data are retrieved from other sql statements
				if (DMPObject.getAssignees() == null) DMPObject.setAssignees(new HashSet<DMPToolUser>());
				if (DMPObject.getQuestions() == null) DMPObject.setQuestions(new HashSet<DMPQuestion>());
				////// end of fchen's change //////
				//to set hasComment field

				toolUser.setDmp(DMPObject);
				//this.setDMPReviewers(toolUser.getDmp());
				//dmpIds.add(DMPObject.getId());
				results.add(toolUser);
			}
			//// set hasCommends field for each DMP object /////////////////////////
			this.setHasComments(results);
			//////////////end of change/////////////////////
			return results;
		} catch (Exception e) {
			throw new DAOException("getDMPById failed", e);
		}

	}
	public DMPReview saveDMPReview(
			DMPReview dmpReview) throws DAOException {
		try {

			StringBuilder qString = new StringBuilder();
			QueryAndParams queryAndParams = new QueryAndParams();
			qString = new StringBuilder();
			qString.append("select dtu.dmp_tool_user_id, au.app_user_id from dmp.dmp_Tool_user dtu, ht.APP_USER au where dtu.dmp_id = "
					+ dmpReview.getDmpId() + " and dtu.app_user_id = au.app_user_id and au.user_name = '" + dmpReview.getDmpToolUserId() + "'");
			queryAndParams = new QueryAndParams(qString.toString());

			List<?> dmpToolUserList = executeSQLQuery(queryAndParams);
			for (int j = 0; j < dmpToolUserList.size(); j++) {
				Object[] dmpToolUser = (Object[]) dmpToolUserList.get(j);
				if (dmpToolUser != null) {
					dmpReview.setDmpToolUserId(String.valueOf(dmpToolUser[0]));
				}
			}

			qString = new StringBuilder();
			qString.append("select id, code from dmp.dmp_status_type where code = "
					+ dmpReview.getDmpReviewStatusTypeId());
			queryAndParams = new QueryAndParams(qString.toString());

			List<?> dmpStatusTypeList = executeSQLQuery(queryAndParams);
			for (int j = 0; j < dmpStatusTypeList.size(); j++) {
				Object[] dmpStatusType = (Object[]) dmpStatusTypeList.get(j);
				if (dmpStatusType != null) {
					dmpReview.setDmpReviewStatusTypeId(String.valueOf(dmpStatusType[0]));
				}
			}
			DMPReview entity = this.getJpaTemplate().find(DMPReview.class, dmpReview.getId());
			if (entity != null) {
				entity.setDmpToolUserId(dmpReview.getDmpToolUserId());
				entity.setDmpId(dmpReview.getDmpId());
				entity.setDmpContentId(dmpReview.getDmpContentId());
				entity.setDmpReviewStatusTypeId(dmpReview.getDmpReviewStatusTypeId());
				entity.setReviewDate(dmpReview.getReviewDate());
				entity.setDmpVersion(dmpReview.getDmpVersion());
				entity.setContentComment(dmpReview.getContentComment());
				
				entity.setFreqencyComment(dmpReview.getFreqencyComment());
				entity.setRespTypeComment(dmpReview.getRespTypeComment());
				entity.setRespContentComment(dmpReview.getRespContentComment());
				entity.setRespAlertComment(dmpReview.getRespAlertComment());
				entity.setRespBranchComment(dmpReview.getRespBranchComment());
				entity.setRespEduComment(dmpReview.getRespEduComment());
				entity.setRespVIComment(dmpReview.getRespVIComment());
			}
			else {
				entity = dmpReview;
			}
			DMPReview persisted = (DMPReview) super.getJpaTemplate().merge(entity);
			//super.getJpaTemplate().persist(dmpReview);
			super.getJpaTemplate().flush();
			return persisted;
			//return dmpReview;
		} catch (Exception e) {
			throw new DAOException(e.getMessage(), e);
		}

	}
	
	public DMPReview deleteDMPReview(DMPReview dmpReview) throws DAOException {
		try {
			DMPReview entity = this.getJpaTemplate().find(DMPReview.class, dmpReview.getId());
			if (entity != null) {
				this.getJpaTemplate().remove(entity);
			}
			else {
				throw new Exception ("Comments with ID " + dmpReview.getId().toString() + "does not exist.");
			}
		} catch (Exception e) {
			throw new DAOException(e.getMessage(), e);
		}
		return dmpReview;
	}
	
	@SuppressWarnings("unchecked")
	private DMPToolUser saveDMPToolUser2(DMPToolUser assignee, boolean isAssignDMP) throws DAOException {
		try {
			boolean assignedInd = assignee.isAssigned();
			boolean isAssignedInd = assignee.getIsAssigned();
			boolean reviewerInd = assignee.isReviewer();
			StringBuilder qString = new StringBuilder();
			QueryAndParams queryAndParams = new QueryAndParams();
			qString = new StringBuilder();
			String columnToFetch = isAssignDMP ? "dtu.reviewer_ind" : "dtu.assigned_ind";
			
			qString.append("select dtu.dmp_tool_user_id, " +  columnToFetch + ", au.app_user_id from dmp.dmp_Tool_user dtu, ht.APP_USER au where dtu.dmp_id = "
					+ assignee.getDmp().getId() + " and dtu.app_user_id = au.app_user_id and au.user_name = '" + assignee.getAppUser().getUsername() + "'");
			queryAndParams = new QueryAndParams(qString.toString());

			List dmpToolUserList = executeSQLQuery(queryAndParams);
			for (int j = 0; j < dmpToolUserList.size(); j++) {
				Object[] dmpToolUser = (Object[]) dmpToolUserList.get(j);
				if (dmpToolUser != null) {
					assignee.setId(Long.valueOf(String.valueOf(dmpToolUser[0])));
					boolean booleanVal = Boolean.valueOf(String.valueOf(dmpToolUser[1])).booleanValue();
					if (isAssignDMP) {
						reviewerInd = booleanVal;
					}
					else {
						assignedInd = booleanVal;
						isAssignedInd = booleanVal;
					}
				}
			}
			
			List dmpToolUserList2 = findDMPToolUsers(assignee.getDmp().getId().toString());
			super.getJpaTemplate().flush();
			for (int j = 0; j < dmpToolUserList2.size(); j++) {
				DMPToolUser dmpToolUser = (DMPToolUser) dmpToolUserList2.get(j);
				if (dmpToolUser != null && assignee.getId() != null) {
					if (assignee.getId().equals(dmpToolUser.getId()))
					{
						assignee = dmpToolUser;
						assignee.setAssigned(assignedInd);
						assignee.setIsAssigned(isAssignedInd);
						assignee.setReviewer(reviewerInd);
						break;
					}
				}
			}
			DMPToolUser persisted2 = (DMPToolUser) super.getJpaTemplate().merge(assignee);
			super.getJpaTemplate().flush();
			return persisted2;
		} catch (Exception e) {
			throw new DAOException(e.getMessage(), e);
		}	
	}
	@SuppressWarnings("unchecked")
	public List<DMPReview> getDMPQuestionComments(String dmpId, String dmpContentId ) throws DAOException {
		try {
			String query = "select l from " + DMPReview.class.getName()
					+ " l  where l.dmpId = :dmpId and l.dmpContentId = :dmpContentId";
			
			Map map = new HashMap();
			map.put("dmpId", Integer.parseInt(dmpId));
			map.put("dmpContentId", dmpContentId);
			List<?> list = getJpaTemplate().findByNamedParams(query,map);
			
			for (int j = 0; j < list.size(); j++) {
				DMPReview dmpReview = (DMPReview) list.get(j);
				if (dmpReview != null ) {
					StringBuilder qString = new StringBuilder();
					QueryAndParams queryAndParams = new QueryAndParams();
					qString = new StringBuilder();
					qString.append("select isnull(u.last_name,'') + ', ' + isnull(u.first_name,'')+' ' + isnull(u.middle_name,'') from ht.app_user u where u.user_name = '" 
							+ dmpReview.getCreatedBy().getChangeUser() + "' ");
					queryAndParams = new QueryAndParams(qString.toString());

					List dmpList2 = executeSQLQuery(queryAndParams);
					for (int k = 0; k < dmpList2.size(); k++) {
						if (dmpList2.get(k) != null) {
							dmpReview.setCreatedByName((String) dmpList2.get(k));
							break;
						} 
					}

				}
			}
				return (List<DMPReview>)list;
		} catch (Exception e) {
			throw new DAOException("getDMPQuestionComments failed", e);
		}
	}
	
	@SuppressWarnings("unchecked")
	public List<DMPToolUser> findDMPReviewers(String dmpId) throws DAOException {

		try {
			String query = "select l from " + DMPToolUser.class.getName() + " l where l.dmp.id = " + dmpId + " and  l.reviewer = true";
			return getJpaTemplate().find(query);
		} catch (Exception e) {
			throw new DAOException("findDMPReviewers failed", e);
		}
	}

	@SuppressWarnings("unchecked")
	private TreeSet<String> getDMPComments(List entityList) throws DAOException {
		if (entityList == null || entityList.size() == 0) return null;
		TreeSet<String> dmpCommentSet = new TreeSet<String>();
		try {
			StringBuilder idString = new StringBuilder();
			Object entity;
			Long id = new Long(0);
			for (int i = 0; i < entityList.size(); i++) {
				entity = entityList.get(i);
				if (entity instanceof DMP) id = ((DMP)entity).getId();
				if (entity instanceof DMPToolUser) id = ((DMPToolUser)entity).getDmp().getId();
				if (entity instanceof DMPSearch) id = ((DMPSearch)entity).getId();
				idString.append(String.valueOf(id));
				if (i < (entityList.size() - 1)) idString.append(",");
			}
			StringBuilder qString = new StringBuilder();
			qString.append("select distinct dmp_id from dmp.DMP_REVIEW where dmp_id in (" + idString.toString() + ")");
			QueryAndParams queryAndParams = new QueryAndParams(qString.toString());
			List commentsList = executeSQLQuery(queryAndParams);
			if (commentsList != null && commentsList.size() > 0) {
				for (Object o : commentsList) {
					String v = String.valueOf(o);
					dmpCommentSet.add(v);
				}
			}
		} catch (Exception e) {
			throw new DAOException("dmpHasComments failed", e);
		}
		return dmpCommentSet;
	}
	
	@SuppressWarnings("unchecked")
	private void setHasComments(List dmpList) throws DAOException {
		try {
			Set<String> dmpCommentSet = this.getDMPComments(dmpList);
			for (int i = 0; i < dmpList.size(); i++) {
				Object entity = dmpList.get(i);
				String id = null;
				if (entity instanceof DMP) id = String.valueOf(((DMP)entity).getId());
				if (entity instanceof DMPToolUser) id = String.valueOf(((DMPToolUser)entity).getDmp().getId());
				if (entity instanceof DMPSearch) id = String.valueOf(((DMPSearch)entity).getId());
				if (dmpCommentSet.contains(id)) {
					if (entity instanceof DMP) ((DMP)entity).setHasComments(true);
					if (entity instanceof DMPToolUser) ((DMPToolUser)entity).getDmp().setHasComments(true);
					if (entity instanceof DMPSearch) ((DMPSearch)entity).setHasComments(true);
				}
				else {
					if (entity instanceof DMP) ((DMP)entity).setHasComments(false);
					if (entity instanceof DMPToolUser) ((DMPToolUser)entity).getDmp().setHasComments(false);
					if (entity instanceof DMPSearch) ((DMPSearch)entity).setHasComments(false);
				}
			}
				
		} catch (Exception e) {
			throw new DAOException("setDMPHasComments failed", e);
		}
	}
	
	
	public void updateDmpQuestionsLockStatus(List<Long> questionIds, Integer lockDmpContent) throws DAOException
	{
		StringBuilder  qString = new StringBuilder();
		
		qString.append("update dmp.DMP_CONTENT set LOCK_DMP_CONTENT = :lockDmpContent where DMP_CONTENT_ID in (:dmpContentIds)");
		
		try
		{
			QueryAndParams queryAndParams = new QueryAndParams(qString.toString());
			queryAndParams.addParam("lockDmpContent", lockDmpContent);
			queryAndParams.addParam("dmpContentIds", questionIds);
						
			executeSQLUpdate(queryAndParams);			
		}
		catch(Exception e)
		{
			throw new DAOException("updateDmpQuestionsLockStatus failed " + e);
		}
		
	}
	
	public int executeSQLUpdate(final QueryAndParams queryAndParams) throws DAOException {
		int results = 0;
		try {
			JpaCallback callback = new AbstractDAOAction() {
				public Object execute(EntityManager entityManager) {
					String queryString = queryAndParams.getQuery();
					Query query = entityManager.createNativeQuery(queryString);
					setQueryParameters(query, queryAndParams.getParams());
					return query.executeUpdate();					
				}
			};
			
			Object r = getJpaTemplate().execute(callback);			
			
			if(r != null && r instanceof Integer)
			{
				results = (Integer)r;
			}
			
		} catch (DataAccessException e) {
			throw new DAOException("Failed to execute an sql query:" + queryAndParams.getQuery(), e.getMostSpecificCause());
		}

		return results;
	}


	//build reviewer set in dmp
	/*
	private void setDMPReviewers(DMP dmp) {
		if (dmp != null) {
			HashSet reviewers = new HashSet();
			if (dmp.getAssignees().size() > 0) {
				for (DMPToolUser dmpToolUser : new ArrayList<DMPToolUser>(dmp.getAssignees())) {
					if (dmpToolUser.isReviewer()) {
						reviewers.add(dmpToolUser);
					}
				}
				dmp.setReviewers(reviewers);
			}
		}
	}
	*/
}
