package gov.va.med.ccht.persistent.hibernate;


import gov.va.med.ccht.model.car.CensusActivityRecord;
import gov.va.med.ccht.model.car.CensusActivityReportParameters;
import gov.va.med.ccht.model.car.CensusActivityReportResult;
import gov.va.med.ccht.model.car.CensusActivitySubTotalRecord;
import gov.va.med.ccht.persistent.CensusActivityReportDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import gov.va.med.fw.persistent.hibernate.QueryAndParams;
import gov.va.med.fw.ui.model.TermType;
import gov.va.med.fw.util.DateUtils;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class CensusActivityReportDAOImpl extends GenericDAOImpl implements
		CensusActivityReportDAO {

	public final static String TOTAL_PATIENTS = "Total Patients";
	public final static String MESSAGING_TOTAL = "Messaging Total";
	public final static String MESSAGING_BY_DEVICE = "Messaging By Device";
	public final static String MESSAGING_BY_IVR = "Messaging By IVR";
	public final static String MESSAGING_BY_BROWSER = "Messaging By Browser";
	public final static String MESSAGING_UNKOWN = "Messaging (IVR, device, or browser not yet assigned)";
	public final static String PERIPHERAL_MEASUREMENTS = "Peripheral Measurements";
	public final static String VIDEO = "Video";
	public final static String CELLULAR_MODEM_TRANSMISSION = "Cellular Modem Transmission";
	public final static String SATELLITE_TRANSMISSION = "Satellite Transmission";
	public final static String DIGITAL_IMAGE_CAPTURE = "Digital Image Capture";
	
	final int total_patients = 1;
	final int messaging_total = 2;
	final int device = 3;
	final int ivr = 4;
	final int browser = 5;
	final int unknown = 6;
	final int measurements = 7;
	final int video = 8;
	final int cell = 9;
	final int satellite = 10;
	final int digital = 11;
	
	public CensusActivityRecord getLastReportWeek() throws DAOException
	{
		CensusActivityRecord lastReportWeekActivityRecord = new CensusActivityRecord();
		List<TermType> dates = new ArrayList<TermType>();
		String sql = "SELECT DISTINCT Rpt_Wk,CONVERT(varchar,Rpt_wk,101) AS [StrDate] FROM facility_activity ORDER BY Rpt_Wk DESC";
		QueryAndParams queryAndParams = new QueryAndParams();
		queryAndParams.append(sql);		
		
		List<?> report = executeSQLQuery(queryAndParams);
		int numIterations = report.size();
		
		for (int j = 0; j < numIterations; j++)
		{
			Object[] record = (Object[]) report.get(j);
			String dateAsString = (String)record[1];
			TermType date = new TermType();
			date.setLabel(dateAsString);
			date.setValue(dateAsString);
			dates.add(date);
		}
		lastReportWeekActivityRecord.setReportWeek(dates);
	
		return lastReportWeekActivityRecord;
	}

	@Override
	public void getFacilityReport(CensusActivityReportParameters reportParams)
			throws DAOException {
		// TODO Auto-generated method stub
		System.out.println("IN DAO getFacilityReport!");
		
	}

	@Override
	public List<CensusActivityRecord> getNationalReport(CensusActivityReportParameters reportParams)
			throws DAOException 
	{
		List<CensusActivityRecord> returnResults = new ArrayList<CensusActivityRecord>();
		String sql = getNationalSQL();		
		String weekEndingDate = DateUtils.format(reportParams.getWeekEndingDate(), DateUtils.MMDDYYYY);
		QueryAndParams queryAndParams = new QueryAndParams();
		queryAndParams.append(sql);		
		queryAndParams.addParam("weekEndingDate", weekEndingDate);

		List<?> report = executeSQLQuery(queryAndParams);
		int numIterations = report.size();
		
		for (int j = 0; j < numIterations; j++)
		{
			Object[] record = (Object[]) report.get(j);

			
			
			CensusActivityRecord tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Total Patients");
			tempRecord.setTotal((Integer)record[1]);			
			tempRecord.setNationalTotal((Integer)record[1]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Messaging Total");
			tempRecord.setTotal((Integer)record[2]);			
			tempRecord.setNationalTotal((Integer)record[2]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Messaging By Device");
			tempRecord.setTotal((Integer)record[3]);			
			tempRecord.setNationalTotal((Integer)record[3]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Messaging By IVR");
			tempRecord.setTotal((Integer)record[4]);			
			tempRecord.setNationalTotal((Integer)record[4]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Messaging By Browser");
			tempRecord.setTotal((Integer)record[5]);			
			tempRecord.setNationalTotal((Integer)record[5]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Messaging (IVR, device or browser not yet assigned)");
			tempRecord.setTotal((Integer)record[6]);			
			tempRecord.setNationalTotal((Integer)record[6]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Peripheral Measurements");
			tempRecord.setTotal((Integer)record[7]);			
			tempRecord.setNationalTotal((Integer)record[7]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Video");
			tempRecord.setTotal((Integer)record[8]);			
			tempRecord.setNationalTotal((Integer)record[8]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Cellular Modem Transmission");
			tempRecord.setTotal((Integer)record[9]);			
			tempRecord.setNationalTotal((Integer)record[9]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Satellite Transmission");
			tempRecord.setTotal((Integer)record[10]);			
			tempRecord.setNationalTotal((Integer)record[10]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Digital Image Capture");
			tempRecord.setTotal((Integer)record[11]);			
			tempRecord.setNationalTotal((Integer)record[11]);
			returnResults.add(tempRecord);
		}
		return returnResults;
	}
	
	@Override
	public List<CensusActivityRecord> getNationalReportByVendor(CensusActivityReportParameters reportParams)
			throws DAOException 
	{
		List<CensusActivityRecord> returnResults = new ArrayList<CensusActivityRecord>();
		String sql = getNationalSQLByVendor(reportParams.getVendor());		
		String weekEndingDate = DateUtils.format(reportParams.getWeekEndingDate(), DateUtils.MMDDYYYY);
		QueryAndParams queryAndParams = new QueryAndParams();
		queryAndParams.append(sql);		
		queryAndParams.addParam("weekEndingDate", weekEndingDate);
		queryAndParams.addParam("vendorNumber", reportParams.getVendor().getValue());

		List<?> report = executeSQLQuery(queryAndParams);
		int numIterations = report.size();
		
		for (int j = 0; j < numIterations; j++)
		{
			Object[] record = (Object[]) report.get(j);

			
			
			CensusActivityRecord tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Total Patients");
			tempRecord.setTotal((Integer)record[1]);			
			tempRecord.setNationalTotal((Integer)record[1]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Messaging Total");
			tempRecord.setTotal((Integer)record[2]);			
			tempRecord.setNationalTotal((Integer)record[2]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Messaging By Device");
			tempRecord.setTotal((Integer)record[3]);			
			tempRecord.setNationalTotal((Integer)record[3]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Messaging By IVR");
			tempRecord.setTotal((Integer)record[4]);			
			tempRecord.setNationalTotal((Integer)record[4]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Messaging By Browser");
			tempRecord.setTotal((Integer)record[5]);			
			tempRecord.setNationalTotal((Integer)record[5]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Messaging (IVR, device or browser not yet assigned)");
			tempRecord.setTotal((Integer)record[6]);			
			tempRecord.setNationalTotal((Integer)record[6]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Peripheral Measurements");
			tempRecord.setTotal((Integer)record[7]);			
			tempRecord.setNationalTotal((Integer)record[7]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Video");
			tempRecord.setTotal((Integer)record[8]);			
			tempRecord.setNationalTotal((Integer)record[8]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Cellular Modem Transmission");
			tempRecord.setTotal((Integer)record[9]);			
			tempRecord.setNationalTotal((Integer)record[9]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Satellite Transmission");
			tempRecord.setTotal((Integer)record[10]);			
			tempRecord.setNationalTotal((Integer)record[10]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Digital Image Capture");
			tempRecord.setTotal((Integer)record[11]);			
			tempRecord.setNationalTotal((Integer)record[11]);
			returnResults.add(tempRecord);
		}
		return returnResults;
	}
	
	public List<CensusActivityRecord> getNationalReportByModality(CensusActivityReportParameters reportParams) throws DAOException
	{
		List<CensusActivityRecord> returnResults = new ArrayList<CensusActivityRecord>();
		
		String sql = getNationalSQLByModality(reportParams);	
		String weekEndingDate = DateUtils.format(reportParams.getWeekEndingDate(), DateUtils.MMDDYYYY);
		QueryAndParams queryAndParams = new QueryAndParams();
		queryAndParams.append(sql);		
		queryAndParams.addParam("weekEndingDate", weekEndingDate);

		List<?> report = executeSQLQuery(queryAndParams);
		int numIterations = report.size();
		
		for (int j = 0; j < numIterations; j++)
		{
			Object[] record = (Object[]) report.get(j);
			
			CensusActivityRecord tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Total Patients");
			tempRecord.setTotal((Integer)record[1]);			
			tempRecord.setNationalTotal((Integer)record[1]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName(reportParams.getModality().getValue());
			tempRecord.setTotal((Integer)record[2]);			
			tempRecord.setNationalTotal((Integer)record[2]);
			returnResults.add(tempRecord);
		}
		
		
		return returnResults;
	}
	
	public List<CensusActivityRecord> getNationalReportByModalityAndVendor(CensusActivityReportParameters reportParams) throws DAOException
	{
		List<CensusActivityRecord> returnResults = new ArrayList<CensusActivityRecord>();
		
		String sql = getNationalSQLByModalityAndVendor(reportParams);	
		String weekEndingDate = DateUtils.format(reportParams.getWeekEndingDate(), DateUtils.MMDDYYYY);
		QueryAndParams queryAndParams = new QueryAndParams();
		queryAndParams.append(sql);		
		queryAndParams.addParam("weekEndingDate", weekEndingDate);
		queryAndParams.addParam("vendorNumber", reportParams.getVendor().getValue());

		List<?> report = executeSQLQuery(queryAndParams);
		int numIterations = report.size();
		
		for (int j = 0; j < numIterations; j++)
		{
			Object[] record = (Object[]) report.get(j);
			
			CensusActivityRecord tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName("Total Patients");
			tempRecord.setTotal((Integer)record[1]);			
			tempRecord.setNationalTotal((Integer)record[1]);
			returnResults.add(tempRecord);
			
			tempRecord = new CensusActivityRecord();
			tempRecord.setModalityName(reportParams.getModality().getValue());
			tempRecord.setTotal((Integer)record[2]);			
			tempRecord.setNationalTotal((Integer)record[2]);
			returnResults.add(tempRecord);
		}
		
		
		return returnResults;
	}
		
	private CensusActivityReportResult getCurrentRecord(Object[] record)
	{
		CensusActivityReportResult currentRecord = new CensusActivityReportResult();
		
		currentRecord.setNationalTotalsTitle((String)record[0]);
		currentRecord.setTotalPatients((Integer)record[1]);
		currentRecord.setMessagingTotal((Integer)record[2]);
		currentRecord.setMessagingByDevice((Integer)record[3]);
		currentRecord.setMessagingByIVR((Integer)record[4]);
		currentRecord.setMessagingByBrowser((Integer)record[5]);
		currentRecord.setMessagingByNotYetAssigned((Integer)record[6]);
		currentRecord.setPeripheralMeasurements((Integer)record[7]);
		currentRecord.setVideoTotal((Integer)record[8]);
		currentRecord.setCellularModemTransmission((Integer)record[9]);
		currentRecord.setSatelliteTransmission((Integer)record[10]);
		currentRecord.setDigitalImageCapture((Integer)record[11]);
		return currentRecord;
	}

	private CensusActivityReportResult getCurrentModalityRecord(Object[] record)
	{
		CensusActivityReportResult currentRecord = new CensusActivityReportResult();
		
		currentRecord.setNationalTotalsTitle((String)record[0]);
		currentRecord.setTotalPatients((Integer)record[1]);
		currentRecord.setTotalForSelectedModality((Integer)record[2]);
		
		return currentRecord;
	}
	
	@Override	
	public void getVisnReport(CensusActivityReportParameters reportParams)
			throws DAOException {
		// TODO Auto-generated method stub
		System.out.println("IN DAO getVisnReport!");
	}
		
	private String getNationalSQL()
	{
		StringBuilder sql = new StringBuilder();
		
		sql.append("select 'National Totals' AS [National Totals], sum(Facility_Activity.Patient_Totals) AS [Total Patients], ");
		sql.append("sum(Facility_Activity.Dialogue) AS [Messaging Total], sum(Facility_Activity.MessagingByDevice) AS [Messaging By Device], ");
		sql.append("sum(Facility_Activity.MessagingByIVR) AS [Messaging By IVR], sum(Facility_Activity.Browser) AS [Messaging By Browser], ");
		sql.append("sum(Facility_Activity.MessagingUnknown) AS [Messaging (IVR, device, or browser not yet assigned)], ");
		sql.append("sum(Facility_Activity.Measurement) AS [Peripheral Measurements], sum(Facility_Activity.Video) AS [Video], ");
		sql.append("sum(Facility_Activity.CellModem) AS [Cellular Modem Transmission], sum(Facility_Activity.Satellite) AS [Satellite Transmission], ");
		sql.append("sum(Facility_Activity.DigImageCapture) AS [Digital Image Capture] ");
		sql.append("from Facility_Activity ");
		sql.append("where Facility_Activity.Rpt_Wk= :weekEndingDate ");
		sql.append("order by 1 ASC");
		
		
		return sql.toString();
	}
	
	private String getNationalSQLByModality(CensusActivityReportParameters reportParams)
	{
		/*
		 * REPORT QUERY: select 'National Totals', sum(Facility_Activity.Patient_Totals) AS [Total Patients], 
		 * sum(Facility_Activity.Dialogue) AS [Messaging Total] from Facility_Activity where Facility_Activity.Rpt_Wk=@dtReportEndDate  order by 1 ASC
		 */
		StringBuilder sql = new StringBuilder();
		sql.append("select 'National Totals', sum(Facility_Activity.Patient_Totals) AS [Total Patients], ");
		
		
		// Determine which column to sum for Messaging Total according to modality chosen.
		String columnName = reportParams.getColumnNameForModality();
		sql.append("sum(Facility_Activity.");
		sql.append(columnName);
		sql.append(") AS [Messaging Total] ");
		
		
		sql.append("from Facility_Activity ");
		sql.append("where Facility_Activity.Rpt_Wk=:weekEndingDate ");
		
		return sql.toString();		
	}
		
	private String getNationalSQLByVendor(TermType vendor)
	{
		/*
		 * REPORT QUERY: select 'National Totals for ATI', sum(Facility_Activity.Patient_Totals) AS [Total Patients], 
		 * sum(Facility_Activity.Dialogue) AS [Messaging Total], sum(Facility_Activity.MessagingByDevice) AS [Messaging By Device], 
		 * sum(Facility_Activity.MessagingByIVR) AS [Messaging By IVR], sum(Facility_Activity.Browser) AS [Messaging By Browser], 
		 * sum(Facility_Activity.MessagingUnknown) AS [Messaging (IVR, device, or browser not yet assigned)], 
		 * sum(Facility_Activity.Measurement) AS [Peripheral Measurements], sum(Facility_Activity.Video) AS [Video], 
		 * sum(Facility_Activity.CellModem) AS [Cellular Modem Transmission], sum(Facility_Activity.Satellite) AS [Satellite Transmission], 
		 * sum(Facility_Activity.DigImageCapture) AS [Digital Image Capture] 
		 * from Facility_Activity,Vendor where Facility_Activity.Rpt_Wk=@dtReportEndDate  
		 * and Facility_Activity.Vendor_ID=Vendor.Vendor_ID 
		 * and Vendor.Vendor_ID=6 
		 * GROUP BY Vendor.Vendor_Name order by 1 ASC 
		 */
		
		String totalsColumnName = getTotalsColumnName(vendor);
		StringBuilder sql = new StringBuilder();
		sql.append("select 'National Totals for ");
		sql.append(totalsColumnName);
		sql.append("', sum(Facility_Activity.Patient_Totals) AS [Total Patients], ");
		
		sql.append("sum(Facility_Activity.Dialogue) AS [Messaging Total], sum(Facility_Activity.MessagingByDevice) AS [Messaging By Device], ");
		sql.append("sum(Facility_Activity.MessagingByIVR) AS [Messaging By IVR], sum(Facility_Activity.Browser) AS [Messaging By Browser], ");
		sql.append("sum(Facility_Activity.MessagingUnknown) AS [Messaging (IVR, device, or browser not yet assigned)], ");
		sql.append("sum(Facility_Activity.Measurement) AS [Peripheral Measurements], sum(Facility_Activity.Video) AS [Video], "); 
		sql.append("sum(Facility_Activity.CellModem) AS [Cellular Modem Transmission], sum(Facility_Activity.Satellite) AS [Satellite Transmission], "); 
		sql.append("sum(Facility_Activity.DigImageCapture) AS [Digital Image Capture]");
		sql.append("from Vendor ");
		sql.append("INNER JOIN Facility_Activity ON Facility_Activity.Vendor_ID = Vendor.Vendor_ID ");	
		sql.append(	"where Facility_Activity.Rpt_Wk = :weekEndingDate ");  

		sql.append("and Vendor.Vendor_Number = :vendorNumber ");
		sql.append("GROUP BY Vendor.Vendor_Name order by 1 ASC "); 
		
		return sql.toString();	
	}
	
	private String getNationalSQLByModalityAndVendor(CensusActivityReportParameters reportParams)
	{
		
		/*
		 * REPORT QUERY: select 'National Totals for ATI', 
		 * sum(Facility_Activity.Patient_Totals) AS [Total Patients], 
		 * sum(Facility_Activity.Dialogue) AS [Messaging Total] from Facility_Activity,Vendor 
		 * where Facility_Activity.Rpt_Wk=@dtReportEndDate  
		 * and Facility_Activity.Vendor_ID=Vendor.Vendor_ID 
		 * and Vendor.Vendor_ID=6 
		 * GROUP BY Vendor.Vendor_Name order by 1 ASC
		 */
		TermType vendor = reportParams.getVendor();
		
		
		String totalsColumnName = getTotalsColumnName(vendor);
		StringBuilder sql = new StringBuilder();
		sql.append("select 'National Totals for ");
		sql.append(totalsColumnName);
		sql.append("', sum(Facility_Activity.Patient_Totals) AS [Total Patients], ");
				
		// Determine which column to sum for Messaging Total according to modality chosen.
		String columnName = reportParams.getColumnNameForModality();
		sql.append("sum(Facility_Activity.");
		sql.append(columnName);
		sql.append(") AS [Messaging Total] ");
		
		sql.append("from Vendor ");
		sql.append("INNER JOIN Facility_Activity ON Facility_Activity.Vendor_ID = Vendor.Vendor_ID ");	
		sql.append(	"where Facility_Activity.Rpt_Wk = :weekEndingDate ");  

		sql.append("and Vendor.Vendor_Number = :vendorNumber ");
		sql.append("GROUP BY Vendor.Vendor_Name order by 1 ASC "); 
		
		
		return sql.toString();	
	}
	
	private String getTotalsColumnName(TermType vendor)
	{
		StringBuilder columnName = new StringBuilder();
		
		if(vendor != null)
		{
			columnName.append(vendor.getLabel());
		}
		
		return columnName.toString();
	}

	@Override
	public List<CensusActivitySubTotalRecord> getSubTotaledNationalReport(
			CensusActivityReportParameters reportParams) throws DAOException {
		List<CensusActivitySubTotalRecord> retVal = null;
		String sql = getSubTotaledNationalReportSQL();
		String weekEndingDate = DateUtils.format(reportParams.getWeekEndingDate(), DateUtils.MMDDYYYY);
		QueryAndParams queryAndParams = new QueryAndParams();
		queryAndParams.append(sql);		
		queryAndParams.addParam("weekEndingDate", weekEndingDate);

		
		List<?> rows = executeSQLQuery(queryAndParams);
		
		if(rows != null || rows.size() > 0)
		{
			retVal = getNationalSubTotalPivotedList(rows);
		}
		
		return retVal;
	}

	private String getSubTotaledNationalReportSQL()
	{
		StringBuilder sql =  new StringBuilder();		
		sql.append("select Vendor.Vendor_Name as [Vendor], sum(Facility_Activity.Patient_Totals) AS [Total Patients], "); 
		sql.append("sum(Facility_Activity.Dialogue) AS [Messaging Total], sum(Facility_Activity.MessagingByDevice) AS [Messaging By Device], "); 
		sql.append("sum(Facility_Activity.MessagingByIVR) AS [Messaging By IVR], sum(Facility_Activity.Browser) AS [Messaging By Browser], ");
		sql.append("sum(Facility_Activity.MessagingUnknown) AS [Messaging (IVR, device, or browser not yet assigned)], "); 
		sql.append("sum(Facility_Activity.Measurement) AS [Peripheral Measurements], sum(Facility_Activity.Video) AS [Video], "); 
		sql.append("sum(Facility_Activity.CellModem) AS [Cellular Modem Transmission], "); 
		sql.append("sum(Facility_Activity.Satellite) AS [Satellite Transmission], "); 
		sql.append("sum(Facility_Activity.DigImageCapture) AS [Digital Image Capture] "); 
		sql.append("from Facility_Activity,Vendor where Facility_Activity.Rpt_Wk= :weekEndingDate "); 
		sql.append("and Vendor.Vendor_Name <> 'None' and Facility_Activity.Vendor_ID=Vendor.Vendor_ID "); 
		sql.append("GROUP BY Vendor.Vendor_Name order by 1 ASC ");
		return sql.toString();
	}

	@Override
	public List<CensusActivitySubTotalRecord> getSubTotaledNationalReportByModality(
			CensusActivityReportParameters reportParams) throws DAOException {
		List<CensusActivitySubTotalRecord> retVal = null;
		String sql = getSubTotaledNationalReportByModalitySQL(reportParams);
		
		String weekEndingDate = DateUtils.format(reportParams.getWeekEndingDate(), DateUtils.MMDDYYYY);
		QueryAndParams queryAndParams = new QueryAndParams();
		queryAndParams.append(sql);		
		queryAndParams.addParam("weekEndingDate", weekEndingDate);

		List<?> rows = executeSQLQuery(queryAndParams);

		if(rows != null || rows.size() > 0)
		{
			retVal = getNationalSubTotalPivotedListByModality(rows, reportParams.getColumnNameForModality());
		}
		
		return retVal;
	}
	
	private String getSubTotaledNationalReportByModalitySQL(CensusActivityReportParameters reportParams)
	{
		/*
		 * select Vendor.Vendor_Name as [Vendor], 
		 * sum(Facility_Activity.Patient_Totals) AS [Total Patients], 
		 * sum(Facility_Activity.Dialogue) AS [Messaging Total] 
		 * from Facility_Activity,Vendor where Facility_Activity.Rpt_Wk=@dtReportEndDate  
		 * and Vendor.Vendor_Name <> 'None' 
		 * and Facility_Activity.Vendor_ID=Vendor.Vendor_ID 
		 * GROUP BY Vendor.Vendor_Name order by 1 ASC		
		 */
		StringBuilder sql = new StringBuilder();
		
		sql.append("select Vendor.Vendor_Name as [Vendor],"); 
		sql.append("sum(Facility_Activity.Patient_Totals) AS [Total Patients],"); 
		
		// Determine which column to sum for Messaging Total according to modality chosen.
		String columnName = reportParams.getColumnNameForModality();
		sql.append("sum(Facility_Activity.");
		sql.append(columnName);
		sql.append(") AS [Messaging Total] ");
		
		sql.append("from Facility_Activity,Vendor ");
		sql.append("where Facility_Activity.Rpt_Wk= :weekEndingDate ");  
		sql.append("and Vendor.Vendor_Name <> 'None' ");
		sql.append("and Facility_Activity.Vendor_ID=Vendor.Vendor_ID "); 
		sql.append("GROUP BY Vendor.Vendor_Name order by 1 ASC");
		return sql.toString();
	}
	
	private List<CensusActivitySubTotalRecord> getNationalSubTotalPivotedList(List<?> rows)
	{
		int numRows = rows.size();
		
		// Create a group of lists that will pivot the record array
		List<Integer> totalPatients = new ArrayList<Integer>();
		List<Integer> messagingTotals = new ArrayList<Integer>();
		List<Integer> deviceTotals = new ArrayList<Integer>();
		List<Integer> ivrTotals = new ArrayList<Integer>();
		List<Integer> browserTotals = new ArrayList<Integer>();
		List<Integer> unknownTotals = new ArrayList<Integer>();
		List<Integer> measureTotals = new ArrayList<Integer>();
		List<Integer> videoTotals = new ArrayList<Integer>();
		List<Integer> cellTotals = new ArrayList<Integer>();
		List<Integer> satTotals = new ArrayList<Integer>();
		List<Integer> digitalTotals = new ArrayList<Integer>();
		
		boolean hasAti = hasVendor(rows, "ATI");
		boolean hasAuthentidate = hasVendor(rows, "Authentidate");
		boolean hasCardiocom = hasVendor(rows, "Cardiocom");
		boolean hasHealthHero = hasVendor(rows, "Health Hero");
		boolean hasViTelNet = hasVendor(rows, "ViTel Net");
		boolean hasViterion = hasVendor(rows, "Viterion");
		


		for (int row = 0; row < numRows; row++)
		{
			Object[] record = (Object[]) rows.get(row);
			
			int numColumns = record.length;
			
			for(int col = 1; col < numColumns; col++)
			{
				Integer val = (Integer)record[col];
				
				if(val == null)
				{
					val = 0;
				}
				
				switch(col)
				{
				case total_patients:					
					totalPatients.add(val);
				break;
				case messaging_total:
					messagingTotals.add(val);
					break;
				case device:
					deviceTotals.add(val);
					break;
				case ivr:
					ivrTotals.add(val);
					break;
				case browser:
					browserTotals.add(val);
					break;
				case unknown:
					unknownTotals.add(val);
					break;
				case measurements:
					measureTotals.add(val);
					break;
				case video:
					videoTotals.add(val);
					break;
				case cell:
					cellTotals.add(val);
					break;
				case satellite:
					satTotals.add(val);
					break;
				case digital:
					digitalTotals.add(val);
					break;				
				}
			}
			
		}

		if(!hasAti)
		{

			totalPatients.add(0, 0);
			messagingTotals.add(0, 0);
			deviceTotals.add(0, 0);
			ivrTotals.add(0, 0);
			browserTotals.add(0, 0);
			unknownTotals.add(0, 0);
			measureTotals.add(0, 0);
			videoTotals.add(0, 0);
			cellTotals.add(0, 0);
			satTotals.add(0, 0);
			digitalTotals.add(0, 0);
		}
		
		if(!hasAuthentidate)
		{

			totalPatients.add(1, 0);
			messagingTotals.add(1, 0);
			deviceTotals.add(1, 0);
			ivrTotals.add(1, 0);
			browserTotals.add(1, 0);
			unknownTotals.add(1, 0);
			measureTotals.add(1, 0);
			videoTotals.add(1, 0);
			cellTotals.add(1, 0);
			satTotals.add(1, 0);
			digitalTotals.add(1, 0);
		}
		
		if(!hasCardiocom)
		{
			totalPatients.add(2, 0);
			messagingTotals.add(2, 0);
			deviceTotals.add(2, 0);
			ivrTotals.add(2, 0);
			browserTotals.add(2, 0);
			unknownTotals.add(2, 0);
			measureTotals.add(2, 0);
			videoTotals.add(2, 0);
			cellTotals.add(2, 0);
			satTotals.add(2, 0);
			digitalTotals.add(2, 0);
		}
		
		if(!hasHealthHero)
		{
			totalPatients.add(3, 0);
			messagingTotals.add(3, 0);
			deviceTotals.add(3, 0);
			ivrTotals.add(3, 0);
			browserTotals.add(3, 0);
			unknownTotals.add(3, 0);
			measureTotals.add(3, 0);
			videoTotals.add(3, 0);
			cellTotals.add(3, 0);
			satTotals.add(3, 0);
			digitalTotals.add(3, 0);
		}
		
		if(!hasViTelNet)
		{
			totalPatients.add(4, 0);
			messagingTotals.add(4, 0);
			deviceTotals.add(4, 0);
			ivrTotals.add(4, 0);
			browserTotals.add(4, 0);
			unknownTotals.add(4, 0);
			measureTotals.add(4, 0);
			videoTotals.add(4, 0);
			cellTotals.add(4, 0);
			satTotals.add(4, 0);
			digitalTotals.add(4, 0);
		}
		
		if(!hasViterion)
		{
			totalPatients.add(5, 0);
			messagingTotals.add(5, 0);
			deviceTotals.add(5, 0);
			ivrTotals.add(5, 0);
			browserTotals.add(5, 0);
			unknownTotals.add(5, 0);
			measureTotals.add(5, 0);
			videoTotals.add(5, 0);
			cellTotals.add(5, 0);
			satTotals.add(5, 0);
			digitalTotals.add(5, 0);
		}
		CensusActivitySubTotalRecord patientTotalsRecord =  getCensusActivitySubTotalRecord(totalPatients, TOTAL_PATIENTS);
		CensusActivitySubTotalRecord messagingTotalsRecord =  getCensusActivitySubTotalRecord(messagingTotals, MESSAGING_TOTAL);
		CensusActivitySubTotalRecord deviceTotalsRecord = getCensusActivitySubTotalRecord(deviceTotals, MESSAGING_BY_DEVICE);
		CensusActivitySubTotalRecord ivrTotalsRecord = getCensusActivitySubTotalRecord(ivrTotals, MESSAGING_BY_IVR);
		CensusActivitySubTotalRecord browserTotalsRecord = getCensusActivitySubTotalRecord(browserTotals, MESSAGING_BY_BROWSER);
		CensusActivitySubTotalRecord unknownTotalsRecord = getCensusActivitySubTotalRecord(unknownTotals, MESSAGING_UNKOWN);
		CensusActivitySubTotalRecord measureTotalsRecord = getCensusActivitySubTotalRecord(measureTotals, PERIPHERAL_MEASUREMENTS);
		CensusActivitySubTotalRecord videoTotalsRecord = getCensusActivitySubTotalRecord(videoTotals, VIDEO);
		CensusActivitySubTotalRecord cellTotalsRecord = getCensusActivitySubTotalRecord(cellTotals, CELLULAR_MODEM_TRANSMISSION);
		CensusActivitySubTotalRecord satTotalsRecord = getCensusActivitySubTotalRecord(satTotals, SATELLITE_TRANSMISSION);
		CensusActivitySubTotalRecord digitalTotalsRecord = getCensusActivitySubTotalRecord(digitalTotals, DIGITAL_IMAGE_CAPTURE);
	
		List<CensusActivitySubTotalRecord> returnVal = new ArrayList<CensusActivitySubTotalRecord>();
		returnVal.add(patientTotalsRecord);
		returnVal.add(messagingTotalsRecord);
		returnVal.add(deviceTotalsRecord);
		returnVal.add(ivrTotalsRecord);
		returnVal.add(browserTotalsRecord);
		returnVal.add(unknownTotalsRecord);
		returnVal.add(measureTotalsRecord);
		returnVal.add(videoTotalsRecord);
		returnVal.add(cellTotalsRecord);
		returnVal.add(satTotalsRecord);
		returnVal.add(digitalTotalsRecord);
		return returnVal;
	}
	
	private List<CensusActivitySubTotalRecord> getNationalSubTotalPivotedListByModality(List<?> rows, String selectedModalityName)
	{
		int numRows = rows.size();
		
		// Create a group of lists that will pivot the record array
		List<Integer> totalPatients = new ArrayList<Integer>();
		List<Integer> selectedModality = new ArrayList<Integer>();

		boolean hasAti = hasVendor(rows, "ATI");
		boolean hasAuthentidate = hasVendor(rows, "Authentidate");
		boolean hasCardiocom = hasVendor(rows, "Cardiocom");
		boolean hasHealthHero = hasVendor(rows, "Health Hero");
		boolean hasViTelNet = hasVendor(rows, "ViTel Net");
		boolean hasViterion = hasVendor(rows, "Viterion");

		
		for (int row = 0; row < numRows; row++)
		{
			Object[] record = (Object[]) rows.get(row);
			
			int numColumns = record.length;
			
			for(int col = 1; col < numColumns; col++)
			{
				Integer val = (Integer)record[col];
				
				if(val == null)
				{
					val = 0;
				}
				
				switch(col)
				{
				case 1:					
					totalPatients.add(val);
				break;
				case 2:
					selectedModality.add(val);
				break;							
				}
			}
			
		}
		
		if(!hasAti)
		{

			totalPatients.add(0, 0);
			selectedModality.add(0, 0);
		}
		
		if(!hasAuthentidate)
		{

			totalPatients.add(1, 0);
			selectedModality.add(1, 0);
		}
		
		if(!hasCardiocom)
		{
			totalPatients.add(2, 0);
			selectedModality.add(2, 0);
		}
		
		if(!hasHealthHero)
		{
			totalPatients.add(3, 0);
			selectedModality.add(3, 0);
		}
		
		if(!hasViTelNet)
		{
			totalPatients.add(4, 0);
			selectedModality.add(4, 0);
		}
		
		if(!hasViterion)
		{
			totalPatients.add(5, 0);
			selectedModality.add(5, 0);
		}
		
		CensusActivitySubTotalRecord patientTotalsRecord =  getCensusActivitySubTotalRecord(totalPatients, TOTAL_PATIENTS);
		CensusActivitySubTotalRecord selectedModalitysRecord =  getCensusActivitySubTotalRecord(selectedModality, selectedModalityName);
		
	
		List<CensusActivitySubTotalRecord> returnVal = new ArrayList<CensusActivitySubTotalRecord>();
		returnVal.add(patientTotalsRecord);
		returnVal.add(selectedModalitysRecord);
		
		return returnVal;
	}
	
	private CensusActivitySubTotalRecord getCensusActivitySubTotalRecord(List<Integer> row, String modalityName)
	{
		CensusActivitySubTotalRecord retVal = new CensusActivitySubTotalRecord();
		final int ati_Total = 0;
		final int authentidate_Total = 1;
		final int cardiocomTotal = 2;
		final int healthHeroTotal = 3;
		final int vitelNetTotal = 4;
		final int viterionTotal = 5;
		
		retVal.setModalityName(modalityName);
		for(int col = 0; col < row.size(); col++)
		{
			switch(col)
			{
			case ati_Total:					
				retVal.setAtiTotal(row.get(col));
			break;
			case authentidate_Total:
				retVal.setAuthentidateTotal(row.get(col));
				break;
			case cardiocomTotal:
				retVal.setCardiocomTotal(row.get(col));
				break;
			case healthHeroTotal:
				retVal.setHealthHeroTotal(row.get(col));
				break;
			case vitelNetTotal:
				retVal.setVitelNetTotal(row.get(col));
				break;
			case viterionTotal:
				retVal.setViterionTotal(row.get(col));
				break;		
			}
		}
		
		return retVal;
	}
	
	
	private boolean hasVendor(List<?> rows, String vendor)
	{
		boolean hasVendor = false;
		
		int numRows = rows.size();
		
		for(int col = 0; col < numRows; col++)
		{			
			Object[] row = (Object[])rows.get(col);
			String curVendor = (String)row[0];
			
			if(curVendor.equalsIgnoreCase(vendor))
			{
				return true;
			}
		}
		
		return hasVendor;
	}
}
