package gov.va.med.ccht.persistent;

import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.persistent.DAOException;

import java.util.Collection;
import java.util.List;

public interface TerminologyDAO {

	public <T extends Lookup> List<T> findAll(String terminologyType) throws DAOException;

	public <T extends Lookup> List<T> findAll(Class<T> terminologyType) throws DAOException;
	
	public <T extends Lookup> List<T> findAllActive(Class<T> terminologyType) throws DAOException;

	public Lookup getByCode(String terminologyType, String code) throws DAOException;

	public <T extends Lookup> T getByCode(Class<T> terminologyType, String code)
			throws DAOException;

	public <T extends Lookup> List<T> getByCodes(Class<T> terminologyType, Collection<String> codes);
	
	public Lookup getByName(String terminologyType, String name) throws DAOException;

	public <T extends Lookup> T getByName(Class<T> terminologyType, String name)
			throws DAOException;

	public Lookup getById(String terminologyType, Long id) throws DAOException;

	public <T extends Lookup> T getById(Class<T> terminologyType, Long id) throws DAOException;

	public List<? extends Lookup> searchTerms(String terminologyType, String searchCriteria)
			throws DAOException;
		
	public void save(AbstractLookup lookup) throws DAOException;
}
