/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.persistent;

import gov.va.med.ccht.model.SimpleUser;
import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.UserRole;
import gov.va.med.ccht.model.terminology.FederalHoliday;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.ldap.SearchCriteria;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.security.Application;
import gov.va.med.fw.security.Permission;
import gov.va.med.fw.security.Role;
import gov.va.med.fw.security.SimpleRole;
import gov.va.med.fw.security.UserPrincipal;

import java.util.List;

/**
 * 
 * 
 * IHTA IHTA_common Jun 24, 2010
 * 
 * @author vhaisakatikm
 */
public interface SecurityDAO extends DAOOperations {
	/**
	 * Get user by name
	 * 
	 * @param userId
	 * @return
	 * @throws DAOException
	 */
	public User getUserByName(String userId) throws DAOException;

	/**
	 * Get user by primary key
	 * 
	 * @param entityKey
	 * @return
	 * @throws DAOException
	 */
	public User getUserByKey(EntityKey<User> entityKey) throws DAOException;
	
	public List<User> getSubmittedRegistrations(Long visnId, Long facilityId) throws DAOException;

	/**
	 * Create user in the IHTA database
	 * 
	 * @param user
	 * @throws DAOException
	 */
	public void createUser(User user) throws DAOException;

	/**
	 * Update user in the IHTA database
	 * 
	 * @param user
	 * @throws DAOException
	 */
	public void updateUser(User user) throws DAOException;

	/**
	 * Update role in the IHTA database
	 * 
	 * @param user
	 * @throws DAOException
	 */
	public void updateRole(Role role) throws DAOException;

	/**
	 * Find all roles
	 * 
	 * @return
	 * @throws DAOException
	 */
	public List<Role> findAllRoles(Application application) throws DAOException;

	/**
	 * Find all permissions
	 * 
	 * @return
	 * @throws DAOException
	 */
	public List<Permission> findAllPermissions(Application application) throws DAOException;

	/**
	 * Get Role by name
	 * 
	 * @param roleName
	 * @return
	 * @throws DAOException
	 */
	public Role getRoleByName(String roleName) throws DAOException;
	public List<SimpleRole> findAllSimpleRoles() throws DAOException;
	public List<SimpleRole> findAllDMPRoles() throws DAOException;
	public List<User> getSubmittedRegistrationsForDmp(Long visnId, Long facilityId) throws DAOException;
	public SimpleRole getSimpleRoleByName(String roleName) throws DAOException;

	/**
	 * Get available role names for assignment
	 * 
	 * @return
	 * @throws DAOException
	 */
	public List<String> getAvailableRoleNames(Application application) throws DAOException;

	/**
	 * Get assigned permissions for a given role
	 * 
	 * @return
	 * @throws DAOException
	 */
	public List<String> getRolePermissionNames(String roleName) throws DAOException;

	/**
	 * Get Application
	 * 
	 * @param applicationName
	 * @return
	 * @throws DAOException
	 */
	public Application getApplicationByName(String applicationName) throws DAOException;
	
	public void deleteRole(EntityKey<UserRole> identifier) throws DAOException;

	public UserPrincipal getAuditUser(String userName) throws DAOException;

	public List<FederalHoliday> findHolidays(int year) throws DAOException;
	public List<String> getUserIds() throws DAOException;
	public List<SimpleUser> findAppUsers(SearchCriteria searchCriteria) throws DAOException;
	public void deleteEntity(Object obj) throws DAOException;
	public void flush();
}
