/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.persistent;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.ccht.model.report.CompletedReport;
import gov.va.med.ccht.model.report.CompletedReportFieldType;
import gov.va.med.ccht.model.report.ScheduledReport;
import gov.va.med.ccht.model.report.SimpleCompletedReport;
import gov.va.med.ccht.model.terminology.StandardReport;
import gov.va.med.ccht.service.report.CompletedReportsSearchQueryInfo;
import gov.va.med.ccht.service.report.ReportFilterSearchQueryInfo;

/**
 * 
 * @author vhaisakatikm
 */
public interface ReportDAO extends DAOOperations {

	public ScheduledReport getScheduledReport(EntityKey<ScheduledReport> identifier) throws DAOException;

	public ScheduledReport saveScheduledReport(ScheduledReport scheduledReport) throws DAOException;

	public void deleteScheduledReport(EntityKey<ScheduledReport> identifier) throws DAOException;

	public List<ScheduledReport> searchScheduledReports(ReportFilterSearchQueryInfo searchCriteria)
			throws DAOException, MaxRecordsExceededException;
	
	public CompletedReport getCompletedReport(EntityKey<CompletedReport> identifier)
			throws DAOException;

	public void saveCompletedReport(CompletedReport completedReport) throws DAOException;

	public void saveSimpleCompletedReport(SimpleCompletedReport completedReport)
			throws DAOException;

	public List<SimpleCompletedReport> searchCompletedReports(
			CompletedReportsSearchQueryInfo searchCriteria) throws DAOException,
			MaxRecordsExceededException;


	public void deleteCompletedReport(EntityKey<CompletedReport> identifier) throws DAOException;

	public SimpleCompletedReport getSimpleCompletedReport(
			EntityKey<SimpleCompletedReport> identifier) throws DAOException;

	public List<StandardReport> getDistinctStandardReports() throws DAOException;

	public List<ReportExportedType> getDistinctReportExportTypes() throws DAOException;

	public Integer purgeCompletedReports() throws DAOException;

	public Map<String, String> getExpiringReportIdUserMap(Integer expiringDays, Integer warningDays)
			throws DAOException;

	public LinkedHashMap<String, String> getUniqueFilterValues(CompletedReportFieldType fieldType);

}
