package gov.va.med.ccht.persistent;

import gov.va.med.ccht.model.inventory.Device;
import gov.va.med.ccht.model.inventory.DeviceDetail;
import gov.va.med.ccht.model.inventory.DeviceRequirement;
import gov.va.med.ccht.model.inventory.DeviceSearchParameters;
import gov.va.med.ccht.model.inventory.DeviceTrackerLog;
import gov.va.med.ccht.model.inventory.DeviceType;
import gov.va.med.ccht.model.inventory.Facility;
import gov.va.med.ccht.model.inventory.FacilityActivity;
import gov.va.med.ccht.model.inventory.SimpleFacility;
import gov.va.med.ccht.model.inventory.SimpleVisn;
import gov.va.med.ccht.model.inventory.Vendor;
import gov.va.med.ccht.model.inventory.Visn;
import gov.va.med.ccht.model.report.ReportSetup;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.ui.model.TermType;

import java.util.List;

public interface InventoryDAO extends DAOOperations {
	public List<Device> getDevices() throws DAOException;
	public List<Vendor> getVendors() throws DAOException;
	public List<Facility> getFacilities() throws DAOException;
	public List<Facility> getFacilities(String visnName) throws DAOException;	
	public List<Visn> getVisns() throws DAOException;
	
	public Device getDevice(String name) throws DAOException;
	public DeviceType getDeviceType(String code) throws DAOException;
	
	public List<TermType> getModalityType(int type) throws DAOException;

	public Vendor getVendor(String name) throws DAOException;
	public Facility getFacility(String stationNumber) throws DAOException;
	public Visn getVisn(String name) throws DAOException;
	public SimpleVisn getSimpleVisn(String name) throws DAOException;
	public List<SimpleVisn> getSimpleVisns() throws DAOException;
	public SimpleFacility getSimpleFacility(String stationNumber) throws DAOException;
	public List<SimpleFacility> getSimpleFacilities() throws DAOException;
	public List<SimpleFacility> getSimpleFacilities(SimpleVisn visn) throws DAOException;
	public List<Object[]> generateInventoryReports(ReportSetup reportSetup) throws DAOException;
	public List<Object[]> searchDevice(DeviceSearchParameters deviceSearchParameters) throws DAOException;
	public List<Object[]> generateVCCurrentReport(DeviceSearchParameters deviceSearchParameters) throws DAOException;
	public List<Object[]> generateVCHistoryReport(DeviceSearchParameters deviceSearchParameters) throws DAOException;
	public List<Object[]> generateVCReportCharts(DeviceSearchParameters deviceSearchParameters) throws DAOException;	
	public List<DeviceRequirement> getDeviceRequirements(SimpleFacility simpleFacility) throws DAOException;
	public DeviceDetail getDeviceDetail(DeviceSearchParameters deviceSearchParameters) throws DAOException;
	public List<DeviceTrackerLog> getUnprocessedDeviceTrackerLogs() throws DAOException;
	public List<Vendor> getActiveVendorsForComplianceReport() throws DAOException;
	public void setVendorComplianceReportCompletion(List<DeviceTrackerLog> deviceTrackerLogs) throws DAOException;
	public List<FacilityActivity> getFacilityActivitiesReportWeeks() throws DAOException;
}
