package gov.va.med.ccht.persistent;

import java.util.Collection;
import java.util.List;

import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.dmp.DMP;
import gov.va.med.ccht.model.dmp.DMPFindReplaceCriteria;
import gov.va.med.ccht.model.dmp.DMPFindResults;
import gov.va.med.ccht.model.dmp.DMPSearch;
import gov.va.med.ccht.model.dmp.DMPQuestion;
import gov.va.med.ccht.model.dmp.DMPResponse;
import gov.va.med.ccht.model.dmp.DMPReview;
import gov.va.med.ccht.model.dmp.DMPSearchParameters;
import gov.va.med.ccht.model.dmp.DMPStandLibEntry;
import gov.va.med.ccht.model.dmp.DMPToolUser;
import gov.va.med.ccht.model.dmp.DMPVendorDeployment;
import gov.va.med.ccht.model.inventory.Vendor;
import gov.va.med.ccht.util.DMPExport;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.service.ServiceException;

public interface DMPDAO extends DAOOperations {
	public DMP saveDMP(DMP dmp) throws DAOException;
	public List<DMP> findAllDmps() throws DAOException;
	public DMPToolUser saveDMPToolUser(DMPToolUser assignee) throws DAOException;
	public DMPToolUser saveDMPToolUser(DMPToolUser assignee, boolean isAssignDMP) throws DAOException;
	public DMP findDMPById(String id) throws DAOException;
	public List<DMPToolUser> findDMPToolUsers(DMP dmp) throws DAOException;
	public List<DMPToolUser> findDMPToolUsers(String dmpId) throws DAOException;
	public User findUserById(String userId) throws DAOException;
	public void deleteDMPToolUser(EntityKey<Object> identifier) throws DAOException;
	public List<DMPToolUser> findAssigedDmps(String userId) throws DAOException;
	public DMPQuestion saveDMPQuestion(DMPQuestion question) throws DAOException;
	public void deleteDMPQuestion(EntityKey<Object> identifier) throws DAOException;
	public List<DMP> findCreatedDmps(String userId) throws DAOException;
	public DMPQuestion findQuestionById(String questionId) throws DAOException;
	public DMPResponse saveDMPResponse(DMPResponse response) throws DAOException ;
	public void deleteDMPResponse(EntityKey<Object> identifier)	throws DAOException;
	public DMPExport exportDmp(String dmpId) throws DAOException;
	public void deleteDMPResponses(Collection<DMPResponse> responses) throws DAOException;
	public List<DMPToolUser> findDmpFacilitators() throws DAOException;
	public List<DMPToolUser> findAllDMPToolUsers() throws DAOException;
	public List<DMPSearch> getAllDmps() throws DAOException;
	public List<DMPSearch> searchAllDmps(DMPSearchParameters dmpSearchParameters) throws DAOException;
	public List<DMPFindResults> findTermInDMPAttributes(DMPFindReplaceCriteria criteria) throws DAOException;
	public List<DMPFindResults> findTermInDMPContent(DMPFindReplaceCriteria criteria) throws DAOException;
	public List<DMP> getAllMyCreatedDmps(String userId) throws DAOException;
	public List<DMPToolUser> getAllMyAssigedDmps(String userId) throws DAOException;
	public List<DMPFindResults> findTermInDMPResponses(DMPFindReplaceCriteria criteria) throws DAOException;
	public DMPStandLibEntry saveDMPStandLibEntry(DMPStandLibEntry dmpStandLibEntry) throws DAOException;
	public Boolean isDMPStandLibEntryDuplicate(DMPStandLibEntry dmpStandLibEntry) throws DAOException;
	public List<DMPStandLibEntry> getAllStandardLibs() throws DAOException;
	public DMPStandLibEntry findDMPStanLibEntryById(Long id) throws DAOException;
	public DMPReview saveDMPReview(DMPReview dmpReview) throws DAOException;
	public DMPReview deleteDMPReview(DMPReview dmpReview) throws DAOException;
	public DMPVendorDeployment findDMPVendorDeployment(DMP dmp,Vendor vendor) throws DAOException;
	public DMPVendorDeployment saveDMPVendorDeployment(DMPVendorDeployment dmpVendorDeployment) throws DAOException;
	public List<DMPReview> getDMPQuestionComments(String dmpId, String dmpContentId ) throws DAOException;
	public List<DMPToolUser> findDMPReviewers(String dmpId) throws DAOException;
	public void updateDmpQuestionsLockStatus(List<Long> questionIds, Integer lockDmpContent) throws DAOException;
}
