package gov.va.med.ccht.persistent;

import gov.va.med.ccht.model.car.CensusActivityRecord;
import gov.va.med.ccht.model.car.CensusActivityReportParameters;
import gov.va.med.ccht.model.car.CensusActivitySubTotalRecord;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;

import java.util.Date;
import java.util.List;


public interface CensusActivityReportDAO extends DAOOperations 
{
	public CensusActivityRecord getLastReportWeek() throws DAOException;
	public List<CensusActivityRecord> getNationalReport(CensusActivityReportParameters reportParams)throws DAOException;
	public List<CensusActivitySubTotalRecord> getSubTotaledNationalReport(CensusActivityReportParameters reportParams)throws DAOException;
	public List<CensusActivityRecord> getNationalReportByVendor(CensusActivityReportParameters reportParams)throws DAOException;
	
	public List<CensusActivityRecord> getNationalReportByModality(CensusActivityReportParameters reportParams) throws DAOException;
	public List<CensusActivitySubTotalRecord> getSubTotaledNationalReportByModality(CensusActivityReportParameters reportParams)throws DAOException;
	public List<CensusActivityRecord> getNationalReportByModalityAndVendor(CensusActivityReportParameters reportParams) throws DAOException;
	
	
	
	public void getVisnReport(CensusActivityReportParameters reportParams)throws DAOException;
	public void getFacilityReport(CensusActivityReportParameters reportParams)throws DAOException;
}
