/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Feb 24, 2010
 *
 */
package gov.va.med.ccht.model.terminology;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractLookup;

@org.hibernate.annotations.Cache(usage = org.hibernate.annotations.CacheConcurrencyStrategy.READ_ONLY)
public class ScheduleType extends AbstractLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 8484060742438453490L;

	/**
	 * Daily/weekly
	 */
	public static final Code DAY_OF_WEEK = new Code("1");

	/**
	 * This is when a user clicks on Monthly and selects last/first date of a
	 * month
	 */
	public static final Code DAY_OF_MONTH = new Code("2");

	/**
	 * This is when a user clicks on Monthly and selects week / date of a month
	 */
	public static final Code WEEK_DAY = new Code("4");

	/**
	 * This is when a user clicks on Quarterly
	 */
	public static final Code DAY_OF_QUARTER = new Code("3");

	/**
	 * This is when a user clicks on Yearly and selects last/first Mon-Sat date
	 * in a month
	 */
	public static final Code WEEK_DAY_MONTH = new Code("5");

	/**
	 * This is when a user clicks on Yearly
	 */
	public static final Code MONTH_DAY = new Code("6");

	/**
	 * This is when a user clicks on Other
	 */
	public static final Code DATE = new Code("7");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -5633645317256942768L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}
}
