/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/

/**
 * Created on Feb 24, 2010
 *
 */
package gov.va.med.ccht.model.terminology;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractLookup;

@org.hibernate.annotations.Cache(usage = org.hibernate.annotations.CacheConcurrencyStrategy.READ_ONLY)
public class RunFrequency extends AbstractLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 7036073859781587056L;

	public static final Code DAILY_WEEKLY = new Code("1");
	public static final Code MONTHLY = new Code("2");
	public static final Code QUARTERLY = new Code("3");
	public static final Code YEARLY = new Code("4");
	public static final Code OTHER = new Code("5");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 5771390774297188655L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}
}
