/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.ccht.model.terminology;

import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractLookup;

@org.hibernate.annotations.Cache(usage = org.hibernate.annotations.CacheConcurrencyStrategy.READ_ONLY)
public class DayOfMonth extends AbstractLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 8175061100006446582L;
	public static final Code CODE_FIRST = new Code("1", "1");

	public static final Code CODE_LAST = new Code("2", "L");

	public static final Code CODE_15TH = new Code("3", "15");

	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = -9209133451284526547L;

		private Code(String code, String alias) {
			super(code, alias);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}
}