package gov.va.med.ccht.model.report.scheduled;

import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.util.DateUtils;

import java.util.Calendar;
import java.util.Date;

/**
 * These are simple time units that can be added or subtracted from a specific
 * date to arrive at another.
 * 
 * @author vhaisdbarryc
 * 
 */
public enum SimpleTimeUnitType implements Lookup {
	DAY("Day(s)", new RelativeDateCalculator() {
		public Date calculateDate(Date startDate, Integer num) {
			return DateUtils.add(startDate, Calendar.DAY_OF_MONTH, num);
		}
	}),
	WEEK("Week(s)", new RelativeDateCalculator() {
		public Date calculateDate(Date startDate, Integer num) {
			return DateUtils.add(startDate, Calendar.WEEK_OF_YEAR, num);
		}
	}),
	MONTH("Month(s)", new RelativeDateCalculator() {
		public Date calculateDate(Date startDate, Integer num) {
			return DateUtils.add(startDate, Calendar.MONTH, num);
		}
	}),
	YEAR("Year(s)", new RelativeDateCalculator() {
		public Date calculateDate(Date startDate, Integer num) {
			return DateUtils.add(startDate, Calendar.YEAR, num);
		}
	});

	private String name;
	private RelativeDateCalculator dateCalculator;

	private SimpleTimeUnitType(String name, RelativeDateCalculator dateCalculator) {
		this.name = name;
		this.dateCalculator = dateCalculator;
	}

	public String getName() {
		return name;
	}

	public String getCode() {
		return name();
	}

	public String getDescription() {
		return getName();
	}

	public Date calculateRelativeDate(Date startDate, Integer num) {
		return dateCalculator.calculateDate(startDate, num);
	}

	private interface RelativeDateCalculator {
		Date calculateDate(Date startDate, Integer num);
	}
}
