package gov.va.med.ccht.model.report.scheduled;

import gov.va.med.fw.model.lookup.Lookup;

import java.util.Calendar;

/**
 * These represent a fixed date inside a greater date range (specifically the
 * values in MultiDayTimeUnitType).
 * 
 * @author vhaisdbarryc
 */
public enum FixedDateType implements Lookup {
	FIRST("First", new CalendarSetter() {
		public void set(Calendar c, int field) {
			c.set(field, 1);
		}
	}),
	SECOND("Second", new CalendarSetter() {
		public void set(Calendar c, int field) {
			c.set(field, 2);
		}
	}),
	FIFTEENTH("15th", new CalendarSetter() {
		public void set(Calendar c, int field) {
			c.set(field, 15);
		}
	}),
	LAST("Last", new CalendarSetter() {
		public void set(Calendar c, int field) {
			c.set(field, c.getActualMaximum(field));
		}
	});

	private String name;
	private CalendarSetter calendarSetter;

	private FixedDateType(String name, CalendarSetter calendarSetter) {
		this.name = name;
		this.calendarSetter = calendarSetter;
	}

	public String getName() {
		return name;
	}
	
	public String getCode() {
		return name();
	}

	public String getDescription() {
		return getName();
	}
	
	public void setCalendar(Calendar c, int field) {
		calendarSetter.set(c, field);
	}

	private static interface CalendarSetter {
		void set(Calendar c, int field);
	}
}
