/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/

/*
 * Created on Apr 13, 2010
 *
 */
package gov.va.med.ccht.model.report;

// Java classes

// Library classes

// Framework classes
import java.util.Date;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.util.StringUtils;

import gov.va.med.ccht.model.terminology.StandardReport;

/**
 * @author Yi He
 * @version 1.0 A stripped down version of ReportSetup that contains a subset of
 *          properties of ReportSetup. This class can be used in lieu of
 *          ReportSetup to improve performance when only this subset of
 *          properties are needed.
 */
public class ReportSetupLite extends AbstractKeyedEntity<ReportSetupLite> {

	private static final long serialVersionUID = 486798783515930763L;

	public ReportSetupLite() {
		super();
	}

	public String getSetupUser() {
		return this.setupUser;
	}

	public void setSetupUser(String setupUser) {
		this.setupUser = setupUser;
	}

	public ReportExportedType getFileType() {
		return this.fileType;
	}

	public void setFileType(ReportExportedType fileType) {
		this.fileType = fileType;
	}

	/**
	 * 
	 * @return The code of the StandardReport for this report setup. Blanks and
	 *         dashes in the code are removed.
	 */
	public String getReportCode() {
		return StringUtils.remove(StringUtils.deleteWhitespace(this.report.getCode()), '-');
	}

	public StandardReport getReport() {
		return this.report;
	}

	public void setReport(StandardReport report) {
		this.report = report;
	}

	public Date getDateToGenerate() {
		return dateToGenerate;
	}

	public void setDateToGenerate(Date dateToGenerate) {
		this.dateToGenerate = dateToGenerate;
	}

	private ReportExportedType fileType;

	private String setupUser; // The user who configured or scheduled the report

	private StandardReport report; // the standard report that this report
	// belongs

	private Date dateToGenerate;

}
