/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.model.report;

import java.util.Date;
import java.util.TimeZone;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.util.date.DateWithTimeZone;

import gov.va.med.ccht.model.terminology.StandardReport;

/**
 * IHTA IHTA_common Aug 8, 2010
 * 
 * @author vhaisakatikm
 * @author vhaisdbarryc
 */
public class ReportSetup extends AbstractKeyedEntity<ReportSetup> {
	private static final long serialVersionUID = -9032722332993275866L;

	// ------------------------------------ Fields

	private ReportSchedule reportSchedule;
	private ReportParameters reportParameters;
	private StandardReport standardReport;
	private ReportExportedType fileType;
	private String emailAddress;
	private String setupUser;
	private String reportParametersText;
	private String reportScheduleText;
	@org.hibernate.annotations.Type(type = "gov.va.med.fw.persistent.hibernate.UTCDateType")
	private Date internalDateToGenerate;
	private TimeZone internalDateToGenerateTimeZone;

	// ------------------------------------ Business Methods

	public DateWithTimeZone getDateToGenerate() {
		return getInternalDateToGenerate() == null ? null : new DateWithTimeZone(
				getInternalDateToGenerate(), getInternalDateToGenerateTimeZone());
	}

	public void setDateToGenerate(DateWithTimeZone dateToGenerate) {
		setInternalDateToGenerate(dateToGenerate == null ? null : dateToGenerate.getDate());
		setInternalDateToGenerateTimeZone(dateToGenerate == null ? null : dateToGenerate
				.getTimeZone());
	}

	// ------------------------------------ Accessor Methods

	public String getEmailAddress() {
		return emailAddress;
	}

	public void setEmailAddress(String emailAddress) {
		this.emailAddress = emailAddress;
	}

	public ReportParameters getReportParameters() {
		return reportParameters;
	}

	public void setReportParameters(ReportParameters reportParameters) {
		this.reportParameters = reportParameters;
	}

	public ReportSchedule getReportSchedule() {
		return reportSchedule;
	}

	public void setReportSchedule(ReportSchedule reportSchedule) {
		this.reportSchedule = reportSchedule;
	}

	public StandardReport getStandardReport() {
		return standardReport;
	}

	public void setStandardReport(StandardReport standardReport) {
		this.standardReport = standardReport;
	}

	public String getSetupUser() {
		return setupUser;
	}

	public void setSetupUser(String setupUser) {
		this.setupUser = setupUser;
	}

	public String getReportParametersText() {
		return reportParametersText;
	}

	public void setReportParametersText(String reportParametersText) {
		this.reportParametersText = reportParametersText;
	}

	public String getReportScheduleText() {
		return reportScheduleText;
	}

	public void setReportScheduleText(String reportScheduleText) {
		this.reportScheduleText = reportScheduleText;
	}

	public ReportExportedType getFileType() {
		return fileType;
	}

	public void setFileType(ReportExportedType fileType) {
		this.fileType = fileType;
	}

	private Date getInternalDateToGenerate() {
		return internalDateToGenerate;
	}

	private void setInternalDateToGenerate(Date internalDateToGenerate) {
		this.internalDateToGenerate = internalDateToGenerate;
	}

	private TimeZone getInternalDateToGenerateTimeZone() {
		return internalDateToGenerateTimeZone;
	}

	private void setInternalDateToGenerateTimeZone(TimeZone internalDateToGenerateTimeZone) {
		this.internalDateToGenerateTimeZone = internalDateToGenerateTimeZone;
	}
}
