/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.model.report;

import gov.va.med.ccht.model.terminology.StandardReport;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.util.StringUtils;

import java.util.Date;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Formula;

/**
 * 
 * project: CCHT
 * @author vhaisakatikm
 */
public class AbstractScheduledReport extends AbstractKeyedEntity<Object> {

	private static final long serialVersionUID = -6493319251137463297L;
	
	private StandardReport standardReport;
	private ReportExportedType fileType;
	private String reportParameterText;
	private String reportScheduleText;
	private String userName;	
	private Date reportGenerateDate;
	private String email;
	@Formula(value = "(select isnull(u.last_name,'') + ', ' + isnull(u.first_name,'')+' ' + isnull(u.middle_name,'') from ht.app_user u where u.user_name = rpt_scheduled_by)")
	private String userFullName;
	
	public StandardReport getStandardReport() {
		return standardReport;
	}
	public void setStandardReport(StandardReport standardReport) {
		this.standardReport = standardReport;
	}
	public ReportExportedType getFileType() {
		return fileType;
	}
	public void setFileType(ReportExportedType fileType) {
		this.fileType = fileType;
	}
	public String getReportParameterText() {
		return reportParameterText;
	}
	public void setReportParameterText(String reportParameterText) {
		this.reportParameterText = reportParameterText;
	}
	public String getUserName() {
		return userName;
	}
	public void setUserName(String userName) {
		this.userName = userName;
	}
	public String getReportScheduleText() {
		return reportScheduleText;
	}
	public void setReportScheduleText(String reportScheduleText) {
		this.reportScheduleText = reportScheduleText;
	}
	public Date getReportGenerateDate() {
		return reportGenerateDate;
	}
	public void setReportGenerateDate(Date reportGenerateDate) {
		this.reportGenerateDate = reportGenerateDate;
	}
	public String getEmail() {
		return email;
	}
	public void setEmail(String email) {
		this.email = email;
	}
	public String getUserFullName() {
		return (StringUtils.isEmpty(userFullName) || ",".equals(userFullName.trim())) ? getUserName()
				: userFullName;
	}
	public void setUserFullName(String userFullName) {
		this.userFullName = userFullName;
	}
	protected void buildToString(ToStringBuilder builder) {
		// override supper method
		builder.append("ID", this.getId());
		builder.append("User name", this.getUserName());
		builder.append("Schedule Text", this.getReportScheduleText());
		builder.append("Generation date", this.getReportGenerateDate());
		builder.append("Email", this.getEmail());
	}
}
