/********************************************************************
 * Copyright � 2010 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.ccht.model.report;

import java.util.Date;

import org.hibernate.annotations.Formula;

import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.util.StringUtils;

import gov.va.med.ccht.model.terminology.StandardReport;

/**
 * 
 * project: CCHT
 * @author vhaisakatikm
 */
public class AbstractCompletedReport extends AbstractKeyedEntity<Object> {

	private static final long serialVersionUID = -6669218898281850898L;

	// The StandardReport type this complete report belongs to
	private StandardReport standardReport;
	private ReportExportedType fileType;
	private Date fromDate;
	private Date toDate;
	private Date asOfDate;
	private String reportName;
	private String reportParameterText;
	private String userName;	
	private Date completedDate;	
	private Date inactivatedDate;
	private Date expirationDate;
	@Formula(value = "(select isnull(u.last_name,'') + ', ' + isnull(u.first_name,'')+' ' + isnull(u.middle_name,'') from ht.app_user u where u.user_name = report_generated_by)")
	private String userFullName;
	public StandardReport getStandardReport() {
		return standardReport;
	}
	public void setStandardReport(StandardReport standardReport) {
		this.standardReport = standardReport;
	}
	public ReportExportedType getFileType() {
		return fileType;
	}
	public void setFileType(ReportExportedType fileType) {
		this.fileType = fileType;
	}
	public Date getFromDate() {
		return fromDate;
	}
	public void setFromDate(Date fromDate) {
		this.fromDate = fromDate;
	}
	public Date getToDate() {
		return toDate;
	}
	public void setToDate(Date toDate) {
		this.toDate = toDate;
	}
	public Date getAsOfDate() {
		return asOfDate;
	}
	public void setAsOfDate(Date asOfDate) {
		this.asOfDate = asOfDate;
	}
	public String getReportName() {
		return reportName;
	}
	public void setReportName(String reportName) {
		this.reportName = reportName;
	}
	public String getReportParameterText() {
		return reportParameterText;
	}
	public void setReportParameterText(String reportParameterText) {
		this.reportParameterText = reportParameterText;
	}
	public String getUserName() {
		return userName;
	}
	public void setUserName(String userName) {
		this.userName = userName;
	}
	public Date getCompletedDate() {
		return completedDate;
	}
	public void setCompletedDate(Date completedDate) {
		this.completedDate = completedDate;
	}
	public Date getInactivatedDate() {
		return inactivatedDate;
	}
	public void setInactivatedDate(Date inactivatedDate) {
		this.inactivatedDate = inactivatedDate;
	}
	public Date getExpirationDate() {
		return expirationDate;
	}
	public void setExpirationDate(Date expirationDate) {
		this.expirationDate = expirationDate;
	}
	public String getUserFullName() {
		return (StringUtils.isEmpty(userFullName) || ",".equals(userFullName.trim())) ? getUserName()
				: userFullName;
	}
	public void setUserFullName(String userFullName) {
		this.userFullName = userFullName;
	}
}
