package gov.va.med.ccht.model.qir;

import java.util.Date;

import org.hibernate.annotations.Formula;

import gov.va.med.fw.model.AbstractKeyedEntity;

public class QIRVendorAction extends AbstractKeyedEntity<QIRVendorAction> implements Comparable<QIRVendorAction> {

	private static final long serialVersionUID = 2038051979369117881L;

	private QIR qir = null;
	private Date date = null;
	private String action = null;
	@Formula(value = "(select isnull(u.last_name,'') + ', ' + isnull(u.first_name,'')+' ' + isnull(u.middle_name,'') from ht.app_user u where u.user_name = RECORD_CREATED_BY)")	
	private String submittedByName = null;	
	
	public QIR getQir() {
		return qir;
	}
	public void setQir(QIR qir) {
		this.qir = qir;
	}
	public Date getDate() {
		return date;
	}
	public void setDate(Date date) {
		this.date = date;
	}
	public String getAction() {
		return action;
	}
	public void setAction(String action) {
		this.action = action;
	}
	public String getSubmittedByName() {
		return submittedByName;
	}
	public void setSubmittedByName(String submittedByName) {
		this.submittedByName = submittedByName;
	}
	@Override
	public int compareTo(QIRVendorAction o) {
		if (o != null) {
			QIRVendorAction other = (QIRVendorAction) o;
			Date otherDate = other.getDate();			
			if (otherDate == null || date == null)
				return 0; // no date not an expected scenario
			return date.compareTo(otherDate);
		}
		return 0;
	}
}
