/**
 * 
 */
package gov.va.med.ccht.model.qir;

import gov.va.med.fw.model.AbstractKeyedEntity;

import java.util.Date;

import org.hibernate.annotations.Formula;

/**
 * @author vhaisakatikm
 *
 */
public class QIRRemarks extends AbstractKeyedEntity<QIRRemarks> implements Comparable<QIRRemarks> {

	private static final long serialVersionUID = -1399695570991831091L;
	
	private QIR qir = null;
	private Date date = null;
	private String remarks = null;
	@Formula(value = "(select isnull(u.last_name,'') + ', ' + isnull(u.first_name,'')+' ' + isnull(u.middle_name,'') from ht.app_user u where u.user_name = RECORD_CREATED_BY)")	
	private String submittedByName = null;	

	public QIR getQir() {
		return qir;
	}
	public void setQir(QIR qir) {
		this.qir = qir;
	}
	public Date getDate() {
		return date;
	}
	public void setDate(Date date) {
		this.date = date;
	}
	public String getRemarks() {
		return remarks;
	}
	public void setRemarks(String remarks) {
		this.remarks = remarks;
	}
	public String getSubmittedByName() {
		return submittedByName;
	}
	public void setSubmittedByName(String submittedByName) {
		this.submittedByName = submittedByName;
	}
	@Override
	public int compareTo(QIRRemarks o) {
		if (o != null) {
			QIRRemarks other = (QIRRemarks) o;
			Date otherDate = other.getDate();			
			if (otherDate == null || date == null)
				return 0; // no date not an expected scenario
			return date.compareTo(otherDate);
		}
		return 0;
	}	
}
