package gov.va.med.ccht.model.qir;

import gov.va.med.ccht.model.inventory.DeviceType;
import gov.va.med.ccht.model.inventory.SimpleFacility;
import gov.va.med.ccht.model.inventory.SimpleVisn;
import gov.va.med.ccht.model.inventory.Vendor;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.DateUtils;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import org.hibernate.annotations.Formula;

public class QIR extends AbstractKeyedEntity<Object> {

	private static final long serialVersionUID = 5702897702333847688L;

	
	private DmpQirType dmpQirType = null;
	private QIRType qirType = null;
	private QIRStatusType qirStatusType = null;
	private SimpleVisn visn;
	private SimpleFacility facility;
	private DeviceType deviceType = null;
	private Vendor vendor = null;
	private String serialNumber = null;
	private String purchaseOrderNumber = null;
	private Date submittedDate = new Date();	
	private Date vendorResponseDueDate = DateUtils.getDateTodayPlusDays(14);
	private Date emailReminderSentDate;
	private Date statusChangeDate = null;
	private String complaint = null;
	private String headline = null;
	private String submittedBy = null;
	@Formula(value = "(select isnull(u.last_name,'') + ', ' + isnull(u.first_name,'')+' ' + isnull(u.middle_name,'') from ht.app_user u where u.user_name = SUBMITTED_BY)")	
	private String submittedByName = null;
	@Formula(value = "(select isnull(u.first_name,'') + ' ' + isnull(u.last_name,'') from ht.app_user u where u.user_name = SUBMITTED_BY)")	
	private String emailSubmittedByName = null;
	private String modifiedByName = null;
	private String isDmpIssue = null;
	

	private Set<QIRRemarks> internalQIRRemarks = null;
	private Set<QIRVendorAction> internalQIRVendorActions = null;
	private Set<QIRSimpleAttachment> internalQIRAttachments = null;
	
	public QIRType getQirType() {
		return qirType;
	}
	public void setQirType(QIRType qirType) {
		this.qirType = qirType;
	}
	public QIRStatusType getQirStatusType() {
		return qirStatusType;
	}
	public void setQirStatusType(QIRStatusType qirStatusType) {
		this.qirStatusType = qirStatusType;
	}	
	public SimpleVisn getVisn() {
		return visn;
	}
	public void setVisn(SimpleVisn visn) {
		this.visn = visn;
	}
	public SimpleFacility getFacility() {
		return facility;
	}
	public void setFacility(SimpleFacility facility) {
		this.facility = facility;
	}
	public DeviceType getDeviceType() {
		return deviceType;
	}
	public void setDeviceType(DeviceType deviceType) {
		this.deviceType = deviceType;
	}
	public Vendor getVendor() {
		return vendor;
	}
	public void setVendor(Vendor vendor) {
		this.vendor = vendor;
	}
	public String getSerialNumber() {
		return serialNumber;
	}
	public void setSerialNumber(String serialNumber) {
		this.serialNumber = serialNumber;
	}
	public String getPurchaseOrderNumber() {
		return purchaseOrderNumber;
	}
	public void setPurchaseOrderNumber(String purchaseOrderNumber) {
		this.purchaseOrderNumber = purchaseOrderNumber;
	}
	public Date getSubmittedDate() {
		return submittedDate;
	}
	public void setSubmittedDate(Date submittedDate) {
		this.submittedDate = submittedDate;
	}
	public Date getStatusChangeDate() {
		return statusChangeDate;
	}
	public void setStatusChangeDate(Date statusChangeDate) {
		this.statusChangeDate = statusChangeDate;
	}
	public String getComplaint() {
		return complaint;
	}
	public void setComplaint(String complaint) {
		this.complaint = complaint;
	}
	public String getHeadline() {
		return headline;
	}
	public void setHeadline(String headline) {
		this.headline = headline;
	}
	public String getSubmittedBy() {
		return submittedBy;
	}
	public void setSubmittedBy(String submittedBy) {
		this.submittedBy = submittedBy;
	}
	public String getSubmittedByName() {
		return (submittedByName == null) ? submittedBy : submittedByName;
	}
	public void setSubmittedByName(String submittedByName) {
		this.submittedByName = submittedByName;
	}
	public Date getVendorResponseDueDate() {
		return vendorResponseDueDate;
	}
	public void setVendorResponseDueDate(Date vendorResponseDueDate) {
		this.vendorResponseDueDate = vendorResponseDueDate;
	}
	public String getModifiedByName() {
		return modifiedByName;
	}
	public void setModifiedByName(String modifiedByName) {
		this.modifiedByName = modifiedByName;
	}
	
	public String getIsDmpIssue() {
		return isDmpIssue;
	}
	public void setIsDmpIssue(String isDmpIssue) {
		this.isDmpIssue = isDmpIssue;
	}
	
	//get, add, remove methods for internal sets
	public Set<QIRSimpleAttachment> getAttachments() {
		return Collections.unmodifiableSet(getInternalQIRAttachments());
	}
	public void addAttachment(QIRSimpleAttachment attachment) {
		if (attachment != null) {
			attachment.setQir(this);
			getInternalQIRAttachments().add(attachment);
		}
	}
	public void removeAttachment(QIRSimpleAttachment attachment) {
		getInternalQIRAttachments().remove(attachment);
	}
	
	public Set<QIRRemarks> getRemarks() {
		return Collections.unmodifiableSet(getInternalQIRRemarks());
	}
	public void addRemarks(QIRRemarks remarks) {
		if (remarks != null) {
			remarks.setQir(this);
			getInternalQIRRemarks().add(remarks);
		}
	}	
	public void removeRemarks(QIRRemarks remarks) {
		getInternalQIRRemarks().remove(remarks);
	}
	
	public Set<QIRVendorAction> getVendorActions() {
		return Collections.unmodifiableSet(getInternalQIRVendorActions());
	}
	public void addVendorActions(QIRVendorAction vendorAction) {
		if (vendorAction != null) {
			vendorAction.setQir(this);
			getInternalQIRVendorActions().add(vendorAction);
		}
	}
	public void removeVendorActions (QIRVendorAction vendorAction) {
		getInternalQIRVendorActions().remove(vendorAction);
	}
	
	public Date getEmailReminderSentDate() {
		return emailReminderSentDate;
	}
	public void setEmailReminderSentDate(Date emailReminderSentDate) {
		this.emailReminderSentDate = emailReminderSentDate;
	}
	private Set<QIRRemarks> getInternalQIRRemarks() {
		if (internalQIRRemarks == null) 
			internalQIRRemarks = new HashSet<QIRRemarks>();
		return internalQIRRemarks;
	}
	
	
	public DmpQirType getDmpQirType() {
		return dmpQirType;
	}
	public void setDmpQirType(DmpQirType dmpQirType) {
		this.dmpQirType = dmpQirType;
	}
	@SuppressWarnings("unused")
	private void setInternalQIRRemarks(Set<QIRRemarks> internalQIRRemarks) {
		this.internalQIRRemarks = internalQIRRemarks;
	}

	private Set<QIRVendorAction> getInternalQIRVendorActions() {
		if (internalQIRVendorActions == null) 
			internalQIRVendorActions = new HashSet<QIRVendorAction>();
		return internalQIRVendorActions;
	}
	
	@SuppressWarnings("unused")
	private void setInternalQIRVendorActions(
			Set<QIRVendorAction> internalQIRVendorActions) {
		this.internalQIRVendorActions = internalQIRVendorActions;
	}

	private Set<QIRSimpleAttachment> getInternalQIRAttachments() {
		if (internalQIRAttachments == null) 
			internalQIRAttachments = new HashSet<QIRSimpleAttachment>();
		return internalQIRAttachments;
	}
	
	@SuppressWarnings("unused")
	private void setInternalQIRAttachments(Set<QIRSimpleAttachment> internalQIRAttachments) {
		this.internalQIRAttachments = internalQIRAttachments;
	}
	public String getEmailSubmittedByName() {
		return emailSubmittedByName;
	}
	public void setEmailSubmittedByName(String emailSubmittedByName) {
		this.emailSubmittedByName = emailSubmittedByName;
	}	
}
