package gov.va.med.ccht.model.inventory;

import java.sql.Date;

import gov.va.med.ccht.model.AbstractHTEntity;
import gov.va.med.fw.model.lookup.Lookup;

public class Vendor extends AbstractHTEntity implements Lookup, Comparable<Vendor> {

	private static final long serialVersionUID = -2113620350925159009L;
	
	private String name;
	private String number;
	private String email_to;
	private String email_cc;
	private Date dateActive;
	private Date dateInactive;
	
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getNumber() {
		return number;
	}
	public void setNumber(String number) {
		this.number = number;
	}
	public String getEmail_to() {
		return email_to;
	}
	public void setEmail_to(String email_to) {
		this.email_to = email_to;
	}
	public String getEmail_cc() {
		return email_cc;
	}
	public void setEmail_cc(String email_cc) {
		this.email_cc = email_cc;
	}
	@Override
	public int compareTo(Vendor o) {
		if (o == null)
			return 0;
		int c = getName().compareTo(o.getName());
		return c;
	}
	@Override
	public String getCode() {
		return this.getId().toString();
	}
	@Override
	public String getDescription() {
		return name;
	}
	public Date getDateActive() {
		return dateActive;
	}
	public void setDateActive(Date dateActive) {
		this.dateActive = dateActive;
	}
	public Date getDateInactive() {
		return dateInactive;
	}
	public void setDateInactive(Date dateInactive) {
		this.dateInactive = dateInactive;
	}
	
}
