package gov.va.med.ccht.model.inventory;

import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.util.StringUtils;

import gov.va.med.ccht.model.AbstractHTEntity;

public class SimpleFacility extends AbstractHTEntity implements Lookup, Comparable<SimpleFacility> {
	
	private static final long serialVersionUID = 1370239611581042546L;
	
	public static final SimpleFacility ALL_FACILITIES = new SimpleFacility("All Facilities");
	
	private String name;
	private SimpleVisn visn;
	private String stationNumber;
	
	public SimpleFacility () { super(); }
	
	private SimpleFacility (String name) { 
		super(); 
		this.name = name;
		this.stationNumber = name;
	}
	
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public SimpleVisn getVisn() {
		return visn;
	}
	public void setVisn(SimpleVisn visn) {
		this.visn = visn;
	}
	public String getStationNumber() {
		return stationNumber;
	}
	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}
	public String getCode() {
		return stationNumber;
	}
	public String getDescription() {
		String desc = visn == null ? "" : visn.getName();
		if (StringUtils.isNotEmpty(stationNumber)) {
			desc = desc + " Facility " + stationNumber;
		}
		desc = desc + " " + name;
		return desc.trim();
	}
	private Long getVisnId() { return visn == null ? 0 : visn.getId(); }	
	public int compareTo(SimpleFacility o) {
		if (o == null)
			return 0;
		int c = getVisnId().compareTo(o.getVisnId());
		if (c == 0) {
			return (stationNumber + name).compareTo(o.stationNumber + o.name);
		}else {
			return c;
		}
	}	
}
