/**
 * 
 */
package gov.va.med.ccht.model.inventory;


import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.util.StringUtils;

import gov.va.med.ccht.model.AbstractHTEntity;

/**
 * @author vhaisakatikm
 *
 */
public class Facility extends AbstractHTEntity implements Lookup, Comparable<Facility> {

	private static final long serialVersionUID = 3691312169279695841L;
	
	public static final Facility ALL_FACILITIES = new Facility("All Facilities");
	
	private String name;
	private Visn visn;
	private String stationNumber;
	
	public Facility() { super(); }
	private Facility (String name) {
		super();
		this.name = name;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public Visn getVisn() {
		return visn;
	}
	public void setVisn(Visn visn) {
		this.visn = visn;
	}
	public String getStationNumber() {
		return stationNumber;
	}
	public void setStationNumber(String stationNumber) {
		this.stationNumber = stationNumber;
	}
	public String getCode() {
		return stationNumber;
	}
	public String getDescription() {
		String desc = visn == null ? "" : visn.getName().trim();
		if (StringUtils.isNotEmpty(stationNumber)) {
			desc = desc + " Facility " + stationNumber;
		}
		desc = desc + " " + name;
		return desc.trim();
	}
	private Long getVisnId() { return visn == null ? 0 : visn.getId(); }	
	public int compareTo(Facility o) {
		if (o == null)
			return 0;
		int c = getVisnId().compareTo(o.getVisnId());
		if (c == 0) {
			return (stationNumber + name).compareTo(o.stationNumber + o.name);
		}else {
			return c;
		}
	}
}
