package gov.va.med.ccht.model.inventory;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import gov.va.med.fw.ui.model.TermType;

public class DeviceSearchParameters implements Serializable{

	private static final long serialVersionUID = -4138876250837208741L;
	
	public static final String DEVICE_SEARCH_TYPE_SERIAL_NUMBER = "SerialNumber";
	public static final String DEVICE_SEARCH_TYPE_PATIENT = "Patient";
	public static final String DEVICE_SEARCH_TYPE_ACTIVATION_DATE = "ActivationDate";
	public static final String DEVICE_SEARCH_TYPE_STATUS = "Status";
	public static final String DEVICE_SEARCH_TYPE_GENERIC ="Generic";
	
	private TermType searchType;
	private TermType deviceType;
	private String serialNumber;
	private String fromSerialNumber;
	private String toSerialNumber;
	private Date fromActivationDate;
	private Date toActivationDate;
	private String lastName;
	private String firstName;
	private String middleName;
	private String ssn;
	private String icn;
	private ReportWeek reportWeek;
	private List<TermType> deviceStatuses;
	private Boolean allDeviceStatuses = false;
	private TermType facility;
	private TermType careCoordinator;
	
	public TermType getSearchType() {
		return searchType;
	}
	public void setSearchType(TermType searchType) {
		this.searchType = searchType;
	}
	public TermType getDeviceType() {
		return deviceType;
	}
	public void setDeviceType(TermType deviceType) {
		this.deviceType = deviceType;
	}
	public String getSerialNumber() {
		return serialNumber;
	}
	public void setSerialNumber(String serialNumber) {
		this.serialNumber = serialNumber;
	}
	public String getFromSerialNumber() {
		return fromSerialNumber;
	}
	public void setFromSerialNumber(String fromSerialNumber) {
		this.fromSerialNumber = fromSerialNumber;
	}
	public String getToSerialNumber() {
		return toSerialNumber;
	}
	public void setToSerialNumber(String toSerialNumber) {
		this.toSerialNumber = toSerialNumber;
	}
	public Date getFromActivationDate() {
		return fromActivationDate;
	}
	public void setFromActivationDate(Date fromActivationDate) {
		this.fromActivationDate = fromActivationDate;
	}
	public Date getToActivationDate() {
		return toActivationDate;
	}
	public void setToActivationDate(Date toActivationDate) {
		this.toActivationDate = toActivationDate;
	}
	public String getLastName() {
		return lastName;
	}
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	public String getFirstName() {
		return firstName;
	}
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	public String getMiddleName() {
		return middleName;
	}
	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}
	public String getSsn() {
		return ssn;
	}
	public void setSsn(String ssn) {
		this.ssn = ssn;
	}
	public String getIcn() {
		return icn;
	}
	public void setIcn(String icn) {
		this.icn = icn;
	}
	public ReportWeek getReportWeek() {
		return reportWeek;
	}
	public void setReportWeek(ReportWeek reportWeek) {
		this.reportWeek = reportWeek;
	}
	public List<TermType> getDeviceStatuses() {
		return deviceStatuses;
	}
	public void setDeviceStatuses(List<TermType> deviceStatuses) {
		this.deviceStatuses = deviceStatuses;
	}
	public Boolean getAllDeviceStatuses() {
		return allDeviceStatuses;
	}
	public void setAllDeviceStatuses(Boolean allDeviceStatuses) {
		this.allDeviceStatuses = allDeviceStatuses;
	}
	public TermType getFacility() {
		return facility;
	}
	public void setFacility(TermType facility) {
		this.facility = facility;
	}
	public TermType getCareCoordinator() {
		return careCoordinator;
	}
	public void setCareCoordinator(TermType careCoordinator) {
		this.careCoordinator = careCoordinator;
	}
}
