/**
 * 
 */
package gov.va.med.ccht.model.inventory;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import gov.va.med.fw.model.AbstractKeyedEntity;

/**
 * @author vhaisakatikm
 *
 */
public class DeviceDetail extends AbstractKeyedEntity<Object> {

	private static final long serialVersionUID = 2931814749922760727L;

	private SimpleFacility facility = null;
	private DeviceDecommissionReason deviceDecommissionReason = null;
	private DeviceType deviceType = null;
	private String serialNumber = null;
	private String eeNumber = null;
	private String purchaseOrderNumber = null;
	private Date dateOfPurchase = null;
	private Date warrantyFromDate = null;
	private Date warrantyToDate = null;
	private Boolean multiPatientUsage = null;
	private Date lastActiveDate = null;
	private Set<DeviceStatus> internalDeviceStatuses;
	private Set<PatientDevice> internalPatientDevices;
	private Set<DeviceStatusHistory> deviceStatusHistory; //read only
	public SimpleFacility getFacility() {
		return facility;
	}
	public void setFacility(SimpleFacility facility) {
		this.facility = facility;
	}
	public DeviceDecommissionReason getDeviceDecommissionReason() {
		return deviceDecommissionReason;
	}
	public void setDeviceDecommissionReason(
			DeviceDecommissionReason deviceDecommissionReason) {
		this.deviceDecommissionReason = deviceDecommissionReason;
	}
	public DeviceType getDeviceType() {
		return deviceType;
	}
	public void setDeviceType(DeviceType deviceType) {
		this.deviceType = deviceType;
	}
	public String getSerialNumber() {
		return serialNumber;
	}
	public void setSerialNumber(String serialNumber) {
		this.serialNumber = serialNumber;
	}
	public String getEeNumber() {
		return eeNumber;
	}
	public void setEeNumber(String eeNumber) {
		this.eeNumber = eeNumber;
	}
	public String getPurchaseOrderNumber() {
		return purchaseOrderNumber;
	}
	public void setPurchaseOrderNumber(String purchaseOrderNumber) {
		this.purchaseOrderNumber = purchaseOrderNumber;
	}
	public Date getDateOfPurchase() {
		return dateOfPurchase;
	}
	public void setDateOfPurchase(Date dateOfPurchase) {
		this.dateOfPurchase = dateOfPurchase;
	}
	public Date getWarrantyFromDate() {
		return warrantyFromDate;
	}
	public void setWarrantyFromDate(Date warrantyFromDate) {
		this.warrantyFromDate = warrantyFromDate;
	}
	public Date getWarrantyToDate() {
		return warrantyToDate;
	}
	public void setWarrantyToDate(Date warrantyToDate) {
		this.warrantyToDate = warrantyToDate;
	}
	public Boolean getMultiPatientUsage() {
		return multiPatientUsage ;
	}
	public void setMultiPatientUsage(Boolean multiPatientUsage) {
		this.multiPatientUsage = multiPatientUsage ;
	}
	public Date getLastActiveDate() {
		return lastActiveDate;
	}
	public void setLastActiveDate(Date lastActiveDate) {
		this.lastActiveDate = lastActiveDate;
	}
	private Set<DeviceStatus> getInternalDeviceStatuses() {
		if (internalDeviceStatuses == null) {
			internalDeviceStatuses = new HashSet<DeviceStatus>();
		}
		return internalDeviceStatuses;
	}
	private void setInternalDeviceStatuses(Set<DeviceStatus> internalDeviceStatuses) {
		this.internalDeviceStatuses = internalDeviceStatuses;
	}
	private Set<PatientDevice> getInternalPatientDevices() {
		return internalPatientDevices;
	}
	private void setInternalPatientDevices(Set<PatientDevice> internalPatientDevices) {
		this.internalPatientDevices = internalPatientDevices;
	}
	public Set<DeviceStatusHistory> getDeviceStatusHistory() {
		return deviceStatusHistory;
	}
	private void setDeviceStatusHistory(Set<DeviceStatusHistory> deviceStatusHistory) {
		this.deviceStatusHistory = deviceStatusHistory;
	}
	public DeviceStatus getDeviceStatus() {
		return (internalDeviceStatuses == null || internalDeviceStatuses.size() == 0) ? null : 
			internalDeviceStatuses.iterator().next();
	}
	public void setDeviceStatus(DeviceStatus deviceStatus) {
		if (deviceStatus == null) {
			return;
		}
		//get current status and update if it is different
		DeviceStatus current = getDeviceStatus();
		if (current != null) {
			//merge
			current.setDeviceStatusType(deviceStatus.getDeviceStatusType());
			current.setStatusChangeDate(deviceStatus.getStatusChangeDate());
		}else {
			deviceStatus.setDeviceDetail(this);
			getInternalDeviceStatuses().add(deviceStatus);
		}
	}
/*	public String getPatientName() {	
		//Patient name not provided if it is a kiosk
		if (getMultiPatientUsage()) {
			return null;
		}
		if (internalPatientDevices != null || internalPatientDevices.size() > 0){
			PatientDevice patientDevice = internalPatientDevices.iterator().next();
			return patientDevice.getPatient().getLast_name();
		}else {
			return null;
		}
	}*/
}
