package gov.va.med.ccht.model.inventory;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;

import gov.va.med.fw.util.DateUtils;

import gov.va.med.ccht.model.report.ReportParameters;

public class DIReportParameters extends ReportParameters { //AbstractKeyedEntity {
	
	private static final long serialVersionUID = -4797684192473270806L;
	
	private String reportSummaryType;
	private ReportWeek reportWeek;
	private SimpleVisn visn;
	private Boolean allVisns = false;
	private Facility facility;
	private Boolean allFacilities = false;
	private String subTotalType;	//enum
	private Set<DeviceStatusType> deviceStatuses;
	private Boolean allDeviceStatuses = false;
	
	public Map<String, Object> getParameterMap() {
		
		SimpleDateFormat sdf = new SimpleDateFormat(DateUtils.MMDDYYYY);
		if (getUserTimeZone() != null) {
			sdf.setTimeZone(getUserTimeZone());
			// map.put("userTimeZone", userTimeZone.getID());
		}
		
		Map<String, Object> map = super.getParameterMap();
		// common parameters
		map.put("reportSummaryType", reportSummaryType);
		map.put("subTotalType", subTotalType);
		//map.put("reportWeek", reportWeek);
		
		if (reportWeek != null) {
			map.put("fromDateStr", sdf.format(reportWeek.getStartDate()));
			map.put("toDateStr", sdf.format(reportWeek.getEndDate()));		
		}
		else if (getFromDate() == null && getToDate() == null && getAsOfDate() == null) {
			map.put("asOfDateStr", sdf.format(new Date()));			
		}

		map.put("visn", getVisn() == null ? "All VISNs" : getVisn().getName());
		map.put("facility", getFacility() == null ? "All Facilities" : getFacility().getDescription());
		
		//device statuses print flag for selected statuses
		if (deviceStatuses != null && deviceStatuses.size() > 0){
			map.put("print_assigned", Boolean.FALSE);
			map.put("print_available", Boolean.FALSE);
			map.put("print_repair", Boolean.FALSE);
			map.put("print_refurbish", Boolean.FALSE);
			map.put("print_decommissioned", Boolean.FALSE);			
			map.put("print_total", (deviceStatuses.size() > 1));
			for (DeviceStatusType ds:deviceStatuses) {
				if (ds.getCode().equals(DeviceStatusType.AVAILABLE)) {
					map.put("print_available", Boolean.TRUE);
				}
				else if (ds.getCode().equals(DeviceStatusType.ASSIGNED)) {
					map.put("print_assigned", Boolean.TRUE);
				}
				else if (ds.getCode().equals(DeviceStatusType.REFURBISHED)) {
					map.put("print_refurbish", Boolean.TRUE);
				}
				else if (ds.getCode().equals(DeviceStatusType.REPAIR)) {
					map.put("print_repair", Boolean.TRUE);
				}
				else if (ds.getCode().equals(DeviceStatusType.DECOMMISSIONED)) {
					map.put("print_decommissioned", Boolean.TRUE);
				}				
			}		
		}
		return map;
	}
	
	public String getReportSummaryType() {
		return reportSummaryType;
	}
	public void setReportSummaryType(String reportSummaryType) {
		this.reportSummaryType = reportSummaryType;
	}
	public ReportWeek getReportWeek() {
		return reportWeek;
	}
	public void setReportWeek(ReportWeek reportWeek) {
		this.reportWeek = reportWeek;
	}
	public SimpleVisn getVisn() {
		return visn;
	}
	public void setVisn(SimpleVisn visn) {
		this.visn = visn;
	}
	public Facility getFacility() {
		return facility;
	}
	public void setFacility(Facility facility) {
		this.facility = facility;
	}
	public String getSubTotalType() {
		return subTotalType;
	}
	public void setSubTotalType(String subTotalType) {
		this.subTotalType = subTotalType;
	}
	public Boolean getAllVisns() {
		return allVisns;
	}
	public void setAllVisns(Boolean allVisns) {
		this.allVisns = allVisns;
	}
	public Boolean getAllFacilities() {
		return allFacilities;
	}
	public void setAllFacilities(Boolean allFacilities) {
		this.allFacilities = allFacilities;
	}
	public Set<DeviceStatusType> getDeviceStatuses() {
		return deviceStatuses;
	}
	public void setDeviceStatuses(Set<DeviceStatusType> deviceStatuses) {
		this.deviceStatuses = deviceStatuses;
	}
	public Boolean getAllDeviceStatuses() {
		return allDeviceStatuses;
	}
	public void setAllDeviceStatuses(Boolean allDeviceStatuses) {
		this.allDeviceStatuses = allDeviceStatuses;
	}
}
