package gov.va.med.ccht.model.dmpreport;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;

public class VRTwelveReportResults implements Serializable 
{

	private static final long serialVersionUID = 7311227424123456529L;

	/*
	 * The following variable are overall combined statistics for the
	 * results 
	 */
	private Double avgPhysicalScore;
	private Double avgMentalScore;
	private int totalNumberOfSurveys;
	private Integer visnId;
	private String visnName;
	
	private List<VRTwelveReportEntry> individualVRTwelveRecords;
		

	public Integer getVisnId()
	{
		return visnId;
	}

	public void setVisnId(Integer visnId)
	{
		this.visnId = visnId;
	}

	public String getVisnName()
	{
		return visnName;
	}

	public void setVisnName(String visnName)
	{
		this.visnName = visnName;
	}

	public Double getAvgPhysicalScore() {
		
		DecimalFormat df = new DecimalFormat("#.###");
		String avgPhyScore = df.format(avgPhysicalScore);
		return Double.parseDouble(avgPhyScore);
	}

	public void setAvgPhysicalScore(Double avgPhysicalScore) {
		this.avgPhysicalScore = avgPhysicalScore;
	}

	public Double getAvgMentalScore() {
		DecimalFormat df = new DecimalFormat("#.###");
		String avgMntalScore = df.format(avgMentalScore);
		return Double.parseDouble(avgMntalScore);	
	}

	public void setAvgMentalScore(Double avgMentalScore) {
		this.avgMentalScore = avgMentalScore;
	}

	public int getTotalNumberOfSurveys() {
		return totalNumberOfSurveys;
	}

	public void setTotalNumberOfSurveys(int totalRecordsReturned) {
		this.totalNumberOfSurveys = totalRecordsReturned;
	}

	public List<VRTwelveReportEntry> getIndividualVRTwelveRecords() {
		return individualVRTwelveRecords;
	}

	public void setIndividualVRTwelveRecords(
			List<VRTwelveReportEntry> individualVRTwelveRecords) {
		this.individualVRTwelveRecords = individualVRTwelveRecords;
	}
	
	
	@Override
	public String toString() {
		return "VRTwelveReportResults \n[\navgMentalScore=" + avgMentalScore
				+ "\n avgPhysicalScore=" + avgPhysicalScore
				+ "\n totalNumberOfSurveys=" + totalNumberOfSurveys  
				+ "\n totalIndividualRecords=" + individualVRTwelveRecords.size() + "\n]";
	}
	
}
