package gov.va.med.ccht.model.dmpreport;

import gov.va.med.fw.util.DateUtils;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class VRTwelveReportEntry implements Serializable 
{
	private static final long serialVersionUID = 2845281518650772851L;

	// VR Twelve Report Values
	private Double physicalScore = null;
	private Double mentalScore = null;
	private Integer numberOfSurveys = null;
	
	private Date theDate = null;
	private String theDateAsMMYYYY = null;
	private int theDatesMonth;
	private int theDatesYear;
	
	public Double getPhysicalScore() 
	{
		return physicalScore;
	}
	
	public void setPhysicalScore(Double physicalScore) 
	{
		this.physicalScore = physicalScore;
	}
	
	public Double getMentalScore() 
	{
		return mentalScore;
	}
	
	public void setMentalScore(Double mentalScore) 
	{
		this.mentalScore = mentalScore;
	}

	public Integer getNumberOfSurveys()
	{
		return numberOfSurveys;
	}

	public void setNumberOfSurveys(Integer numberOfSurveys) 
	{
		this.numberOfSurveys = numberOfSurveys;
	}

	public Date getTheDate() {
		return theDate;
	}

	public void setTheDate(Date theDate) {
		this.theDate = theDate;
	}

	public String getTheDateAsMMYYYY() {
		
		if(theDate == null)
		{
			GregorianCalendar theCal = new GregorianCalendar(theDatesYear, (theDatesMonth-1), 1);
			theDate = theCal.getTime();
			
			SimpleDateFormat formatter = new SimpleDateFormat(DateUtils.MMYYYY);
			theDateAsMMYYYY = formatter.format(theDate);			
		}
		
		return theDateAsMMYYYY;
	}

	public void setTheDateAsMMYYYY(String theDateAsMMYYYY) {
		this.theDateAsMMYYYY = theDateAsMMYYYY;
	}

	public int getTheDatesMonth() 
	{
		return theDatesMonth;
	}

	public void setTheDatesMonth(int theDatesMonth) {
		this.theDatesMonth = theDatesMonth;
	}

	public int getTheDatesYear() {
		return theDatesYear;
	}

	public void setTheDatesYear(int theDatesYear) {
		this.theDatesYear = theDatesYear;
	}
	
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		
		try
		{

			sb.append("\nphysicalScore: ");
			sb.append(getPhysicalScore());
			sb.append("\nmentalScore: ");
			sb.append(getMentalScore());
			sb.append("\nnumberOfSurveys: ");
			sb.append(numberOfSurveys);
			sb.append("\ntheDate: ");
			sb.append(theDate);
			sb.append("\ntheDateAsMMYYYY: ");
			sb.append(getTheDateAsMMYYYY());
			sb.append("\ntheDatesMonth: ");
			sb.append(theDatesMonth);
			sb.append("\ntheDatesYear: ");
			sb.append(theDatesYear);
		
		}
		catch(Exception e)
		{
			return "BAD FILE";
		}			
		return sb.toString();
	}
}
