package gov.va.med.ccht.model.dmpreport;

import java.io.Serializable;
import java.util.List;

public class SurveyDistributionSearchResult implements Serializable
{
	private static final long serialVersionUID = -6808134771039297372L;

	private List<SurveyDistributionEntry> surveyDistributionEntries = null;
	private boolean showIVRColumn = false;
	private boolean showHomeDeviceColumn = false;
	private boolean showBrowserColumn = false;
	private Integer totalNumOfSurveys = 0;
	
	public Integer getTotalNumOfSurveys()
	{
		return totalNumOfSurveys;
	}

	public void setTotalNumOfSurveys(Integer totalNumOfSurveys)
	{
		this.totalNumOfSurveys = totalNumOfSurveys;
	}

	public void addToTotal(Integer reportsToAdd)
	{
		totalNumOfSurveys += reportsToAdd;
	}
	
	public List<SurveyDistributionEntry> getSurveyDistributionEntries()
	{
		return surveyDistributionEntries;
	}
	public void setSurveyDistributionEntries(
			List<SurveyDistributionEntry> surveyDistributionEntries)
	{
		this.surveyDistributionEntries = surveyDistributionEntries;
	}
	public boolean isShowIVRColumn()
	{
		return showIVRColumn;
	}
	public void setShowIVRColumn(boolean showIVRColumn)
	{
		this.showIVRColumn = showIVRColumn;
	}
	public boolean isShowHomeDeviceColumn()
	{
		return showHomeDeviceColumn;
	}
	public void setShowHomeDeviceColumn(boolean showHomeDeviceColumn)
	{
		this.showHomeDeviceColumn = showHomeDeviceColumn;
	}
	public boolean isShowBrowserColumn()
	{
		return showBrowserColumn;
	}
	public void setShowBrowserColumn(boolean showBrowserColumn)
	{
		this.showBrowserColumn = showBrowserColumn;
	}
}
