package gov.va.med.ccht.model.dmpreport;

import java.io.Serializable;

public class SurveyDistributionEntry implements Serializable
{
	private static final long serialVersionUID = -7803943871078069009L;
	
	private Integer visnId;
	private Integer facilityId;
	private String facilityName;
	private String visnName;
	private String vendorName;
	private Integer totalNumberOfSurveys;
	private Integer totalIVRSurveys;
	private Integer totalHomeDeviceSurveys;
	private Integer totalBrowserSurveys;
	
	
	public Integer getVisnId()
	{
		return visnId;
	}
	public void setVisnId(Integer visnId)
	{
		this.visnId = visnId;
	}
	public Integer getFacilityId()
	{
		return facilityId;
	}
	public void setFacilityId(Integer facilityId)
	{
		this.facilityId = facilityId;
	}
	

	
	
	
	public String getFacilityName()
	{
		return facilityName;
	}
	public void setFacilityName(String facilityName)
	{
		this.facilityName = facilityName;
	}
	public String getVisnName()
	{
		return visnName;
	}
	public void setVisnName(String visnName)
	{
		this.visnName = visnName;
	}
	public String getVendorName()
	{
		return vendorName;
	}
	public void setVendorName(String vendorName)
	{
		this.vendorName = vendorName;
	}
	public Integer getTotalNumberOfSurveys()
	{
		if(totalIVRSurveys == null)
		{
			totalIVRSurveys = 0;
		}
		
		if(totalHomeDeviceSurveys == null)
		{
			totalHomeDeviceSurveys = 0;
		}
		
		if(totalBrowserSurveys == null)
		{
			totalBrowserSurveys = 0;
		}
		
		if(totalNumberOfSurveys == null || totalNumberOfSurveys <= 0)
		{
			totalNumberOfSurveys = totalIVRSurveys + totalHomeDeviceSurveys + totalBrowserSurveys;
		}		
		return totalNumberOfSurveys;
	}
	public void setTotalNumberOfSurveys(Integer totalNumberOfSurveys)
	{
		this.totalNumberOfSurveys = totalNumberOfSurveys;
	}
	public Integer getTotalIVRSurveys()
	{
		return totalIVRSurveys;
	}
	public void setTotalIVRSurveys(Integer totalIVRSurveys)
	{
		this.totalIVRSurveys = totalIVRSurveys;
	}
	public Integer getTotalHomeDeviceSurveys()
	{
		return totalHomeDeviceSurveys;
	}
	public void setTotalHomeDeviceSurveys(Integer totalHomeDeviceSurveys)
	{
		this.totalHomeDeviceSurveys = totalHomeDeviceSurveys;
	}
	public Integer getTotalBrowserSurveys() 
	{
		if(totalBrowserSurveys == null)
		{
			return 0;
		}
		else
		{
			return totalBrowserSurveys;
		}
	}
	public void setTotalBrowserSurveys(Integer totalBrowserSurveys) 
	{
		this.totalBrowserSurveys = totalBrowserSurveys;
	}
	
	
	@Override
	public int hashCode()
	{
		final int prime = 31;
		int result = 1;
		result = prime
				* result
				+ ((totalHomeDeviceSurveys == null) ? 0
						: totalHomeDeviceSurveys.hashCode());
		result = prime * result
				+ ((totalIVRSurveys == null) ? 0 : totalIVRSurveys.hashCode());
		result = prime
				* result
				+ ((totalNumberOfSurveys == null) ? 0 : totalNumberOfSurveys
						.hashCode());
		result = prime * result
				+ ((vendorName == null) ? 0 : vendorName.hashCode());
		return result;
	}
	@Override
	public boolean equals(Object obj)
	{
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SurveyDistributionEntry other = (SurveyDistributionEntry) obj;
		if (totalHomeDeviceSurveys == null)
		{
			if (other.totalHomeDeviceSurveys != null)
				return false;
		} else if (!totalHomeDeviceSurveys.equals(other.totalHomeDeviceSurveys))
			return false;
		if (totalIVRSurveys == null)
		{
			if (other.totalIVRSurveys != null)
				return false;
		} else if (!totalIVRSurveys.equals(other.totalIVRSurveys))
			return false;
		if (totalNumberOfSurveys == null)
		{
			if (other.totalNumberOfSurveys != null)
				return false;
		} else if (!totalNumberOfSurveys.equals(other.totalNumberOfSurveys))
			return false;
		if (vendorName == null)
		{
			if (other.vendorName != null)
				return false;
		} else if (!vendorName.equals(other.vendorName))
			return false;
		return true;
	}
	@Override
	public String toString()
	{
		StringBuilder builder = new StringBuilder();
		//builder.append("VendorDistributionEntry [totalHomeDeviceSurveys=");
		builder.append("VISN ID: ");
		builder.append(visnId);
		builder.append("\nVisn Name: ");
		builder.append(visnName);
		builder.append("\nVendor Name: ");
		builder.append(vendorName);		
		builder.append("\nHome Device Surveys: ");
		builder.append(totalHomeDeviceSurveys);
		builder.append("\nIVR Surveys: ");
		builder.append(totalIVRSurveys);
		builder.append("\nBrowser Surveys: ");
		builder.append(totalBrowserSurveys);
		builder.append("\nTotal Surveys: ");
		builder.append(totalNumberOfSurveys);

		
		return builder.toString();
	}
	
	
	
	

}
