package gov.va.med.ccht.model.dmpreport;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PSSQuestionManager implements Serializable
{
	
	private static final long serialVersionUID = -5064884520576449420L;
	private final int VR_TWELVE_REPORT = 1;
	private final int VER_ONE_REPORT = 2;
	private final int VER_TWO_REPORT = 3;
	private String VRTwelveHeader = "<p class='pageheading'>VR-12 Survey</p>";
	private String vaSealPic = "<p><img width='94' height='94' hspace='608' src='./images/VAseal.jpg'></img></p>";
	private String VRTwelveSubHeader = "<br/><br/><br/><p class='headertext'><span class='colorblue'>VETERANS</span> RAND SF-12 (VR-12) SURVEY</p><br/>";	
	private String generalIntroPartOne = "<p>We would like to ask you a few general questions on how well you are getting along. We would greatly appreciate your taking a few minutes to answer these twelve questions.</p><br/>";
	//private String generalIntroPartTwo = " questions.</p>"; 
	private String questionContent = "<br/><p class='questionairretext'>Questionnaire Content</p>";
	private Integer version;
	
	private String questions;
	private List<PSSQuestion> questionsList = new ArrayList<PSSQuestion>();
	
	public void setVersion(Integer version)
	{
		this.version = version;
	}
	
	public Integer getVersion()
	{
		return version;
	}
	
	public void setQuestionList(List<PSSQuestion> pssQuestions)
	{
		this.questionsList = pssQuestions;
	}
	
	public List<PSSQuestion> getQuestionList()
	{
		return questionsList;
	}
	
	public String getQuestions()
	{
		String questions = null;
		switch(version.intValue())
		{
		case VR_TWELVE_REPORT:
			questions = getVrTwelveQuestions();
			break;
		case VER_ONE_REPORT:
			questions = getVerOneQuestions();
			break;
		case VER_TWO_REPORT:
			questions = getVerTwoQuestions();
			break;
		}
		
		return questions;
	}

	public void setQuestions(String questions)
	{
		this.questions = questions;
	}
	
	private String getVrTwelveQuestions()
	{
		StringBuilder sb = new StringBuilder();
		sb.append("<body>");
		sb.append(VRTwelveHeader);
		
		sb.append(VRTwelveSubHeader);
		sb.append(generalIntroPartOne);
		sb.append(questionContent);		
		sb.append(questionsList.get(0).toString(true));
		sb.append("<br/><p>The following two questions are about activities you might do <u>during a typical day</u>. Does <i>your health now limit</i> <i>you</i> in these activities? If so, how much?</p>");
		sb.append(questionsList.get(1).toString(true));
		sb.append(questionsList.get(2).toString(true));
		
		sb.append("<br/><p><u>During the past 4 weeks</u>, have you had any of the following problems with your work or other regular daily activities <i>as a result of your physical health</i>?</p>");
		sb.append(questionsList.get(3).toString(true));
		sb.append(questionsList.get(4).toString(true));

		sb.append("<br/><p><u>During the past 4 weeks</u>, have you had any of the following problems with your work or other regular daily activities <i>as a result of any emotional problems (such as feeling depressed or anxious)?</i></p>");
		sb.append(questionsList.get(5).toString(true));
		sb.append(questionsList.get(6).toString(true));
		sb.append(questionsList.get(7).toString(true));

		sb.append("<br/><p>These three questions are about how you feel and how things have been with you <u>during the past 4 weeks</u>. For each question, please give the one answer that comes closest to the way you have been feeling.");
		sb.append("<br/>How much of the time during the past 4 weeks:</p>");
		sb.append(questionsList.get(8).toString(true));
		sb.append(questionsList.get(9).toString(true));
		sb.append(questionsList.get(10).toString(true));
		sb.append(questionsList.get(11).toString(true));
		sb.append("</body>");
		return sb.toString();
	}
	
	private String getVerOneQuestions()
	{
		StringBuilder sb = new StringBuilder();
		
		sb.append("<p class='pageheading'>Patient Satisfaction Survey Ver. 1.0</p>");
		
		sb.append("<br/><br/><br/><p class='headertext'>CCHT Patient Satisfaction Survey Ver.1.0</p><br/>");
		
		sb.append("<p>It is important that we know what you think about the value of our Care Coordination program. It will help us learn how we can improve care to all veterans. We would greatly appreciate your taking a few minutes to answer eight questions.</p><br/>");

		sb.append("<p>Before you get started on the survey, we would like to clear up a few things:</p><br/>");

		sb.append("<p>You may know the Care Coordination program as the Home Telehealth program. It is the program that provided you with this device.</p><br/>"); 

		sb.append("<p>The Care Coordinator is the person that calls you as follow-up to your answers on this device.</p><br/>");

		sb.append("<p>Now let's begin the survey. Please enter 'continue'.</p><br/>");

		sb.append("<p>**Notes: </p>");

		sb.append("<ol>");
		sb.append("<li>All of the following questions and answers are on the OMB approved questions list.</li>");
		sb.append("<li>The numbers in parentheses are how the response will be scored in the database.</li>");
		sb.append("</ol><br/>");
		
				
		sb.append(questionContent);
		
		for(PSSQuestion question : questionsList)
		{
			sb.append(question.toString(false));
		}		
		return sb.toString();

	}
	
	private String getVerTwoQuestions()
	{
		StringBuilder sb = new StringBuilder();
		
		sb.append("<p class='pageheading'>Patient Satisfaction Survey Ver. 2.0</p>");
		
		sb.append("<br/><br/><br/><p class='vrtwoheadertext'>Telehealth Services - Home Telehealth (HT)</p>");
		sb.append("<p class='vrtwoheadertext'>Patient Satisfaction Survey</p>");
		sb.append("<p class='vrtwoheadertext'>VA Form 10-0481       OMB 2900-0766</p>");
		
		sb.append("<br/><p class='headertext'>Home Telehealth Patient Satisfaction Survey (Ver 2.0)</p>");

		sb.append("<br/><p>Dear Veteran Patient, </p>");

		sb.append("<p>It is very important that we know what you think about the Home Telehealth program. Your responses to this electronic survey will help us learn how we can improve our care to all veterans. We would greatly appreciate you taking a few minutes to complete the electronic satisfaction survey either on your telehealth device or through the Interactive Voice Response technology, whichever has been assigned to you.</p>");

		sb.append("<br/><p>First, we'd like you to know:</p>");

		sb.append("<ul>");
		sb.append("<li>Your device or the Interactive Voice Response technology will send the satisfaction survey to you about 30 days following your enrollment into the HT program and then will occur about every 90 days after that.</li>");
		sb.append("<li>Your responses to the satisfaction survey questions are transmitted electronically to the vendor's server (which is located behind the VA firewall) to a special dataset where VA Information Technology staff analyze and combine all responses into a report.</li>");
		sb.append("<li>Your responses are confidential and are not viewable by your care coordinator at any time.</li>");
		sb.append("<li>You may choose to not answer the satisfaction survey questions each time they are presented on your device or electronically through the Interactive Voice Response technology.</li>");
		sb.append("<li>Even if you choose not to participate in the satisfaction survey at any time, you must continue to respond to your daily health questions that are presented to you.</li>");
		sb.append("<li>Please remember that your responses are important information to help us improve care to all veterans</li>");
		sb.append("</ul>");
		
		sb.append("<br/><p>Thank you for your time.</p>");
		
		sb.append("<br/><br/><br/><p class='ombtext'><i>OMB 2900-0766</i></p>");
		sb.append("<p class='burdentext'><i>Estimated Burden 1.5 min.</i></p>");
		sb.append("<br/><p class='headertext'>Home Telehealth (HT) Patient Satisfaction Survey </p>");
		
		sb.append("<p class='paperworkreductiontext'><span style='font-weight:bold;'>THE PAPERWORK REDUCTION ACT OF 1995</span> requires us to notify you that this information collected is in accordance with the clearance requirements of section 3507 of this Act. The public reporting burden for this collection of information is estimated to average 1.5<br/> minutes per response, including the time for reviewing instructions, searching existing data sources, gathering and maintaining the data needed, and completing and reviewing the collection of information. No person will be penalized for failing to furnish this information if it<br/> does not display a current valid OMB control number. This collection of information is intended to fulfill the need identified by the Department of Veterans Affairs in their call for evaluation and improvements to the current Patient Satisfaction program. Your obligation to<br/> respond to this survey is voluntary and failure to furnish this information will have no effect on any of your benefits.</p>");
		
		for(PSSQuestion question : questionsList)
		{
			sb.append(question.toString(false));
		}		
		
		sb.append("<br/><p class='vertwofootertext'>VA Form 10-0481 December 2009</p>");
		return sb.toString();

	}
}
