package gov.va.med.ccht.model.dmpreport;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PSSQuestion implements Serializable
{
	private static final long serialVersionUID = 4491228654575652543L;

	private Integer questionNumber;
	private String questionText;
	private List<PSSQuestionChoice> choices;
	public Integer getQuestionNumber()
	{
		return questionNumber;
	}
	public void setQuestionNumber(Integer questionNumber)
	{
		this.questionNumber = questionNumber;
	}
	public String getQuestionText()
	{
		return questionText;
	}
	public void setQuestionText(String questionText)
	{
		this.questionText = questionText;
	}
	public List<PSSQuestionChoice> getChoices()
	{
		return choices;
	}
	public void setChoices(List<PSSQuestionChoice> choices)
	{
		this.choices = choices;
	}
	
	public void addChoice(PSSQuestionChoice choice)
	{
		if(choices == null)
		{
			choices = new ArrayList<PSSQuestionChoice>();
		}
		
		choices.add(choice);
	}
	

	public String toString(boolean appendChoiceNumber)
	{
		StringBuilder sb = new StringBuilder();
		
		sb.append("<br/><p>");
		sb.append(questionNumber);
		sb.append(". ");
		sb.append(questionText);
		sb.append("</p>");
		
		sb.append("<ul>");
		for(PSSQuestionChoice choice : choices)
		{
			sb.append(choice.toString(appendChoiceNumber));
		}
		sb.append("</ul>");
		return sb.toString();
	}
	
}
