package gov.va.med.ccht.model.dmp;

import gov.va.med.fw.ui.model.TermType;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class PatientSatSurveyReportParameters implements Serializable {

	// Report Types
	public final int REPORT_BY_NATIONAL_SURVEY = 0;
	public final int REPORT_BY_VISN_SURVEY = 1;
	public final int REPORT_BY_FACILITY_SURVEY = 2;
	
	
	private static final long serialVersionUID = 5433648766882417490L;
	
	private String id;
	
	// Selected Parameters
	private Date submittedFromDate = new Date();
	private Date submittedToDate = new Date();
	private int selectedReportType;	
	private int selectedChartType;
	private int selectedSurvey;
	private int patientSatisfactionVersion;
	
	private TermType visn = new TermType();	
	private TermType facility = new TermType();
	private TermType vendor = new TermType();
	private String modality;
	private List<Integer> selectedQuestions;
	

	public String getId() 
	{
		return id;
	}


	public void setId(String id) 
	{
		this.id = id;
	}


	public Date getSubmittedFromDate() 
	{
		return submittedFromDate;
	}


	public void setSubmittedFromDate(Date submittedFromDate) 
	{
		this.submittedFromDate = submittedFromDate;
	}


	public Date getSubmittedToDate() 
	{
		return submittedToDate;
	}


	public void setSubmittedToDate(Date submittedToDate) 
	{
		this.submittedToDate = submittedToDate;
	}


	public int getSelectedReportType() 
	{
		return selectedReportType;
	}


	public void setSelectedReportType(int selectedReportType) 
	{
		this.selectedReportType = selectedReportType;
	}


	public int getSelectedChartType() 
	{
		return selectedChartType;
	}


	public void setSelectedChartType(int selectedChartType) 
	{
		this.selectedChartType = selectedChartType;
	}


	public int getSelectedSurvey() 
	{
		return selectedSurvey;
	}


	public void setSelectedSurvey(int selectedSurvey) 
	{
		this.selectedSurvey = selectedSurvey;
	}


	public int getPatientSatisfactionVersion() 
	{
		return patientSatisfactionVersion;
	}


	public void setPatientSatisfactionVersion(int patientSatisfactionVersion) 
	{
		this.patientSatisfactionVersion = patientSatisfactionVersion;
	}


	public TermType getVisn() 
	{
		return visn;
	}


	public void setVisn(TermType visn) 
	{
		this.visn = visn;
	}


	public TermType getFacility() 
	{
		return facility;
	}


	public void setFacility(TermType facility) 
	{
		this.facility = facility;
	}


	public TermType getVendor() 
	{
		return vendor;
	}


	public void setVendor(TermType vendor) 
	{
		this.vendor = vendor;
	}


	public String getModality() 
	{
		return modality;
	}


	public void setModality(String modality) 
	{
		this.modality = modality;
	}
	

	public List<Integer> getSelectedQuestions() 
	{
		return selectedQuestions;
	}


	public void setSelectedQuestions(List<Integer> selectedQuestions) 
	{
		this.selectedQuestions = selectedQuestions;
	}	

	@Override
	public String toString() 
	{
		StringBuilder builder = new StringBuilder();
		builder.append("PatientSatSurveyReportParams \n[\nfacility=");
		
		if(facility != null)
		{
			builder.append(facility.getValue());
		}
		else
		{
			builder.append("NOT SELECTED");
		}
		
		builder.append(",\n id=");
		builder.append(id);
		builder.append(",\n modality=");
		builder.append(modality);
		builder.append(",\n patientSatisfactionVersion=");
		builder.append(patientSatisfactionVersion);
		builder.append(",\n selectedChartType=");
		builder.append(selectedChartType);
		builder.append(",\n selectedReportType=");
		builder.append(selectedReportType);
		builder.append(",\n selectedSurvey=");
		builder.append(selectedSurvey);
		builder.append(",\n submittedFromDate=");
		builder.append(submittedFromDate);
		builder.append(",\n submittedToDate=");
		builder.append(submittedToDate);
		
		builder.append(",\n selectedQuestions=");
		builder.append(selectedQuestions);

		builder.append(",\n vendor=");


		if(vendor != null)
		{
			builder.append(vendor.getValue());
		}
		else
		{
			builder.append("NOT SELECTED");
		}
		
		
		builder.append(",\n visn=");
		

		if(visn != null)
		{
			builder.append(visn.getValue());
		}
		else
		{
			builder.append("NOT SELECTED");
		}
		
		
		
		builder.append("\n]");
		return builder.toString();
	}

	
	
}
